/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.WhenClause;
import java.util.List;
import java.util.Objects;

@JsonSerialize
public record Switch(Expression operand, List<WhenClause> whenClauses, Expression defaultValue) implements Expression
{
    public Switch {
        Objects.requireNonNull(operand, "operand is null");
        whenClauses = ImmutableList.copyOf(whenClauses);
        for (WhenClause clause : whenClauses) {
            IrUtils.validateType(operand.type(), clause.getOperand());
        }
        for (int i = 1; i < whenClauses.size(); ++i) {
            IrUtils.validateType(((WhenClause)whenClauses.getFirst()).getResult().type(), ((WhenClause)whenClauses.get(i)).getResult());
        }
        IrUtils.validateType(((WhenClause)whenClauses.getFirst()).getResult().type(), defaultValue);
    }

    @Override
    public Type type() {
        return this.whenClauses.getFirst().getResult().type();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitSwitch(this, context);
    }

    @Override
    public List<? extends Expression> children() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)this.operand);
        this.whenClauses.forEach(clause -> {
            builder.add((Object)clause.getOperand());
            builder.add((Object)clause.getResult());
        });
        builder.add((Object)this.defaultValue);
        return builder.build();
    }
}

