/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class EvaluateCast
implements IrOptimizerRule {
    private final InterpretedFunctionInvoker functionInvoker;
    private final Metadata metadata;

    public EvaluateCast(PlannerContext context) {
        this.metadata = context.getMetadata();
        this.functionInvoker = new InterpretedFunctionInvoker(context.getFunctionManager());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Expression expression2;
        if (!(expression instanceof Cast)) return Optional.empty();
        Cast cast = (Cast)expression;
        try {
            expression2 = cast.expression();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(expression2 instanceof Constant)) return Optional.empty();
        Constant constant = (Constant)expression2;
        Expression type = expression2 = cast.type();
        try {
            return Optional.of(new Constant((Type)type, this.functionInvoker.invoke(this.metadata.getCoercion(constant.type(), (Type)type), session.toConnectorSession(), Collections.singletonList(constant.value()))));
        }
        catch (TrinoException trinoException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

