/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantCoalesceArguments
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Coalesce)) {
            return Optional.empty();
        }
        Coalesce coalesce = (Coalesce)expression;
        ImmutableList.Builder arguments = ImmutableList.builder();
        boolean removed = false;
        HashSet<Expression> seen = new HashSet<Expression>();
        int last = 0;
        for (int i = 0; i < coalesce.operands().size(); ++i) {
            Constant constant;
            Expression argument = coalesce.operands().get(i);
            last = i;
            if (seen.contains(argument) || argument instanceof Constant && (constant = (Constant)argument).value() == null) {
                removed = true;
            } else {
                arguments.add((Object)argument);
                if (DeterminismEvaluator.isDeterministic(argument)) {
                    seen.add(argument);
                }
            }
            if (argument instanceof Constant && (constant = (Constant)argument).value() != null) break;
        }
        if (!removed && last == coalesce.operands().size() - 1) {
            return Optional.empty();
        }
        ImmutableList newArguments = arguments.build();
        if (newArguments.isEmpty()) {
            return Optional.of(new Constant(expression.type(), null));
        }
        if (newArguments.size() == 1) {
            return Optional.of((Expression)newArguments.getFirst());
        }
        return Optional.of(new Coalesce((List<Expression>)newArguments));
    }
}

