/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantLogicalTerms
implements IrOptimizerRule {
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        if (!(expression instanceof Logical)) {
            return Optional.empty();
        }
        Logical logical = (Logical)expression;
        ImmutableList.Builder terms = ImmutableList.builder();
        boolean removed = false;
        HashSet<Expression> seen = new HashSet<Expression>();
        for (Expression term : logical.terms()) {
            if (logical.operator() == Logical.Operator.AND && term.equals(Booleans.TRUE) || logical.operator() == Logical.Operator.OR && term.equals(Booleans.FALSE) || seen.contains(term)) {
                removed = true;
                continue;
            }
            terms.add((Object)term);
            if (!DeterminismEvaluator.isDeterministic(term)) continue;
            seen.add(term);
        }
        if (!removed) {
            return Optional.empty();
        }
        ImmutableList newTerms = terms.build();
        if (newTerms.size() == 1) {
            return Optional.of((Expression)newTerms.getFirst());
        }
        return Optional.of(new Logical(logical.operator(), (List<Expression>)newTerms));
    }
}

