/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.Symbol;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SpecializeCastWithJsonParse
implements IrOptimizerRule {
    private final Metadata metadata;

    public SpecializeCastWithJsonParse(PlannerContext context) {
        this.metadata = context.getMetadata();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Optional<Expression> optional;
        Expression expression2;
        if (!(expression instanceof Cast)) return Optional.empty();
        Cast cast = (Cast)expression;
        try {
            expression2 = cast.expression();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!(expression2 instanceof Call)) return Optional.empty();
        Call call = (Call)expression2;
        Expression type = expression2 = cast.type();
        if (!call.function().name().equals((Object)GlobalFunctionCatalog.builtinFunctionName("json_parse"))) return Optional.empty();
        Expression string = call.arguments().getFirst();
        Expression expression3 = type;
        Objects.requireNonNull(expression3);
        Expression expression4 = expression3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayType.class, MapType.class, RowType.class}, (Type)expression4, n)) {
            case 0: {
                ArrayType arrayType = (ArrayType)expression4;
                optional = Optional.of(new Call(this.metadata.getCoercion(GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_array_cast"), string.type(), (Type)arrayType), call.arguments()));
                return optional;
            }
            case 1: {
                MapType mapType = (MapType)expression4;
                optional = Optional.of(new Call(this.metadata.getCoercion(GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_map_cast"), string.type(), (Type)mapType), call.arguments()));
                return optional;
            }
            case 2: {
                RowType rowType = (RowType)expression4;
                optional = Optional.of(new Call(this.metadata.getCoercion(GlobalFunctionCatalog.builtinFunctionName("$internal$json_string_to_row_cast"), string.type(), (Type)rowType), call.arguments()));
                return optional;
            }
            default: {
                optional = Optional.empty();
            }
        }
        return optional;
    }
}

