/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.spi.RefreshType;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Set;

public class IncrementalRefreshVisitor
extends PlanVisitor<Boolean, Void> {
    private static final Set<Class<? extends PlanNode>> INCREMENTALLY_REFRESHABLE_NODES = Set.of(TableScanNode.class, FilterNode.class, ProjectNode.class);

    public static RefreshType canIncrementallyRefresh(PlanNode root) {
        Boolean canIncrementallyRefresh = new IncrementalRefreshVisitor().visitPlan(root, null);
        return canIncrementallyRefresh != false ? RefreshType.INCREMENTAL : RefreshType.FULL;
    }

    @Override
    protected Boolean visitPlan(PlanNode node, Void context) {
        if (!INCREMENTALLY_REFRESHABLE_NODES.contains(node.getClass())) {
            return false;
        }
        return node.getSources().stream().allMatch(source -> source.accept(this, null));
    }
}

