/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.trino.sql.planner.Symbol;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class SymbolKeySerializer
extends JsonSerializer<Symbol> {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();

    public void serialize(Symbol value, JsonGenerator generator, SerializerProvider serializers) throws IOException {
        String name = ENCODER.encodeToString(value.name().getBytes(StandardCharsets.UTF_8));
        String type = ENCODER.encodeToString(value.type().getTypeId().getId().getBytes(StandardCharsets.UTF_8));
        generator.writeFieldName(name + ":" + type);
    }
}

