/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class AggregationDecorrelation {
    private AggregationDecorrelation() {
    }

    public static boolean isDistinctOperator(PlanNode node) {
        AggregationNode aggregationNode;
        return node instanceof AggregationNode && (aggregationNode = (AggregationNode)node).getAggregations().isEmpty() && aggregationNode.getGroupingSetCount() == 1 && aggregationNode.hasNonEmptyGroupingSet();
    }

    public static Map<Symbol, AggregationNode.Aggregation> rewriteWithMasks(Map<Symbol, AggregationNode.Aggregation> aggregations, Map<Symbol, Symbol> masks) {
        ImmutableMap.Builder rewritten = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            rewritten.put((Object)symbol, (Object)new AggregationNode.Aggregation(aggregation.getResolvedFunction(), aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter(), aggregation.getOrderingScheme(), Optional.of(masks.get(symbol))));
        }
        return rewritten.buildOrThrow();
    }

    public static AggregationNode restoreDistinctAggregation(AggregationNode distinct, PlanNode source, List<Symbol> groupingKeys) {
        Preconditions.checkArgument((boolean)AggregationDecorrelation.isDistinctOperator(distinct));
        return new AggregationNode(distinct.getId(), source, (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(groupingKeys), (List<Symbol>)ImmutableList.of(), distinct.getStep(), Optional.empty(), Optional.empty());
    }
}

