/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PruneLimitColumns
extends ProjectOffPushDownRule<LimitNode> {
    public PruneLimitColumns() {
        super(Patterns.limit());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, LimitNode limitNode, Set<Symbol> referencedOutputs) {
        ImmutableSet prunedLimitInputs = ImmutableSet.builder().addAll(referencedOutputs).addAll((Iterable)limitNode.getTiesResolvingScheme().map(OrderingScheme::orderBy).orElse((List)ImmutableList.of())).addAll(limitNode.getPreSortedInputs()).build();
        return Util.restrictChildOutputs(context.getIdAllocator(), limitNode, new Set[]{prunedLimitInputs});
    }
}

