/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;

public class RemoveRedundantIdentityProjections
implements Rule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().matching(ProjectNode::isIdentity).matching(RemoveRedundantIdentityProjections::outputsSameAsSource);

    private static boolean outputsSameAsSource(ProjectNode node) {
        return ImmutableSet.copyOf(node.getOutputSymbols()).equals((Object)ImmutableSet.copyOf(node.getSource().getOutputSymbols()));
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(project.getSource());
    }
}

