/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.Iterables;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Optional;

public class ReplaceWindowWithRowNumber
implements Rule<WindowNode> {
    private static final CatalogSchemaFunctionName ROW_NUMBER_NAME = GlobalFunctionCatalog.builtinFunctionName("row_number");
    private final Pattern<WindowNode> pattern = Patterns.window().matching(window -> {
        if (window.getWindowFunctions().size() != 1) {
            return false;
        }
        BoundSignature signature = ((WindowNode.Function)Iterables.getOnlyElement(window.getWindowFunctions().values())).getResolvedFunction().signature();
        return signature.getArgumentTypes().isEmpty() && signature.getName().equals((Object)ROW_NUMBER_NAME);
    }).matching(window -> window.getOrderingScheme().isEmpty());

    @Override
    public Pattern<WindowNode> getPattern() {
        return this.pattern;
    }

    @Override
    public Rule.Result apply(WindowNode node, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), false, (Symbol)Iterables.getOnlyElement(node.getWindowFunctions().keySet()), Optional.empty(), Optional.empty()));
    }
}

