/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.Iterables;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.SemiJoinNode;
import java.util.Optional;

public class TransformUncorrelatedInPredicateSubqueryToSemiJoin
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode().with(Pattern.empty(Patterns.Apply.correlation()));

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
        if (applyNode.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        ApplyNode.SetExpression expression = (ApplyNode.SetExpression)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().values());
        if (!(expression instanceof ApplyNode.In)) {
            return Rule.Result.empty();
        }
        ApplyNode.In inPredicate = (ApplyNode.In)expression;
        Symbol semiJoinSymbol = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().keySet());
        SemiJoinNode replacement = new SemiJoinNode(context.getIdAllocator().getNextId(), applyNode.getInput(), applyNode.getSubquery(), inPredicate.value(), inPredicate.reference(), semiJoinSymbol, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        return Rule.Result.ofPlanNode(replacement);
    }
}

