/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.LocalProperty;
import io.trino.spi.predicate.NullableValue;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.optimizations.LocalProperties;
import io.trino.util.MoreLists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ActualProperties {
    private final Global global;
    private final List<LocalProperty<Symbol>> localProperties;
    private final Map<Symbol, NullableValue> constants;

    private ActualProperties(Global global, List<? extends LocalProperty<Symbol>> localProperties, Map<Symbol, NullableValue> constants) {
        Objects.requireNonNull(global, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        Objects.requireNonNull(constants, "constants is null");
        this.global = global;
        Set localConstants = LocalProperties.extractLeadingConstants(localProperties);
        localProperties = LocalProperties.stripLeadingConstants(localProperties);
        ImmutableSet updatedLocalConstants = ImmutableSet.builder().addAll(localConstants).addAll(constants.keySet()).build();
        List updatedLocalProperties = LocalProperties.normalizeAndPrune(ImmutableList.builder().addAll(updatedLocalConstants.stream().map(ConstantProperty::new).iterator()).addAll(localProperties).build());
        this.localProperties = ImmutableList.copyOf(updatedLocalProperties);
        this.constants = ImmutableMap.copyOf(constants);
    }

    public boolean isCoordinatorOnly() {
        return this.global.isCoordinatorOnly();
    }

    public boolean isSingleNode() {
        return this.global.isSingleNode();
    }

    public boolean isNullsAndAnyReplicated() {
        return this.global.isNullsAndAnyReplicated();
    }

    public boolean isNodePartitionedOn(Collection<Symbol> columns, boolean exactly) {
        return this.isNodePartitionedOn(columns, false, exactly);
    }

    public boolean isNodePartitionedOn(Collection<Symbol> columns, boolean nullsAndAnyReplicated, boolean exactly) {
        if (exactly) {
            return this.global.isNodePartitionedOnExactly(columns, this.constants.keySet(), nullsAndAnyReplicated);
        }
        return this.global.isNodePartitionedOn(columns, this.constants.keySet(), nullsAndAnyReplicated);
    }

    public boolean isCompatibleTablePartitioningWith(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
        return this.global.isCompatibleTablePartitioningWith(partitioning, nullsAndAnyReplicated, metadata, session);
    }

    public boolean isCompatibleTablePartitioningWith(ActualProperties other, Function<Symbol, Set<Symbol>> symbolMappings, Metadata metadata, Session session) {
        return this.global.isCompatibleTablePartitioningWith(other.global, symbolMappings, symbol -> Optional.ofNullable(this.constants.get(symbol)), symbol -> Optional.ofNullable(other.constants.get(symbol)), metadata, session);
    }

    public boolean isEffectivelySinglePartition() {
        return this.global.isEffectivelySinglePartition(this.constants.keySet());
    }

    public ActualProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        return ActualProperties.builder().global(this.global.translate(new Partitioning.Translator(translator, symbol -> Optional.ofNullable(this.constants.get(symbol)), expression -> Optional.empty()))).local(LocalProperties.translate(this.localProperties, translator)).constants(this.translateConstants(translator)).build();
    }

    public ActualProperties translate(Function<Symbol, Optional<Symbol>> translator, Function<Expression, Optional<Symbol>> expressionTranslator) {
        return ActualProperties.builder().global(this.global.translate(new Partitioning.Translator(translator, symbol -> Optional.ofNullable(this.constants.get(symbol)), expressionTranslator))).local(LocalProperties.translate(this.localProperties, translator)).constants(this.translateConstants(translator)).build();
    }

    public Optional<Partitioning> getNodePartitioning() {
        return this.global.getNodePartitioning();
    }

    public Map<Symbol, NullableValue> getConstants() {
        return this.constants;
    }

    public List<LocalProperty<Symbol>> getLocalProperties() {
        return this.localProperties;
    }

    public ActualProperties withReplicatedNulls(boolean replicatedNulls) {
        return ActualProperties.builderFrom(this).global(this.global.withReplicatedNulls(replicatedNulls)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(ActualProperties properties) {
        return new Builder(properties.global, properties.localProperties, properties.constants);
    }

    private Map<Symbol, NullableValue> translateConstants(Function<Symbol, Optional<Symbol>> translator) {
        HashMap<Symbol, NullableValue> translatedConstants = new HashMap<Symbol, NullableValue>();
        for (Map.Entry<Symbol, NullableValue> entry : this.constants.entrySet()) {
            Optional<Symbol> translatedKey = translator.apply(entry.getKey());
            translatedKey.ifPresent(symbol -> translatedConstants.put((Symbol)symbol, (NullableValue)entry.getValue()));
        }
        return translatedConstants;
    }

    public int hashCode() {
        return Objects.hash(this.global, this.localProperties, this.constants.keySet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ActualProperties other = (ActualProperties)obj;
        return Objects.equals(this.global, other.global) && Objects.equals(this.localProperties, other.localProperties) && Objects.equals(this.constants.keySet(), other.constants.keySet());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("globalProperties", (Object)this.global).add("localProperties", this.localProperties).add("constants", this.constants).toString();
    }

    @Immutable
    public static final class Global {
        private final Optional<Partitioning> nodePartitioning;
        private final boolean nullsAndAnyReplicated;

        private Global(Optional<Partitioning> nodePartitioning, boolean nullsAndAnyReplicated) {
            this.nodePartitioning = Objects.requireNonNull(nodePartitioning, "nodePartitioning is null");
            this.nullsAndAnyReplicated = nullsAndAnyReplicated;
        }

        public static Global coordinatorSinglePartition() {
            return Global.partitionedOn(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, (List<Symbol>)ImmutableList.of());
        }

        public static Global singlePartition() {
            return Global.partitionedOn(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of());
        }

        public static Global arbitraryPartition() {
            return new Global(Optional.empty(), false);
        }

        public static Global partitionedOn(PartitioningHandle nodePartitioningHandle, List<Symbol> nodePartitioning) {
            return new Global(Optional.of(Partitioning.create(nodePartitioningHandle, nodePartitioning)), false);
        }

        public static Global partitionedOn(Partitioning nodePartitioning) {
            return new Global(Optional.of(nodePartitioning), false);
        }

        public Global withReplicatedNulls(boolean replicatedNulls) {
            return new Global(this.nodePartitioning, replicatedNulls);
        }

        private boolean isNullsAndAnyReplicated() {
            return this.nullsAndAnyReplicated;
        }

        private boolean isSingleNode() {
            if (this.nodePartitioning.isEmpty()) {
                return false;
            }
            return this.nodePartitioning.get().getHandle().isSingleNode();
        }

        private boolean isCoordinatorOnly() {
            if (this.nodePartitioning.isEmpty()) {
                return false;
            }
            return this.nodePartitioning.get().getHandle().isCoordinatorOnly();
        }

        private boolean isNodePartitionedOn(Collection<Symbol> columns, Set<Symbol> constants, boolean nullsAndAnyReplicated) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isPartitionedOn(columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isNodePartitionedOnExactly(Collection<Symbol> columns, Set<Symbol> constants, boolean nullsAndAnyReplicated) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isPartitionedOnExactly(columns, constants) && this.nullsAndAnyReplicated == nullsAndAnyReplicated;
        }

        private boolean isCompatibleTablePartitioningWith(Partitioning partitioning, boolean nullsAndAnyReplicated, Metadata metadata, Session session) {
            return this.nullsAndAnyReplicated == nullsAndAnyReplicated && this.nodePartitioning.isPresent() && this.nodePartitioning.get().isCompatibleWith(partitioning, metadata, session);
        }

        private boolean isCompatibleTablePartitioningWith(Global other, Function<Symbol, Set<Symbol>> symbolMappings, Function<Symbol, Optional<NullableValue>> leftConstantMapping, Function<Symbol, Optional<NullableValue>> rightConstantMapping, Metadata metadata, Session session) {
            return this.nullsAndAnyReplicated == other.nullsAndAnyReplicated && this.nodePartitioning.isPresent() && other.nodePartitioning.isPresent() && this.nodePartitioning.get().isCompatibleWith(other.nodePartitioning.get(), symbolMappings, leftConstantMapping, rightConstantMapping, metadata, session);
        }

        private Optional<Partitioning> getNodePartitioning() {
            return this.nodePartitioning;
        }

        private boolean isEffectivelySinglePartition(Set<Symbol> constants) {
            return this.nodePartitioning.isPresent() && this.nodePartitioning.get().isEffectivelySinglePartition(constants) && !this.nullsAndAnyReplicated;
        }

        private Global translate(Partitioning.Translator translator) {
            return new Global(this.nodePartitioning.flatMap(partitioning -> partitioning.translate(translator)), this.nullsAndAnyReplicated);
        }

        public int hashCode() {
            return Objects.hash(this.nodePartitioning, this.nullsAndAnyReplicated);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.nodePartitioning, other.nodePartitioning) && this.nullsAndAnyReplicated == other.nullsAndAnyReplicated;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nodePartitioning", this.nodePartitioning).add("nullsAndAnyReplicated", this.nullsAndAnyReplicated).toString();
        }
    }

    public static class Builder {
        private Global global;
        private List<LocalProperty<Symbol>> localProperties;
        private Map<Symbol, NullableValue> constants;
        private boolean unordered;

        public Builder() {
            this(Global.arbitraryPartition(), (List<LocalProperty<Symbol>>)ImmutableList.of(), (Map<Symbol, NullableValue>)ImmutableMap.of());
        }

        public Builder(Global global, List<LocalProperty<Symbol>> localProperties, Map<Symbol, NullableValue> constants) {
            this.global = Objects.requireNonNull(global, "global is null");
            this.localProperties = ImmutableList.copyOf(localProperties);
            this.constants = ImmutableMap.copyOf(constants);
        }

        public Builder global(Global global) {
            this.global = global;
            return this;
        }

        public Builder global(ActualProperties other) {
            this.global = other.global;
            return this;
        }

        public Builder local(List<? extends LocalProperty<Symbol>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder constants(Map<Symbol, NullableValue> constants) {
            this.constants = ImmutableMap.copyOf(constants);
            return this;
        }

        public Builder unordered(boolean unordered) {
            this.unordered = unordered;
            return this;
        }

        public ActualProperties build() {
            List<LocalProperty<Symbol>> localProperties = this.localProperties;
            if (this.unordered) {
                localProperties = MoreLists.filteredCopy(this.localProperties, property -> !property.isOrderSensitive());
            }
            return new ActualProperties(this.global, localProperties, this.constants);
        }
    }
}

