/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public class ApplyNode
extends PlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<Symbol> correlation;
    private final Map<Symbol, SetExpression> subqueryAssignments;
    private final Node originSubquery;

    @JsonCreator
    public ApplyNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="subqueryAssignments") Map<Symbol, SetExpression> subqueryAssignments, @JsonProperty(value="correlation") List<Symbol> correlation, @JsonProperty(value="originSubquery") Node originSubquery) {
        super(id);
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(subquery, "subquery is null");
        Objects.requireNonNull(subqueryAssignments, "subqueryAssignments is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(originSubquery, "originSubquery is null");
        Preconditions.checkArgument((boolean)input.getOutputSymbols().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        this.input = input;
        this.subquery = subquery;
        this.subqueryAssignments = subqueryAssignments;
        this.correlation = ImmutableList.copyOf(correlation);
        this.originSubquery = originSubquery;
    }

    @JsonProperty(value="input")
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty(value="subquery")
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty(value="subqueryAssignments")
    public Map<Symbol, SetExpression> getSubqueryAssignments() {
        return this.subqueryAssignments;
    }

    @JsonProperty(value="correlation")
    public List<Symbol> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty(value="originSubquery")
    public Node getOriginSubquery() {
        return this.originSubquery;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.input.getOutputSymbols()).addAll(this.subqueryAssignments.keySet()).build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitApply(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new ApplyNode(this.getId(), newChildren.get(0), newChildren.get(1), this.subqueryAssignments, this.correlation, this.originSubquery);
    }

    public static enum Quantifier {
        ALL,
        ANY,
        SOME;

    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL;

    }

    public record QuantifiedComparison(Operator operator, Quantifier quantifier, Symbol value, Symbol reference) implements SetExpression
    {
        @Override
        public List<Symbol> inputs() {
            return ImmutableList.of((Object)this.value, (Object)this.reference);
        }
    }

    public record Exists() implements SetExpression
    {
        @Override
        public List<Symbol> inputs() {
            return ImmutableList.of();
        }
    }

    public record In(Symbol value, Symbol reference) implements SetExpression
    {
        @Override
        public List<Symbol> inputs() {
            return ImmutableList.of((Object)this.value, (Object)this.reference);
        }
    }

    public static sealed interface SetExpression
    permits In, Exists, QuantifiedComparison {
        public List<Symbol> inputs();
    }
}

