/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public class DynamicFilterSourceNode
extends PlanNode {
    private final PlanNode source;
    private final Map<DynamicFilterId, Symbol> dynamicFilters;

    @JsonCreator
    public DynamicFilterSourceNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="dynamicFilters") Map<DynamicFilterId, Symbol> dynamicFilters) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.dynamicFilters = ImmutableMap.copyOf(Objects.requireNonNull(dynamicFilters, "dynamicFilters is null"));
        ImmutableSet outputSymbols = ImmutableSet.copyOf(source.getOutputSymbols());
        Preconditions.checkArgument((!outputSymbols.isEmpty() ? 1 : 0) != 0, (Object)"outputSymbols is empty");
        Preconditions.checkArgument((boolean)outputSymbols.containsAll(dynamicFilters.values()), (Object)"Dynamic filter symbols need to be part of the output symbols");
    }

    @Override
    @JsonProperty
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty
    public Map<DynamicFilterId, Symbol> getDynamicFilters() {
        return this.dynamicFilters;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDynamicFilterSource(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain 1 node");
        return new DynamicFilterSourceNode(this.getId(), newChildren.get(0), this.dynamicFilters);
    }
}

