/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ListMultimap;
import com.google.errorprone.annotations.Immutable;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.SetOperationNode;
import java.util.List;

@Immutable
public class ExceptNode
extends SetOperationNode {
    private final boolean distinct;

    public ExceptNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputToInputs") ListMultimap<Symbol, Symbol> outputToInputs, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="distinct") boolean distinct) {
        super(id, sources, outputToInputs, outputs);
        this.distinct = distinct;
    }

    @JsonProperty
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExcept(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExceptNode(this.getId(), newChildren, this.getSymbolMapping(), this.getOutputSymbols(), this.isDistinct());
    }
}

