/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.metadata.TableFunctionHandle;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.TableFunctionNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableFunctionProcessorNode
extends PlanNode {
    private final String name;
    private final List<Symbol> properOutputs;
    private final Optional<PlanNode> source;
    private final boolean pruneWhenEmpty;
    private final List<TableFunctionNode.PassThroughSpecification> passThroughSpecifications;
    private final List<List<Symbol>> requiredSymbols;
    private final Optional<Map<Symbol, Symbol>> markerSymbols;
    private final Optional<DataOrganizationSpecification> specification;
    private final Set<Symbol> prePartitioned;
    private final int preSorted;
    private final Optional<Symbol> hashSymbol;
    private final TableFunctionHandle handle;

    @JsonCreator
    public TableFunctionProcessorNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="name") String name, @JsonProperty(value="properOutputs") List<Symbol> properOutputs, @JsonProperty(value="source") Optional<PlanNode> source, @JsonProperty(value="pruneWhenEmpty") boolean pruneWhenEmpty, @JsonProperty(value="passThroughSpecifications") List<TableFunctionNode.PassThroughSpecification> passThroughSpecifications, @JsonProperty(value="requiredSymbols") List<List<Symbol>> requiredSymbols, @JsonProperty(value="markerSymbols") Optional<Map<Symbol, Symbol>> markerSymbols, @JsonProperty(value="specification") Optional<DataOrganizationSpecification> specification, @JsonProperty(value="prePartitioned") Set<Symbol> prePartitioned, @JsonProperty(value="preSorted") int preSorted, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="handle") TableFunctionHandle handle) {
        super(id);
        this.name = Objects.requireNonNull(name, "name is null");
        this.properOutputs = ImmutableList.copyOf(properOutputs);
        this.source = Objects.requireNonNull(source, "source is null");
        this.pruneWhenEmpty = pruneWhenEmpty;
        this.passThroughSpecifications = ImmutableList.copyOf(passThroughSpecifications);
        this.requiredSymbols = (List)requiredSymbols.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
        this.markerSymbols = markerSymbols.map(ImmutableMap::copyOf);
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.prePartitioned = ImmutableSet.copyOf(prePartitioned);
        Set partitionBy = (Set)specification.map(DataOrganizationSpecification::partitionBy).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
        Preconditions.checkArgument((boolean)partitionBy.containsAll(prePartitioned), (Object)"all pre-partitioned symbols must be contained in the partitioning list");
        this.preSorted = preSorted;
        Preconditions.checkArgument((specification.flatMap(DataOrganizationSpecification::orderingScheme).map(OrderingScheme::orderBy).map(List::size).orElse(0) >= preSorted ? 1 : 0) != 0, (Object)"the number of pre-sorted symbols cannot be greater than the number of all ordering symbols");
        Preconditions.checkArgument((preSorted == 0 || partitionBy.equals(prePartitioned) ? 1 : 0) != 0, (Object)"to specify pre-sorted symbols, it is required that all partitioning symbols are pre-partitioned");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        this.handle = Objects.requireNonNull(handle, "handle is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<Symbol> getProperOutputs() {
        return this.properOutputs;
    }

    @JsonProperty
    public Optional<PlanNode> getSource() {
        return this.source;
    }

    @JsonProperty
    public boolean isPruneWhenEmpty() {
        return this.pruneWhenEmpty;
    }

    @JsonProperty
    public List<TableFunctionNode.PassThroughSpecification> getPassThroughSpecifications() {
        return this.passThroughSpecifications;
    }

    @JsonProperty
    public List<List<Symbol>> getRequiredSymbols() {
        return this.requiredSymbols;
    }

    @JsonProperty
    public Optional<Map<Symbol, Symbol>> getMarkerSymbols() {
        return this.markerSymbols;
    }

    @JsonProperty
    public Optional<DataOrganizationSpecification> getSpecification() {
        return this.specification;
    }

    @JsonProperty
    public Set<Symbol> getPrePartitioned() {
        return this.prePartitioned;
    }

    @JsonProperty
    public int getPreSorted() {
        return this.preSorted;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public TableFunctionHandle getHandle() {
        return this.handle;
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return (List)this.source.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll(this.properOutputs);
        this.passThroughSpecifications.stream().map(TableFunctionNode.PassThroughSpecification::columns).flatMap(Collection::stream).map(TableFunctionNode.PassThroughColumn::symbol).forEach(arg_0 -> ((ImmutableList.Builder)symbols).add(arg_0));
        return symbols.build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunctionProcessor(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newSources) {
        Optional<PlanNode> newSource = newSources.isEmpty() ? Optional.empty() : Optional.of((PlanNode)Iterables.getOnlyElement(newSources));
        return new TableFunctionProcessorNode(this.getId(), this.name, this.properOutputs, newSource, this.pruneWhenEmpty, this.passThroughSpecifications, this.requiredSymbols, this.markerSymbols, this.specification, this.prePartitioned, this.preSorted, this.hashSymbol, this.handle);
    }
}

