/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.DoNotCall;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import java.util.Objects;

public record ConstantExpression(Object value, Type type) implements RowExpression
{
    public ConstantExpression {
        Objects.requireNonNull(type, "type is null");
        if (value != null && !Primitives.wrap((Class)type.getJavaType()).isInstance(value)) {
            throw new IllegalArgumentException("Invalid value %s of Java type %s for Trino type %s, expected instance of %s".formatted(value, value.getClass(), type, type.getJavaType()));
        }
    }

    @JsonCreator
    @DoNotCall
    public static ConstantExpression fromJson(@JsonProperty Block value, @JsonProperty Type type) {
        return new ConstantExpression(TypeUtils.readNativeValue((Type)type, (Block)value, (int)0), type);
    }

    @JsonProperty(value="value")
    public Block getBlockValue() {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)this.type, (BlockBuilder)blockBuilder, (Object)this.value);
        return blockBuilder.build();
    }

    @Override
    public String toString() {
        Object object = this.value;
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            if (this.type instanceof VarcharType || this.type instanceof CharType) {
                return slice.toStringUtf8();
            }
            return String.format("Slice(length=%s)", slice.length());
        }
        return String.valueOf(this.value);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitConstant(this, context);
    }
}

