/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class StatementRewrite {
    private final Set<Rewrite> rewrites;

    @Inject
    public StatementRewrite(Set<Rewrite> rewrites) {
        this.rewrites = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rewrites, "rewrites is null"));
    }

    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        for (Rewrite rewrite : this.rewrites) {
            node = Objects.requireNonNull(rewrite.rewrite(analyzerFactory, session, node, parameters, parameterLookup, warningCollector, planOptimizersStatsCollector), "Statement rewrite returned null");
        }
        return node;
    }

    public static interface Rewrite {
        public Statement rewrite(AnalyzerFactory var1, Session var2, Statement var3, List<Expression> var4, Map<NodeRef<Parameter>, Expression> var5, WarningCollector var6, PlanOptimizersStatsCollector var7);
    }
}

