/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.routine;

import com.google.common.hash.Hasher;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.type.Type;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.sql.routine.ir.IrBlock;
import io.trino.sql.routine.ir.IrBreak;
import io.trino.sql.routine.ir.IrContinue;
import io.trino.sql.routine.ir.IrIf;
import io.trino.sql.routine.ir.IrLabel;
import io.trino.sql.routine.ir.IrLoop;
import io.trino.sql.routine.ir.IrNodeVisitor;
import io.trino.sql.routine.ir.IrRepeat;
import io.trino.sql.routine.ir.IrReturn;
import io.trino.sql.routine.ir.IrRoutine;
import io.trino.sql.routine.ir.IrSet;
import io.trino.sql.routine.ir.IrStatement;
import io.trino.sql.routine.ir.IrVariable;
import io.trino.sql.routine.ir.IrWhile;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;

public final class SqlRoutineHash {
    private SqlRoutineHash() {
    }

    public static void hash(IrRoutine routine, Hasher hasher, BlockEncodingSerde blockEncodingSerde) {
        routine.accept(new HashRoutineIrVisitor(hasher, blockEncodingSerde), null);
    }

    private record HashRoutineIrVisitor(Hasher hasher, BlockEncodingSerde blockEncodingSerde) implements IrNodeVisitor<Void, Void>,
    RowExpressionVisitor<Void, Void>
    {
        @Override
        public Void visitRoutine(IrRoutine node, Void context) {
            this.hashClassName(node.getClass());
            this.hashType(node.returnType());
            this.hasher.putInt(node.parameters().size());
            for (IrVariable parameter : node.parameters()) {
                this.process(parameter, context);
            }
            this.process(node.body(), context);
            return null;
        }

        @Override
        public Void visitVariable(IrVariable node, Void context) {
            this.hashClassName(node.getClass());
            this.hasher.putInt(node.field());
            this.hashType(node.type());
            this.visitRowExpression(node.defaultValue());
            return null;
        }

        @Override
        public Void visitBlock(IrBlock node, Void context) {
            this.hashClassName(node.getClass());
            this.hasher.putBoolean(node.label().isPresent());
            node.label().ifPresent(this::hashLabel);
            this.hasher.putInt(node.variables().size());
            for (IrVariable variable : node.variables()) {
                this.process(variable, context);
            }
            this.hasher.putInt(node.statements().size());
            for (IrStatement statement : node.statements()) {
                this.process(statement, context);
            }
            return null;
        }

        @Override
        public Void visitBreak(IrBreak node, Void context) {
            this.hashClassName(node.getClass());
            this.hashLabel(node.target());
            return null;
        }

        @Override
        public Void visitContinue(IrContinue node, Void context) {
            this.hashClassName(node.getClass());
            this.hashLabel(node.target());
            return null;
        }

        @Override
        public Void visitIf(IrIf node, Void context) {
            this.hashClassName(node.getClass());
            this.visitRowExpression(node.condition());
            this.process(node.ifTrue(), context);
            this.hasher.putBoolean(node.ifFalse().isPresent());
            if (node.ifFalse().isPresent()) {
                this.process(node.ifFalse().get(), context);
            }
            return null;
        }

        @Override
        public Void visitWhile(IrWhile node, Void context) {
            this.hashClassName(node.getClass());
            this.hasher.putBoolean(node.label().isPresent());
            node.label().ifPresent(this::hashLabel);
            this.visitRowExpression(node.condition());
            this.process(node.body(), context);
            return null;
        }

        @Override
        public Void visitRepeat(IrRepeat node, Void context) {
            this.hashClassName(node.getClass());
            this.hasher.putBoolean(node.label().isPresent());
            node.label().ifPresent(this::hashLabel);
            this.visitRowExpression(node.condition());
            this.process(node.block(), context);
            return null;
        }

        @Override
        public Void visitLoop(IrLoop node, Void context) {
            this.hashClassName(node.getClass());
            this.hasher.putBoolean(node.label().isPresent());
            node.label().ifPresent(this::hashLabel);
            this.process(node.block(), context);
            return null;
        }

        @Override
        public Void visitReturn(IrReturn node, Void context) {
            this.hashClassName(node.getClass());
            this.visitRowExpression(node.value());
            return null;
        }

        @Override
        public Void visitSet(IrSet node, Void context) {
            this.hashClassName(node.getClass());
            this.visitRowExpression(node.value());
            this.process(node.target(), context);
            return null;
        }

        public void visitRowExpression(RowExpression expression) {
            expression.accept(this, null);
        }

        @Override
        public Void visitCall(CallExpression call, Void context) {
            this.hashClassName(call.getClass());
            this.hashResolvedFunction(call.resolvedFunction());
            this.hasher.putInt(call.arguments().size());
            call.arguments().forEach(this::visitRowExpression);
            return null;
        }

        @Override
        public Void visitInputReference(InputReferenceExpression reference, Void context) {
            this.hashClassName(reference.getClass());
            this.hasher.putInt(reference.field());
            this.hashType(reference.type());
            return null;
        }

        @Override
        public Void visitConstant(ConstantExpression literal, Void context) {
            this.hashClassName(literal.getClass());
            this.hashType(literal.type());
            Object value = literal.value();
            this.hasher.putBoolean(value == null);
            Object object = value;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, byte[].class, String.class, Slice.class}, (Object)object, n)) {
                case -1: {
                    break;
                }
                case 0: {
                    Boolean booleanValue = (Boolean)object;
                    this.hasher.putBoolean(booleanValue.booleanValue());
                    break;
                }
                case 1: {
                    Byte byteValue = (Byte)object;
                    this.hasher.putByte(byteValue.byteValue());
                    break;
                }
                case 2: {
                    Short shortValue = (Short)object;
                    this.hasher.putShort(shortValue.shortValue());
                    break;
                }
                case 3: {
                    Integer intValue = (Integer)object;
                    this.hasher.putInt(intValue.intValue());
                    break;
                }
                case 4: {
                    Long longValue = (Long)object;
                    this.hasher.putLong(longValue.longValue());
                    break;
                }
                case 5: {
                    Float floatValue = (Float)object;
                    this.hasher.putFloat(floatValue.floatValue());
                    break;
                }
                case 6: {
                    Double doubleValue = (Double)object;
                    this.hasher.putDouble(doubleValue.doubleValue());
                    break;
                }
                case 7: {
                    byte[] byteArrayValue = (byte[])object;
                    this.hasher.putBytes(byteArrayValue);
                    break;
                }
                case 8: {
                    String stringValue = (String)object;
                    this.hasher.putString((CharSequence)stringValue, StandardCharsets.UTF_8);
                    break;
                }
                case 9: {
                    Slice sliceValue = (Slice)object;
                    this.hasher.putBytes(sliceValue.getBytes());
                    break;
                }
                default: {
                    Block block = literal.getBlockValue();
                    DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(this.blockEncodingSerde.estimatedWriteSize(block)));
                    this.blockEncodingSerde.writeBlock((SliceOutput)output, block);
                    this.hasher.putBytes(output.slice().getBytes());
                }
            }
            return null;
        }

        @Override
        public Void visitLambda(LambdaDefinitionExpression lambda, Void context) {
            this.hashClassName(lambda.getClass());
            this.hasher.putInt(lambda.arguments().size());
            lambda.arguments().forEach(symbol -> {
                this.hashString(symbol.name());
                this.hashType(symbol.type());
            });
            this.visitRowExpression(lambda.body());
            return null;
        }

        @Override
        public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
            this.hashClassName(reference.getClass());
            this.hashString(reference.name());
            this.hashType(reference.type());
            return null;
        }

        @Override
        public Void visitSpecialForm(SpecialForm specialForm, Void context) {
            this.hashClassName(specialForm.getClass());
            this.hashType(specialForm.type());
            this.hasher.putInt(specialForm.form().ordinal());
            this.hasher.putInt(specialForm.arguments().size());
            specialForm.arguments().forEach(this::visitRowExpression);
            this.hasher.putInt(specialForm.functionDependencies().size());
            specialForm.functionDependencies().forEach(this::hashResolvedFunction);
            return null;
        }

        private void hashClassName(Class<?> clazz) {
            this.hashString(clazz.getName());
        }

        private void hashType(Type type) {
            this.hashString(type.toString());
        }

        private void hashLabel(IrLabel label) {
            this.hashString(label.name());
        }

        private void hashResolvedFunction(ResolvedFunction function) {
            BoundSignature signature = function.signature();
            this.hashString(signature.getName().toString());
            this.hashType(signature.getReturnType());
            this.hasher.putInt(signature.getArgumentTypes().size());
            signature.getArgumentTypes().forEach(this::hashType);
            this.hashString(function.catalogHandle().getId());
            this.hashString(function.functionId().toString());
            this.hasher.putInt(function.typeDependencies().size());
            function.typeDependencies().forEach((typeSignature, type) -> {
                this.hashString(typeSignature.toString());
                this.hashType((Type)type);
            });
            this.hasher.putInt(function.functionDependencies().size());
            function.functionDependencies().forEach(this::hashResolvedFunction);
        }

        private void hashString(String string) {
            this.hasher.putString((CharSequence)string, StandardCharsets.UTF_8);
        }
    }
}

