/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableSet;
import io.trino.client.NodeVersion;
import io.trino.metadata.InternalNode;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class TestingNodeManager
implements NodeManager {
    private static final String TEST_ENVIRONMENT = "testenv";
    private final String environment;
    private final Node localNode;
    private final Set<Node> nodes = new CopyOnWriteArraySet<Node>();
    private final boolean scheduleOnCoordinator;

    public TestingNodeManager() {
        this(TEST_ENVIRONMENT);
    }

    public TestingNodeManager(boolean scheduleOnCoordinator) {
        this(TEST_ENVIRONMENT, scheduleOnCoordinator);
    }

    public TestingNodeManager(String environment) {
        this(environment, true);
    }

    public TestingNodeManager(String environment, boolean scheduleOnCoordinator) {
        this(environment, new InternalNode("local", URI.create("local://127.0.0.1"), NodeVersion.UNKNOWN, true), (Collection<Node>)ImmutableSet.of(), scheduleOnCoordinator);
    }

    public TestingNodeManager(Node localNode) {
        this(localNode, (Collection<Node>)ImmutableSet.of());
    }

    public TestingNodeManager(List<Node> allNodes) {
        this(allNodes.iterator().next(), allNodes);
    }

    public TestingNodeManager(Node localNode, Collection<Node> otherNodes) {
        this(TEST_ENVIRONMENT, localNode, otherNodes, true);
    }

    public TestingNodeManager(String environment, Node localNode, Collection<Node> otherNodes, boolean scheduleOnCoordinator) {
        this.environment = environment;
        this.localNode = Objects.requireNonNull(localNode, "localNode is null");
        this.scheduleOnCoordinator = scheduleOnCoordinator;
        this.nodes.add(localNode);
        this.nodes.addAll(otherNodes);
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void removeNode(Node node) {
        this.nodes.remove(node);
    }

    public Set<Node> getAllNodes() {
        return this.nodes;
    }

    public Set<Node> getWorkerNodes() {
        if (this.scheduleOnCoordinator) {
            return this.nodes;
        }
        return (Set)this.nodes.stream().filter(node -> !node.isCoordinator()).collect(ImmutableSet.toImmutableSet());
    }

    public Node getCurrentNode() {
        return this.localNode;
    }

    public String getEnvironment() {
        return this.environment;
    }
}

