/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.trino.metadata.CatalogManager;
import io.trino.plugin.base.ClosingBinder;
import io.trino.spi.VersionEmbedder;
import io.trino.transaction.ForTransactionManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class InMemoryTransactionManagerModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(TransactionManagerConfig.class);
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForTransactionManager.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ScheduledExecutorService.class, ForTransactionManager.class));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, VersionEmbedder versionEmbedder, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create(config, idleCheckExecutor, catalogManager, versionEmbedder.embedVersion((Executor)finishingExecutor));
    }
}

