/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.client.IntervalYearMonth;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;

public final class IntervalYearMonthOperators {
    private IntervalYearMonthOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval year to month")
    public static long add(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval year to month")
    public static long subtract(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long multiplyByBigint(@SqlType(value="interval year to month") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long multiplyByDouble(@SqlType(value="interval year to month") long left, @SqlType(value="double") double right) {
        if (Double.isNaN(right)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot multiply by double NaN");
        }
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval year to month") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval year to month") long right) {
        if (Double.isNaN(left)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot multiply by double NaN");
        }
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval year to month")
    public static long divideByDouble(@SqlType(value="interval year to month") long left, @SqlType(value="double") double right) {
        if (Double.isNaN(right) || right == 0.0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot divide by double %s", right));
        }
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval year to month")
    public static long negate(@SqlType(value="interval year to month") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="interval year to month") long value) {
        return Slices.utf8Slice((String)IntervalYearMonth.formatMonths((int)Math.toIntExact(value)));
    }
}

