/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class Ciphers {
    private static final int AES_ENCRYPTION_KEY_BITS = 256;

    private Ciphers() {
    }

    public static SecretKey createRandomAesEncryptionKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to generate new secret key: " + e.getMessage(), (Throwable)e);
        }
    }

    public static Slice serializeAesEncryptionKey(SecretKey key) {
        Preconditions.checkArgument((boolean)key.getAlgorithm().equals("AES"), (String)"unexpected algorithm: %s", (Object)key.getAlgorithm());
        return Slices.wrappedBuffer((byte[])key.getEncoded());
    }

    public static SecretKeySpec deserializeAesEncryptionKey(Slice key) {
        return new SecretKeySpec(key.byteArray(), key.byteArrayOffset(), key.length(), "AES");
    }

    public static boolean is256BitSecretKeySpec(SecretKey key) {
        return key.getAlgorithm().equals("AES") && key.getEncoded().length == 32;
    }
}

