/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.util.SingleAccessMethodCompiler;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleHash;
import it.unimi.dsi.fastutil.doubles.DoubleOpenCustomHashSet;
import it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongSet;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenCustomHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class FastutilSetHelper {
    private FastutilSetHelper() {
    }

    public static Set<?> toFastutilHashSet(Set<?> set, Type type, MethodHandle hashCodeHandle, MethodHandle equalsHandle) {
        Objects.requireNonNull(set, "set is null");
        Objects.requireNonNull(type, "type is null");
        Class javaElementType = type.getJavaType();
        if (javaElementType == Long.TYPE) {
            return FastutilSetHelper.createSetForLongJavaType(set, type, hashCodeHandle, equalsHandle);
        }
        if (javaElementType == Double.TYPE) {
            return new DoubleOpenCustomHashSet(set, 0.25f, (DoubleHash.Strategy)new DoubleStrategy(hashCodeHandle, equalsHandle, type));
        }
        if (javaElementType == Boolean.TYPE) {
            return new BooleanOpenHashSet(set, 0.25f);
        }
        if (!type.getJavaType().isPrimitive()) {
            return new ObjectOpenCustomHashSet(set, 0.25f, (Hash.Strategy)new ObjectStrategy(hashCodeHandle, equalsHandle, type));
        }
        throw new UnsupportedOperationException("Unsupported native type in set: " + String.valueOf(type.getJavaType()) + " with type " + String.valueOf(type.getTypeSignature()));
    }

    public static boolean in(boolean booleanValue, BooleanOpenHashSet set) {
        return set.contains(booleanValue);
    }

    public static boolean in(double doubleValue, DoubleOpenCustomHashSet set) {
        return set.contains(doubleValue);
    }

    public static boolean in(long longValue, LongOpenCustomHashSet set) {
        return set.contains(longValue);
    }

    public static boolean in(long longValue, LongBitSetFilter set) {
        return set.contains(longValue);
    }

    public static boolean in(long longValue, LongOpenHashSet set) {
        return set.contains(longValue);
    }

    public static boolean in(Object objectValue, ObjectOpenCustomHashSet<?> set) {
        return set.contains(objectValue);
    }

    private static Set<Long> createSetForLongJavaType(Set<Long> values, Type type, MethodHandle hashCodeHandle, MethodHandle equalsHandle) {
        if (values.isEmpty() || !FastutilSetHelper.isDirectLongComparisonValidType(type)) {
            return new LongOpenCustomHashSet(values, 0.25f, (LongHash.Strategy)new LongStrategy(hashCodeHandle, equalsHandle, type));
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (long value : values) {
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        long setEntries = (int)Math.min(0x40000000L, HashCommon.nextPowerOfTwo((long)((long)Math.ceil((float)values.size() / 0.25f))));
        BigInteger range = BigInteger.valueOf(max).subtract(BigInteger.valueOf(min)).add(BigInteger.valueOf(1L));
        if (range.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || (long)(range.intValueExact() / 64 + 1) > setEntries) {
            return new LongOpenHashSet(values, 0.25f);
        }
        return new LongBitSetFilter(values, min, max);
    }

    private static boolean isDirectLongComparisonValidType(Type type) {
        DecimalType decimalType;
        TimestampType timestampType;
        return type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof TimeType || type instanceof DateType || type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() || type instanceof DecimalType && (decimalType = (DecimalType)type).isShort();
    }

    private static final class DoubleStrategy
    implements DoubleHash.Strategy {
        private final DoubleHashCode doubleHashCode;
        private final DoubleEquals doubleEquals;

        public DoubleStrategy(MethodHandle hashCodeHandle, MethodHandle equalsHandle, Type type) {
            Objects.requireNonNull(hashCodeHandle, "hashCodeHandle is null");
            Objects.requireNonNull(equalsHandle, "equalsHandle is null");
            Objects.requireNonNull(type, "type is null");
            this.doubleHashCode = MethodGenerator.getGeneratedMethod(type, DoubleHashCode.class, hashCodeHandle);
            this.doubleEquals = MethodGenerator.getGeneratedMethod(type, DoubleEquals.class, equalsHandle);
        }

        public int hashCode(double value) {
            return Long.hashCode(this.doubleHashCode.hashCode(value));
        }

        public boolean equals(double a, double b) {
            Boolean result = this.doubleEquals.equals(a, b);
            Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
            return result;
        }

        public static interface DoubleHashCode {
            public long hashCode(double var1);
        }

        public static interface DoubleEquals {
            public Boolean equals(double var1, double var3);
        }
    }

    private static final class ObjectStrategy
    implements Hash.Strategy<Object> {
        private final ObjectHashCode objectHashCode;
        private final ObjectEquals objectEquals;

        public ObjectStrategy(MethodHandle hashCodeHandle, MethodHandle equalsHandle, Type type) {
            Objects.requireNonNull(hashCodeHandle, "hashCodeHandle is null");
            Objects.requireNonNull(equalsHandle, "equalsHandle is null");
            Objects.requireNonNull(type, "type is null");
            this.objectHashCode = MethodGenerator.getGeneratedMethod(type, ObjectHashCode.class, hashCodeHandle.asType(MethodType.methodType(Long.TYPE, Object.class)));
            this.objectEquals = MethodGenerator.getGeneratedMethod(type, ObjectEquals.class, equalsHandle.asType(MethodType.methodType(Boolean.class, Object.class, Object.class)));
        }

        public int hashCode(Object value) {
            if (value == null) {
                return 0;
            }
            return Long.hashCode(this.objectHashCode.hashCode(value));
        }

        public boolean equals(Object a, Object b) {
            if (b == null || a == null) {
                return a == null && b == null;
            }
            Boolean result = this.objectEquals.equals(a, b);
            Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
            return result;
        }

        public static interface ObjectHashCode {
            public long hashCode(Object var1);
        }

        public static interface ObjectEquals {
            public Boolean equals(Object var1, Object var2);
        }
    }

    public static final class LongBitSetFilter
    extends AbstractLongSet {
        private final BitSet bitmask;
        private final long min;
        private final long max;
        private final int size;

        private LongBitSetFilter(Set<Long> values, long min, long max) {
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"min must be less than or equal to max");
            Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"values must not be empty");
            this.min = min;
            this.max = max;
            int range = Math.toIntExact(max - min + 1L);
            this.bitmask = new BitSet(range);
            for (long value : values) {
                this.bitmask.set((int)(value - min));
            }
            this.size = values.size();
        }

        public boolean contains(long value) {
            if (value < this.min || value > this.max) {
                return false;
            }
            return this.bitmask.get((int)(value - this.min));
        }

        public LongIterator iterator() {
            final PrimitiveIterator.OfInt iterator = this.bitmask.stream().iterator();
            return new AbstractLongIterator(this){

                public long nextLong() {
                    return iterator.nextInt();
                }

                public boolean hasNext() {
                    return iterator.hasNext();
                }
            };
        }

        public int size() {
            return this.size;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("bitmask", (Object)this.bitmask).add("min", this.min).add("max", this.max).add("size", this.size).toString();
        }
    }

    private static final class LongStrategy
    implements LongHash.Strategy {
        private final LongHashCode longHashCode;
        private final LongEquals longEquals;

        public LongStrategy(MethodHandle hashCodeHandle, MethodHandle equalsHandle, Type type) {
            Objects.requireNonNull(hashCodeHandle, "hashCodeHandle is null");
            Objects.requireNonNull(equalsHandle, "equalsHandle is null");
            Objects.requireNonNull(type, "type is null");
            this.longHashCode = MethodGenerator.getGeneratedMethod(type, LongHashCode.class, hashCodeHandle);
            this.longEquals = MethodGenerator.getGeneratedMethod(type, LongEquals.class, equalsHandle);
        }

        public int hashCode(long value) {
            return Long.hashCode(this.longHashCode.hashCode(value));
        }

        public boolean equals(long a, long b) {
            Boolean result = this.longEquals.equals(a, b);
            Verify.verifyNotNull((Object)result, (String)"result is null", (Object[])new Object[0]);
            return result;
        }

        public static interface LongHashCode {
            public long hashCode(long var1);
        }

        public static interface LongEquals {
            public Boolean equals(long var1, long var3);
        }
    }

    private static class MethodGenerator {
        private static final NonEvictableCache<MethodKey<?>, GeneratedMethod<?>> generatedMethodCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(2L, TimeUnit.HOURS));

        private MethodGenerator() {
        }

        private static <T> T getGeneratedMethod(Type type, Class<T> operatorInterface, MethodHandle methodHandle) {
            try {
                GeneratedMethod generatedMethod = (GeneratedMethod)CacheUtils.uncheckedCacheGet(generatedMethodCache, new MethodKey<T>(type, operatorInterface), () -> new GeneratedMethod(type, operatorInterface, methodHandle));
                return generatedMethod.get();
            }
            catch (UncheckedExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }

        private static class MethodKey<T> {
            private final Type type;
            private final Class<T> singleMethodInterface;

            public MethodKey(Type type, Class<T> singleMethodInterface) {
                this.type = Objects.requireNonNull(type, "type is null");
                this.singleMethodInterface = Objects.requireNonNull(singleMethodInterface, "singleMethodInterface is null");
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MethodKey that = (MethodKey)o;
                return this.type.equals((Object)that.type) && this.singleMethodInterface.equals(that.singleMethodInterface);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.singleMethodInterface);
            }
        }

        private static class GeneratedMethod<T> {
            private Type type;
            private Class<T> singleMethodInterface;
            private MethodHandle methodHandle;
            @GuardedBy(value="this")
            private T operator;

            public GeneratedMethod(Type type, Class<T> singleMethodInterface, MethodHandle methodHandle) {
                this.type = Objects.requireNonNull(type, "type is null");
                this.singleMethodInterface = Objects.requireNonNull(singleMethodInterface, "singleMethodInterface is null");
                this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            }

            public synchronized T get() {
                if (this.operator != null) {
                    return this.operator;
                }
                String suggestedClassName = this.singleMethodInterface.getSimpleName() + "_" + this.type.getDisplayName();
                this.operator = SingleAccessMethodCompiler.compileSingleAccessMethod(suggestedClassName, this.singleMethodInterface, this.methodHandle);
                this.type = null;
                this.singleMethodInterface = null;
                this.methodHandle = null;
                return this.operator;
            }
        }
    }
}

