/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.filesystem.gcs.GcsInput;
import io.trino.filesystem.gcs.GcsInputStream;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class GcsInputFile
implements TrinoInputFile {
    private final GcsLocation location;
    private final Storage storage;
    private final int readBlockSize;
    private final OptionalLong predeclaredLength;
    private final Optional<EncryptionKey> key;
    private OptionalLong length;
    private Optional<Instant> lastModified;

    public GcsInputFile(GcsLocation location, Storage storage, int readBockSize, OptionalLong predeclaredLength, Optional<Instant> lastModified, Optional<EncryptionKey> key) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        this.readBlockSize = readBockSize;
        this.predeclaredLength = Objects.requireNonNull(predeclaredLength, "length is null");
        this.length = OptionalLong.empty();
        this.lastModified = Objects.requireNonNull(lastModified, "lastModified is null");
        this.key = Objects.requireNonNull(key, "key is null");
    }

    public TrinoInput newInput() throws IOException {
        return new GcsInput(this.location, this.storage, this.readBlockSize, this.predeclaredLength, this.key);
    }

    public TrinoInputStream newStream() throws IOException {
        Blob blob = GcsUtils.getBlobOrThrow(this.storage, this.location, this.blobGetOptions());
        return new GcsInputStream(this.location, blob, this.readBlockSize, this.predeclaredLength, this.key);
    }

    public long length() throws IOException {
        if (this.predeclaredLength.isPresent()) {
            return this.predeclaredLength.getAsLong();
        }
        if (this.length.isEmpty()) {
            this.loadProperties();
        }
        return this.length.orElseThrow();
    }

    public Instant lastModified() throws IOException {
        if (this.lastModified.isEmpty()) {
            this.loadProperties();
        }
        return this.lastModified.orElseThrow();
    }

    public boolean exists() throws IOException {
        Optional<Blob> blob = GcsUtils.getBlob(this.storage, this.location, this.blobGetOptions());
        return blob.isPresent() && blob.get().exists(new Blob.BlobSourceOption[0]);
    }

    public Location location() {
        return this.location.location();
    }

    private void loadProperties() throws IOException {
        Blob blob = GcsUtils.getBlobOrThrow(this.storage, this.location, this.blobGetOptions());
        try {
            this.length = OptionalLong.of(blob.getSize());
            if (this.lastModified.isEmpty()) {
                this.lastModified = Optional.of(Instant.from(blob.getUpdateTimeOffsetDateTime()));
            }
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "fetching properties for file", this.location);
        }
    }

    /*
     * Exception decompiling
     */
    private Storage.BlobGetOption[] blobGetOptions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Storage.BlobGetOption[] lambda$blobGetOptions$1() {
        return new Storage.BlobGetOption[0];
    }
}

