/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Corresponding;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.SetOperation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Union
extends SetOperation {
    private final List<Relation> relations;

    public Union(List<Relation> relations, boolean distinct, Optional<Corresponding> corresponding) {
        this(Optional.empty(), relations, distinct, corresponding);
    }

    public Union(NodeLocation location, List<Relation> relations, boolean distinct, Optional<Corresponding> corresponding) {
        this(Optional.of(location), relations, distinct, corresponding);
    }

    private Union(Optional<NodeLocation> location, List<Relation> relations, boolean distinct, Optional<Corresponding> corresponding) {
        super(location, distinct, corresponding);
        Objects.requireNonNull(relations, "relations is null");
        Preconditions.checkArgument((relations.size() == 2 ? 1 : 0) != 0, (Object)"relations must have 2 elements");
        this.relations = ImmutableList.copyOf(relations);
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnion(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(this.relations);
        this.getCorresponding().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relations", this.relations).add("distinct", this.isDistinct()).add("corresponding", this.getCorresponding()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Union o = (Union)obj;
        return Objects.equals(this.relations, o.relations) && this.isDistinct() == o.isDistinct() && Objects.equals(this.getCorresponding(), o.getCorresponding());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relations, this.isDistinct(), this.getCorresponding());
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Union.sameClass(this, other)) {
            return false;
        }
        Union otherUnion = (Union)other;
        return this.isDistinct() == otherUnion.isDistinct() && Objects.equals(this.getCorresponding(), otherUnion.getCorresponding());
    }
}

