/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.accumulo.AccumuloConnector;
import io.trino.plugin.accumulo.AccumuloModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class AccumuloConnectorFactory
implements ConnectorFactory {
    public static final String CONNECTOR_NAME = "accumulo";

    public String getName() {
        return CONNECTOR_NAME;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(context, "context is null");
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new AccumuloModule()});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(AccumuloConnector.class);
    }
}

