/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.connector.SchemaTableName;
import java.util.Objects;

public class AccumuloView {
    private final String schema;
    private final String table;
    private final String data;
    private final SchemaTableName schemaTableName;

    @JsonCreator
    public AccumuloView(@JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="data") String data) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.data = Objects.requireNonNull(data, "data is null");
        this.schemaTableName = new SchemaTableName(schema, table);
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.table, this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccumuloView other = (AccumuloView)obj;
        return Objects.equals(this.schema, other.schema) && Objects.equals(this.table, other.table) && Objects.equals(this.data, other.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", (Object)this.schema).add("table", (Object)this.table).add("data", (Object)this.data).toString();
    }
}

