/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.accumulo.model;

import io.trino.plugin.accumulo.model.Field;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Row {
    private final List<Field> fields = new ArrayList<Field>();

    public Row() {
    }

    public Row(Row row) {
        Objects.requireNonNull(row, "row is null");
        this.fields.addAll(row.fields.stream().map(Field::new).collect(Collectors.toList()));
    }

    public Row addField(Field field) {
        Objects.requireNonNull(field, "field is null");
        this.fields.add(field);
        return this;
    }

    public Row addField(Object nativeValue, Type type) {
        Objects.requireNonNull(type, "type is null");
        this.fields.add(new Field(nativeValue, type));
        return this;
    }

    public Field getField(int i) {
        return this.fields.get(i);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public int length() {
        return this.fields.size();
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields.toArray());
    }

    public boolean equals(Object obj) {
        return obj instanceof Row && Objects.equals(this.fields, ((Row)obj).getFields());
    }

    public String toString() {
        if (this.fields.isEmpty()) {
            return "()";
        }
        StringBuilder builder = new StringBuilder("(");
        for (Field f : this.fields) {
            builder.append(f).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.append(')').toString();
    }
}

