/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.com.esri.core.geometry;

import com.linkedin.coral.com.esri.core.geometry.Geometry;
import com.linkedin.coral.com.esri.core.geometry.MultiPath;
import com.linkedin.coral.com.esri.core.geometry.MultiPathImpl;
import com.linkedin.coral.com.esri.core.geometry.Point;
import com.linkedin.coral.com.esri.core.geometry.Segment;
import com.linkedin.coral.com.esri.core.geometry.VertexDescription;
import java.io.Serializable;

public class Polyline
extends MultiPath
implements Serializable {
    private static final long serialVersionUID = 2L;

    public Polyline() {
        this.m_impl = new MultiPathImpl(false);
    }

    public Polyline(VertexDescription vd) {
        this.m_impl = new MultiPathImpl(false, vd);
    }

    public Polyline(Point start, Point end) {
        this.m_impl = new MultiPathImpl(false, start.getDescription());
        this.startPath(start);
        this.lineTo(end);
    }

    @Override
    public Geometry createInstance() {
        return new Polyline(this.getDescription());
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Geometry.Type getType() {
        return Geometry.Type.Polyline;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + this.m_impl.estimateMemorySize();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.m_impl.equals(((Polyline)other)._getImpl());
    }

    @Override
    public int hashCode() {
        return this.m_impl.hashCode();
    }

    @Override
    public void addSegment(Segment segment, boolean bStartNewPath) {
        this.m_impl.addSegment(segment, bStartNewPath);
    }

    public void interpolateAttributes(int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        this.m_impl.interpolateAttributes(from_path_index, from_point_index, to_path_index, to_point_index);
    }

    public void interpolateAttributes(int semantics, int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        this.m_impl.interpolateAttributesForSemantics(semantics, from_path_index, from_point_index, to_path_index, to_point_index);
    }
}

