/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.trace;

import com.linkedin.coral.org.slf4j.Logger;
import java.text.DecimalFormat;
import org.apache.calcite.util.NumberUtil;

public class CalciteTimingTracer {
    private static final DecimalFormat DECIMAL_FORMAT = NumberUtil.decimalFormat("###,###,###,###,###");
    private final Logger logger;
    private long lastNanoTime;

    public CalciteTimingTracer(Logger logger, String startEvent) {
        if (!logger.isDebugEnabled()) {
            this.logger = null;
            return;
        }
        this.logger = logger;
        this.lastNanoTime = System.nanoTime();
        logger.debug("{}:  elapsed nanos=0", (Object)startEvent);
    }

    public void traceTime(String event) {
        if (this.logger == null) {
            return;
        }
        long newNanoTime = System.nanoTime();
        long elapsed = newNanoTime - this.lastNanoTime;
        this.lastNanoTime = newNanoTime;
        this.logger.debug("{}:  elapsed nanos={}", (Object)event, (Object)DECIMAL_FORMAT.format(elapsed));
    }
}

