/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NodeMemoryConfig;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OptimizerConfig;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.inject.Inject;

public final class SystemSessionProperties
implements SystemSessionPropertiesProvider {
    public static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";
    public static final String JOIN_DISTRIBUTION_TYPE = "join_distribution_type";
    public static final String JOIN_MAX_BROADCAST_TABLE_SIZE = "join_max_broadcast_table_size";
    public static final String DISTRIBUTED_INDEX_JOIN = "distributed_index_join";
    public static final String HASH_PARTITION_COUNT = "hash_partition_count";
    public static final String GROUPED_EXECUTION = "grouped_execution";
    public static final String DYNAMIC_SCHEDULE_FOR_GROUPED_EXECUTION = "dynamic_schedule_for_grouped_execution";
    public static final String PREFER_STREAMING_OPERATORS = "prefer_streaming_operators";
    public static final String TASK_WRITER_COUNT = "task_writer_count";
    public static final String TASK_CONCURRENCY = "task_concurrency";
    public static final String TASK_SHARE_INDEX_LOADING = "task_share_index_loading";
    public static final String QUERY_MAX_MEMORY = "query_max_memory";
    public static final String QUERY_MAX_TOTAL_MEMORY = "query_max_total_memory";
    public static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    public static final String QUERY_MAX_PLANNING_TIME = "query_max_planning_time";
    public static final String QUERY_MAX_RUN_TIME = "query_max_run_time";
    public static final String RESOURCE_OVERCOMMIT = "resource_overcommit";
    public static final String QUERY_MAX_CPU_TIME = "query_max_cpu_time";
    public static final String QUERY_MAX_SCAN_PHYSICAL_BYTES = "query_max_scan_physical_bytes";
    public static final String QUERY_MAX_STAGE_COUNT = "query_max_stage_count";
    public static final String REDISTRIBUTE_WRITES = "redistribute_writes";
    public static final String USE_PREFERRED_WRITE_PARTITIONING = "use_preferred_write_partitioning";
    public static final String PREFERRED_WRITE_PARTITIONING_MIN_NUMBER_OF_PARTITIONS = "preferred_write_partitioning_min_number_of_partitions";
    public static final String SCALE_WRITERS = "scale_writers";
    public static final String WRITER_MIN_SIZE = "writer_min_size";
    public static final String PUSH_TABLE_WRITE_THROUGH_UNION = "push_table_write_through_union";
    public static final String EXECUTION_POLICY = "execution_policy";
    public static final String DICTIONARY_AGGREGATION = "dictionary_aggregation";
    public static final String USE_TABLE_SCAN_NODE_PARTITIONING = "use_table_scan_node_partitioning";
    public static final String TABLE_SCAN_NODE_PARTITIONING_MIN_BUCKET_TO_TASK_RATIO = "table_scan_node_partitioning_min_bucket_to_task_ratio";
    public static final String SPATIAL_JOIN = "spatial_join";
    public static final String SPATIAL_PARTITIONING_TABLE_NAME = "spatial_partitioning_table_name";
    public static final String COLOCATED_JOIN = "colocated_join";
    public static final String CONCURRENT_LIFESPANS_PER_NODE = "concurrent_lifespans_per_task";
    public static final String JOIN_REORDERING_STRATEGY = "join_reordering_strategy";
    public static final String MAX_REORDERED_JOINS = "max_reordered_joins";
    public static final String INITIAL_SPLITS_PER_NODE = "initial_splits_per_node";
    public static final String SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL = "split_concurrency_adjustment_interval";
    public static final String OPTIMIZE_METADATA_QUERIES = "optimize_metadata_queries";
    public static final String QUERY_PRIORITY = "query_priority";
    public static final String SPILL_ENABLED = "spill_enabled";
    public static final String AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT = "aggregation_operator_unspill_memory_limit";
    public static final String OPTIMIZE_DISTINCT_AGGREGATIONS = "optimize_mixed_distinct_aggregations";
    public static final String ITERATIVE_OPTIMIZER_TIMEOUT = "iterative_optimizer_timeout";
    public static final String ENABLE_FORCED_EXCHANGE_BELOW_GROUP_ID = "enable_forced_exchange_below_group_id";
    public static final String EXCHANGE_COMPRESSION = "exchange_compression";
    public static final String ENABLE_INTERMEDIATE_AGGREGATIONS = "enable_intermediate_aggregations";
    public static final String PUSH_AGGREGATION_THROUGH_OUTER_JOIN = "push_aggregation_through_outer_join";
    public static final String PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN = "push_partial_aggregation_through_join";
    public static final String PARSE_DECIMAL_LITERALS_AS_DOUBLE = "parse_decimal_literals_as_double";
    public static final String FORCE_SINGLE_NODE_OUTPUT = "force_single_node_output";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = "filter_and_project_min_output_page_size";
    public static final String FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = "filter_and_project_min_output_page_row_count";
    public static final String DISTRIBUTED_SORT = "distributed_sort";
    public static final String USE_PARTIAL_TOPN = "use_partial_topn";
    public static final String USE_PARTIAL_DISTINCT_LIMIT = "use_partial_distinct_limit";
    public static final String MAX_RECURSION_DEPTH = "max_recursion_depth";
    public static final String USE_MARK_DISTINCT = "use_mark_distinct";
    public static final String PREFER_PARTIAL_AGGREGATION = "prefer_partial_aggregation";
    public static final String OPTIMIZE_TOP_N_RANKING = "optimize_top_n_ranking";
    public static final String MAX_GROUPING_SETS = "max_grouping_sets";
    public static final String STATISTICS_CPU_TIMER_ENABLED = "statistics_cpu_timer_enabled";
    public static final String ENABLE_STATS_CALCULATOR = "enable_stats_calculator";
    public static final String STATISTICS_PRECALCULATION_FOR_PUSHDOWN_ENABLED = "statistics_precalculation_for_pushdown_enabled";
    public static final String COLLECT_PLAN_STATISTICS_FOR_ALL_QUERIES = "collect_plan_statistics_for_all_queries";
    public static final String IGNORE_STATS_CALCULATOR_FAILURES = "ignore_stats_calculator_failures";
    public static final String MAX_DRIVERS_PER_TASK = "max_drivers_per_task";
    public static final String DEFAULT_FILTER_FACTOR_ENABLED = "default_filter_factor_enabled";
    public static final String SKIP_REDUNDANT_SORT = "skip_redundant_sort";
    public static final String ALLOW_PUSHDOWN_INTO_CONNECTORS = "allow_pushdown_into_connectors";
    public static final String COMPLEX_EXPRESSION_PUSHDOWN = "complex_expression_pushdown";
    public static final String PREDICATE_PUSHDOWN_USE_TABLE_PROPERTIES = "predicate_pushdown_use_table_properties";
    public static final String LATE_MATERIALIZATION = "late_materialization";
    public static final String ENABLE_DYNAMIC_FILTERING = "enable_dynamic_filtering";
    public static final String ENABLE_COORDINATOR_DYNAMIC_FILTERS_DISTRIBUTION = "enable_coordinator_dynamic_filters_distribution";
    public static final String ENABLE_LARGE_DYNAMIC_FILTERS = "enable_large_dynamic_filters";
    public static final String QUERY_MAX_MEMORY_PER_NODE = "query_max_memory_per_node";
    public static final String QUERY_MAX_MEMORY_PER_TASK = "query_max_memory_per_task";
    public static final String IGNORE_DOWNSTREAM_PREFERENCES = "ignore_downstream_preferences";
    public static final String FILTERING_SEMI_JOIN_TO_INNER = "rewrite_filtering_semi_join_to_inner_join";
    public static final String OPTIMIZE_DUPLICATE_INSENSITIVE_JOINS = "optimize_duplicate_insensitive_joins";
    public static final String REQUIRED_WORKERS_COUNT = "required_workers_count";
    public static final String REQUIRED_WORKERS_MAX_WAIT_TIME = "required_workers_max_wait_time";
    public static final String COST_ESTIMATION_WORKER_COUNT = "cost_estimation_worker_count";
    public static final String OMIT_DATETIME_TYPE_PRECISION = "omit_datetime_type_precision";
    public static final String USE_LEGACY_WINDOW_FILTER_PUSHDOWN = "use_legacy_window_filter_pushdown";
    public static final String MAX_UNACKNOWLEDGED_SPLITS_PER_TASK = "max_unacknowledged_splits_per_task";
    public static final String MERGE_PROJECT_WITH_VALUES = "merge_project_with_values";
    public static final String TIME_ZONE_ID = "time_zone_id";
    public static final String LEGACY_CATALOG_ROLES = "legacy_catalog_roles";
    public static final String INCREMENTAL_HASH_ARRAY_LOAD_FACTOR_ENABLED = "incremental_hash_array_load_factor_enabled";
    public static final String MAX_PARTIAL_TOP_N_MEMORY = "max_partial_top_n_memory";
    public static final String RETRY_POLICY = "retry_policy";
    public static final String RETRY_ATTEMPTS = "retry_attempts";
    public static final String RETRY_INITIAL_DELAY = "retry_initial_delay";
    public static final String RETRY_MAX_DELAY = "retry_max_delay";
    public static final String HIDE_INACCESSIBLE_COLUMNS = "hide_inaccessible_columns";
    public static final String FAULT_TOLERANT_EXECUTION_TARGET_TASK_INPUT_SIZE = "fault_tolerant_execution_target_task_input_size";
    public static final String FAULT_TOLERANT_EXECUTION_MIN_TASK_SPLIT_COUNT = "fault_tolerant_execution_min_task_split_count";
    public static final String FAULT_TOLERANT_EXECUTION_TARGET_TASK_SPLIT_COUNT = "fault_tolerant_execution_target_task_split_count";
    public static final String FAULT_TOLERANT_EXECUTION_MAX_TASK_SPLIT_COUNT = "fault_tolerant_execution_max_task_split_count";
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemSessionProperties() {
        this(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig(), new OptimizerConfig(), new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig());
    }

    @Inject
    public SystemSessionProperties(QueryManagerConfig queryManagerConfig, TaskManagerConfig taskManagerConfig, MemoryManagerConfig memoryManagerConfig, FeaturesConfig featuresConfig, OptimizerConfig optimizerConfig, NodeMemoryConfig nodeMemoryConfig, DynamicFilterConfig dynamicFilterConfig, NodeSchedulerConfig nodeSchedulerConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXECUTION_POLICY, (String)"Policy used for scheduling query tasks", (String)queryManagerConfig.getQueryExecutionPolicy(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)OPTIMIZE_HASH_GENERATION, (String)"Compute hash codes for distribution, joins, and aggregations early in query plan", (Boolean)optimizerConfig.isOptimizeHashGeneration(), (boolean)false), (Object)PropertyMetadata.enumProperty((String)JOIN_DISTRIBUTION_TYPE, (String)"Join distribution type", OptimizerConfig.JoinDistributionType.class, (Enum)optimizerConfig.getJoinDistributionType(), (boolean)false), (Object)PropertyMetadataUtil.dataSizeProperty((String)JOIN_MAX_BROADCAST_TABLE_SIZE, (String)"Maximum estimated size of a table that can be broadcast when using automatic join type selection", (DataSize)optimizerConfig.getJoinMaxBroadcastTableSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)DISTRIBUTED_INDEX_JOIN, (String)"Distribute index joins on join keys instead of executing inline", (Boolean)optimizerConfig.isDistributedIndexJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)HASH_PARTITION_COUNT, (String)"Number of partitions for distributed joins and aggregations", (Integer)queryManagerConfig.getHashPartitionCount(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)GROUPED_EXECUTION, (String)"Use grouped execution when possible", (Boolean)featuresConfig.isGroupedExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)DYNAMIC_SCHEDULE_FOR_GROUPED_EXECUTION, (String)"Experimental: Use dynamic schedule for grouped execution when possible", (Boolean)featuresConfig.isDynamicScheduleForGroupedExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PREFER_STREAMING_OPERATORS, (String)"Prefer source table layouts that produce streaming operators", (Boolean)false, (boolean)false), (Object)PropertyMetadata.integerProperty((String)TASK_WRITER_COUNT, (String)"Default number of local parallel table writer jobs per worker", (Integer)taskManagerConfig.getWriterCount(), value -> SystemSessionProperties.validateValueIsPowerOfTwo(value, TASK_WRITER_COUNT), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)REDISTRIBUTE_WRITES, (String)"Force parallel distributed writes", (Boolean)featuresConfig.isRedistributeWrites(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)USE_PREFERRED_WRITE_PARTITIONING, (String)"Use preferred write partitioning", (Boolean)optimizerConfig.isUsePreferredWritePartitioning(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.integerProperty((String)PREFERRED_WRITE_PARTITIONING_MIN_NUMBER_OF_PARTITIONS, (String)"Use preferred write partitioning when the number of written partitions exceeds the configured threshold", (Integer)optimizerConfig.getPreferredWritePartitioningMinNumberOfPartitions(), value -> {
            if (value < 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than or equal to 1: %s", PREFERRED_WRITE_PARTITIONING_MIN_NUMBER_OF_PARTITIONS, value));
            }
        }, (boolean)false), PropertyMetadata.booleanProperty((String)SCALE_WRITERS, (String)"Scale out writers based on throughput (use minimum necessary)", (Boolean)featuresConfig.isScaleWriters(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)WRITER_MIN_SIZE, (String)"Target minimum size of writer output when scaling writers", (DataSize)featuresConfig.getWriterMinSize(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_TABLE_WRITE_THROUGH_UNION, (String)"Parallelize writes when using UNION ALL in queries that write data", (Boolean)optimizerConfig.isPushTableWriteThroughUnion(), (boolean)false), PropertyMetadata.integerProperty((String)TASK_CONCURRENCY, (String)"Default number of local parallel jobs per worker", (Integer)taskManagerConfig.getTaskConcurrency(), value -> SystemSessionProperties.validateValueIsPowerOfTwo(value, TASK_CONCURRENCY), (boolean)false), PropertyMetadata.booleanProperty((String)TASK_SHARE_INDEX_LOADING, (String)"Share index join lookups and caching within a task", (Boolean)taskManagerConfig.isShareIndexLoading(), (boolean)false), PropertyMetadataUtil.durationProperty((String)QUERY_MAX_RUN_TIME, (String)"Maximum run time of a query (includes the queueing time)", (Duration)queryManagerConfig.getQueryMaxRunTime(), (boolean)false), PropertyMetadataUtil.durationProperty((String)QUERY_MAX_EXECUTION_TIME, (String)"Maximum execution time of a query", (Duration)queryManagerConfig.getQueryMaxExecutionTime(), (boolean)false), PropertyMetadataUtil.durationProperty((String)QUERY_MAX_PLANNING_TIME, (String)"Maximum planning time of a query", (Duration)queryManagerConfig.getQueryMaxPlanningTime(), (boolean)false), PropertyMetadataUtil.durationProperty((String)QUERY_MAX_CPU_TIME, (String)"Maximum CPU time of a query", (Duration)queryManagerConfig.getQueryMaxCpuTime(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)QUERY_MAX_MEMORY, (String)"Maximum amount of distributed memory a query can use", (DataSize)memoryManagerConfig.getMaxQueryMemory(), (boolean)true), PropertyMetadataUtil.dataSizeProperty((String)QUERY_MAX_TOTAL_MEMORY, (String)"Maximum amount of distributed total memory a query can use", (DataSize)memoryManagerConfig.getMaxQueryTotalMemory(), (boolean)true), PropertyMetadataUtil.dataSizeProperty((String)QUERY_MAX_SCAN_PHYSICAL_BYTES, (String)"Maximum scan physical bytes of a query", (DataSize)queryManagerConfig.getQueryMaxScanPhysicalBytes().orElse(null), (boolean)false), PropertyMetadata.booleanProperty((String)RESOURCE_OVERCOMMIT, (String)"Use resources which are not guaranteed to be available to the query", (Boolean)false, (boolean)false), PropertyMetadata.integerProperty((String)QUERY_MAX_STAGE_COUNT, (String)"Temporary: Maximum number of stages a query can have", (Integer)queryManagerConfig.getMaxStageCount(), (boolean)true), PropertyMetadata.booleanProperty((String)DICTIONARY_AGGREGATION, (String)"Enable optimization for aggregations on dictionaries", (Boolean)optimizerConfig.isDictionaryAggregation(), (boolean)false), PropertyMetadata.integerProperty((String)INITIAL_SPLITS_PER_NODE, (String)"The number of splits each node will run per task, initially", (Integer)taskManagerConfig.getInitialSplitsPerNode(), (boolean)false), PropertyMetadataUtil.durationProperty((String)SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, (String)"Experimental: Interval between changes to the number of concurrent splits per node", (Duration)taskManagerConfig.getSplitConcurrencyAdjustmentInterval(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_METADATA_QUERIES, (String)"Enable optimization for metadata queries", (Boolean)optimizerConfig.isOptimizeMetadataQueries(), (boolean)false), PropertyMetadata.integerProperty((String)QUERY_PRIORITY, (String)"The priority of queries. Larger numbers are higher priority", (Integer)1, (boolean)false), PropertyMetadata.booleanProperty((String)USE_TABLE_SCAN_NODE_PARTITIONING, (String)"Adapt plan to node pre-partitioned tables", (Boolean)optimizerConfig.isUseTableScanNodePartitioning(), (boolean)false), PropertyMetadata.doubleProperty((String)TABLE_SCAN_NODE_PARTITIONING_MIN_BUCKET_TO_TASK_RATIO, (String)"Min table scan bucket to task ratio for which plan will be adopted to node pre-partitioned tables", (Double)optimizerConfig.getTableScanNodePartitioningMinBucketToTaskRatio(), (boolean)false), PropertyMetadata.enumProperty((String)JOIN_REORDERING_STRATEGY, (String)"Join reordering strategy", OptimizerConfig.JoinReorderingStrategy.class, (Enum)optimizerConfig.getJoinReorderingStrategy(), (boolean)false), new PropertyMetadata(MAX_REORDERED_JOINS, "The maximum number of joins to reorder as one group in cost-based join reordering", (Type)IntegerType.INTEGER, Integer.class, (Object)optimizerConfig.getMaxReorderedJoins(), false, value -> {
            int intValue = (Integer)value;
            if (intValue < 2) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than or equal to 2: %s", MAX_REORDERED_JOINS, intValue));
            }
            return intValue;
        }, value -> value), PropertyMetadata.booleanProperty((String)COLOCATED_JOIN, (String)"Experimental: Use a colocated join when possible", (Boolean)optimizerConfig.isColocatedJoinsEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SPATIAL_JOIN, (String)"Use spatial index for spatial join when possible", (Boolean)optimizerConfig.isSpatialJoinsEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)SPATIAL_PARTITIONING_TABLE_NAME, (String)"Name of the table containing spatial partitioning scheme", null, (boolean)false), PropertyMetadata.integerProperty((String)CONCURRENT_LIFESPANS_PER_NODE, (String)"Experimental: Run a fixed number of groups concurrently for eligible JOINs", (Integer)featuresConfig.getConcurrentLifespansPerTask(), (boolean)false), PropertyMetadata.booleanProperty((String)SPILL_ENABLED, (String)"Enable spilling", (Boolean)featuresConfig.isSpillEnabled(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, (String)"How much memory should be allocated per aggregation operator in unspilling process", (DataSize)featuresConfig.getAggregationOperatorUnspillMemoryLimit(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_DISTINCT_AGGREGATIONS, (String)"Optimize mixed non-distinct and distinct aggregations", (Boolean)optimizerConfig.isOptimizeMixedDistinctAggregations(), (boolean)false), PropertyMetadataUtil.durationProperty((String)ITERATIVE_OPTIMIZER_TIMEOUT, (String)"Timeout for plan optimization in iterative optimizer", (Duration)optimizerConfig.getIterativeOptimizerTimeout(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_FORCED_EXCHANGE_BELOW_GROUP_ID, (String)"Enable a stats-based rule adding exchanges below GroupId", (Boolean)optimizerConfig.isEnableForcedExchangeBelowGroupId(), (boolean)true), PropertyMetadata.booleanProperty((String)EXCHANGE_COMPRESSION, (String)"Enable compression in exchanges", (Boolean)featuresConfig.isExchangeCompressionEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_INTERMEDIATE_AGGREGATIONS, (String)"Enable the use of intermediate aggregations", (Boolean)optimizerConfig.isEnableIntermediateAggregations(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_AGGREGATION_THROUGH_OUTER_JOIN, (String)"Allow pushing aggregations below joins", (Boolean)optimizerConfig.isPushAggregationThroughOuterJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, (String)"Push partial aggregations below joins", (Boolean)optimizerConfig.isPushPartialAggregationThoughJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)PARSE_DECIMAL_LITERALS_AS_DOUBLE, (String)"Parse decimal literals as DOUBLE instead of DECIMAL", (Boolean)featuresConfig.isParseDecimalLiteralsAsDouble(), (boolean)false), PropertyMetadata.booleanProperty((String)FORCE_SINGLE_NODE_OUTPUT, (String)"Force single node output", (Boolean)optimizerConfig.isForceSingleNodeOutput(), (boolean)true), PropertyMetadataUtil.dataSizeProperty((String)FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, (String)"Experimental: Minimum output page size for filter and project operators", (DataSize)featuresConfig.getFilterAndProjectMinOutputPageSize(), (boolean)false), PropertyMetadata.integerProperty((String)FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, (String)"Experimental: Minimum output page row count for filter and project operators", (Integer)featuresConfig.getFilterAndProjectMinOutputPageRowCount(), (boolean)false), PropertyMetadata.booleanProperty((String)DISTRIBUTED_SORT, (String)"Parallelize sort across multiple nodes", (Boolean)optimizerConfig.isDistributedSortEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_PARTIAL_TOPN, (String)"Use partial TopN", (Boolean)true, (boolean)true), PropertyMetadata.booleanProperty((String)USE_PARTIAL_DISTINCT_LIMIT, (String)"Use partial Distinct Limit", (Boolean)true, (boolean)true), new PropertyMetadata(MAX_RECURSION_DEPTH, "Maximum recursion depth for recursive common table expression", (Type)IntegerType.INTEGER, Integer.class, (Object)featuresConfig.getMaxRecursionDepth(), false, value -> SystemSessionProperties.validateIntegerValue(value, MAX_RECURSION_DEPTH, 1, false), object -> object), PropertyMetadata.booleanProperty((String)USE_MARK_DISTINCT, (String)"Implement DISTINCT aggregations using MarkDistinct", (Boolean)optimizerConfig.isUseMarkDistinct(), (boolean)false), PropertyMetadata.booleanProperty((String)PREFER_PARTIAL_AGGREGATION, (String)"Prefer splitting aggregations into partial and final stages", (Boolean)optimizerConfig.isPreferPartialAggregation(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_TOP_N_RANKING, (String)"Use top N ranking optimization", (Boolean)optimizerConfig.isOptimizeTopNRanking(), (boolean)false), PropertyMetadata.integerProperty((String)MAX_GROUPING_SETS, (String)"Maximum number of grouping sets in a GROUP BY", (Integer)featuresConfig.getMaxGroupingSets(), (boolean)true), PropertyMetadata.booleanProperty((String)STATISTICS_CPU_TIMER_ENABLED, (String)"Experimental: Enable cpu time tracking for automatic column statistics collection on write", (Boolean)taskManagerConfig.isStatisticsCpuTimerEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_STATS_CALCULATOR, (String)"Enable statistics calculator", (Boolean)optimizerConfig.isEnableStatsCalculator(), (boolean)false), PropertyMetadata.booleanProperty((String)STATISTICS_PRECALCULATION_FOR_PUSHDOWN_ENABLED, (String)"Enable statistics precalculation for pushdown", (Boolean)optimizerConfig.isStatisticsPrecalculationForPushdownEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)COLLECT_PLAN_STATISTICS_FOR_ALL_QUERIES, (String)"Collect plan statistics for non-EXPLAIN queries", (Boolean)optimizerConfig.isCollectPlanStatisticsForAllQueries(), (boolean)false), new PropertyMetadata(MAX_DRIVERS_PER_TASK, "Maximum number of drivers per task", (Type)IntegerType.INTEGER, Integer.class, null, false, value -> Math.min(taskManagerConfig.getMaxDriversPerTask(), SystemSessionProperties.validateNullablePositiveIntegerValue(value, MAX_DRIVERS_PER_TASK)), object -> object), PropertyMetadata.booleanProperty((String)IGNORE_STATS_CALCULATOR_FAILURES, (String)"Ignore statistics calculator failures", (Boolean)optimizerConfig.isIgnoreStatsCalculatorFailures(), (boolean)false), PropertyMetadata.booleanProperty((String)DEFAULT_FILTER_FACTOR_ENABLED, (String)"use a default filter factor for unknown filters in a filter node", (Boolean)optimizerConfig.isDefaultFilterFactorEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)SKIP_REDUNDANT_SORT, (String)"Skip redundant sort operations", (Boolean)optimizerConfig.isSkipRedundantSort(), (boolean)false), PropertyMetadata.booleanProperty((String)ALLOW_PUSHDOWN_INTO_CONNECTORS, (String)"Allow pushdown into connectors", (Boolean)true, (boolean)true), PropertyMetadata.booleanProperty((String)COMPLEX_EXPRESSION_PUSHDOWN, (String)"Allow complex expression pushdown into connectors", (Boolean)optimizerConfig.isComplexExpressionPushdownEnabled(), (boolean)true), PropertyMetadata.booleanProperty((String)PREDICATE_PUSHDOWN_USE_TABLE_PROPERTIES, (String)"Use table properties in predicate pushdown", (Boolean)optimizerConfig.isPredicatePushdownUseTableProperties(), (boolean)false), PropertyMetadata.booleanProperty((String)LATE_MATERIALIZATION, (String)"Experimental: Use late materialization (including WorkProcessor pipelines)", (Boolean)featuresConfig.isLateMaterializationEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_DYNAMIC_FILTERING, (String)"Enable dynamic filtering", (Boolean)dynamicFilterConfig.isEnableDynamicFiltering(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_COORDINATOR_DYNAMIC_FILTERS_DISTRIBUTION, (String)"Enable distribution of dynamic filters from coordinator to all workers", (Boolean)dynamicFilterConfig.isEnableCoordinatorDynamicFiltersDistribution(), (boolean)false), PropertyMetadata.booleanProperty((String)ENABLE_LARGE_DYNAMIC_FILTERS, (String)"Enable collection of large dynamic filters", (Boolean)dynamicFilterConfig.isEnableLargeDynamicFilters(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)QUERY_MAX_MEMORY_PER_NODE, (String)"Maximum amount of memory a query can use per node", (DataSize)nodeMemoryConfig.getMaxQueryMemoryPerNode(), (boolean)true), PropertyMetadataUtil.dataSizeProperty((String)QUERY_MAX_MEMORY_PER_TASK, (String)"Maximum amount of memory a single task can use", (DataSize)nodeMemoryConfig.getMaxQueryMemoryPerTask().orElse(null), (boolean)true), PropertyMetadata.booleanProperty((String)IGNORE_DOWNSTREAM_PREFERENCES, (String)"Ignore Parent's PreferredProperties in AddExchange optimizer", (Boolean)optimizerConfig.isIgnoreDownstreamPreferences(), (boolean)false), PropertyMetadata.booleanProperty((String)FILTERING_SEMI_JOIN_TO_INNER, (String)"Rewrite semi join in filtering context to inner join", (Boolean)optimizerConfig.isRewriteFilteringSemiJoinToInnerJoin(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_DUPLICATE_INSENSITIVE_JOINS, (String)"Optimize duplicate insensitive joins", (Boolean)optimizerConfig.isOptimizeDuplicateInsensitiveJoins(), (boolean)false), PropertyMetadata.integerProperty((String)REQUIRED_WORKERS_COUNT, (String)"Minimum number of active workers that must be available before the query will start", (Integer)queryManagerConfig.getRequiredWorkers(), (boolean)false), PropertyMetadataUtil.durationProperty((String)REQUIRED_WORKERS_MAX_WAIT_TIME, (String)"Maximum time to wait for minimum number of workers before the query is failed", (Duration)queryManagerConfig.getRequiredWorkersMaxWait(), (boolean)false), PropertyMetadata.integerProperty((String)COST_ESTIMATION_WORKER_COUNT, (String)"Set the estimate count of workers while planning", null, (boolean)true), PropertyMetadata.booleanProperty((String)OMIT_DATETIME_TYPE_PRECISION, (String)"Omit precision when rendering datetime type names with default precision", (Boolean)featuresConfig.isOmitDateTimeTypePrecision(), (boolean)false), PropertyMetadata.booleanProperty((String)USE_LEGACY_WINDOW_FILTER_PUSHDOWN, (String)"Use legacy window filter pushdown optimizer", (Boolean)optimizerConfig.isUseLegacyWindowFilterPushdown(), (boolean)false), new PropertyMetadata(MAX_UNACKNOWLEDGED_SPLITS_PER_TASK, "Maximum number of leaf splits awaiting delivery to a given task", (Type)IntegerType.INTEGER, Integer.class, (Object)nodeSchedulerConfig.getMaxUnacknowledgedSplitsPerTask(), false, value -> SystemSessionProperties.validateIntegerValue(value, MAX_UNACKNOWLEDGED_SPLITS_PER_TASK, 1, false), object -> object), PropertyMetadata.booleanProperty((String)MERGE_PROJECT_WITH_VALUES, (String)"Inline project expressions into values", (Boolean)optimizerConfig.isMergeProjectWithValues(), (boolean)false), PropertyMetadata.stringProperty((String)TIME_ZONE_ID, (String)"Time Zone Id for the current session", null, value -> {
            if (value != null) {
                TimeZoneKey.getTimeZoneKey((String)value);
            }
        }, (boolean)true), PropertyMetadata.booleanProperty((String)LEGACY_CATALOG_ROLES, (String)"Enable legacy role management syntax that assumed all roles are catalog scoped", (Boolean)featuresConfig.isLegacyCatalogRoles(), (boolean)true), PropertyMetadata.booleanProperty((String)INCREMENTAL_HASH_ARRAY_LOAD_FACTOR_ENABLED, (String)"Use smaller load factor for small hash arrays in order to improve performance", (Boolean)featuresConfig.isIncrementalHashArrayLoadFactorEnabled(), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)MAX_PARTIAL_TOP_N_MEMORY, (String)"Max memory size for partial Top N aggregations. This can be turned off by setting it with '0'.", (DataSize)taskManagerConfig.getMaxPartialTopNMemory(), (boolean)false), PropertyMetadata.enumProperty((String)RETRY_POLICY, (String)"Retry policy", RetryPolicy.class, (Enum)queryManagerConfig.getRetryPolicy(), (boolean)false), PropertyMetadata.integerProperty((String)RETRY_ATTEMPTS, (String)"Maximum number of retry attempts", (Integer)queryManagerConfig.getRetryAttempts(), (boolean)false), PropertyMetadataUtil.durationProperty((String)RETRY_INITIAL_DELAY, (String)"Initial delay before initiating a retry attempt. Delay increases exponentially for each subsequent attempt up to 'retry_max_delay'", (Duration)queryManagerConfig.getRetryInitialDelay(), (boolean)false), PropertyMetadataUtil.durationProperty((String)RETRY_MAX_DELAY, (String)"Maximum delay before initiating a retry attempt. Delay increases exponentially for each subsequent attempt starting from 'retry_initial_delay'", (Duration)queryManagerConfig.getRetryMaxDelay(), (boolean)false), PropertyMetadata.booleanProperty((String)HIDE_INACCESSIBLE_COLUMNS, (String)"When enabled non-accessible columns are silently filtered from results from SELECT * statements", (Boolean)featuresConfig.isHideInaccessibleColumns(), value -> SystemSessionProperties.validateHideInaccessibleColumns(value, featuresConfig.isHideInaccessibleColumns()), (boolean)false), PropertyMetadataUtil.dataSizeProperty((String)FAULT_TOLERANT_EXECUTION_TARGET_TASK_INPUT_SIZE, (String)"Target size in bytes of all task inputs for a single fault tolerant task", (DataSize)queryManagerConfig.getFaultTolerantExecutionTargetTaskInputSize(), (boolean)false), PropertyMetadata.integerProperty((String)FAULT_TOLERANT_EXECUTION_MIN_TASK_SPLIT_COUNT, (String)"Minimal number of splits for a single fault tolerant task (count based)", (Integer)queryManagerConfig.getFaultTolerantExecutionMinTaskSplitCount(), (boolean)false), PropertyMetadata.integerProperty((String)FAULT_TOLERANT_EXECUTION_TARGET_TASK_SPLIT_COUNT, (String)"Target number of splits for a single fault tolerant task (split weight aware)", (Integer)queryManagerConfig.getFaultTolerantExecutionTargetTaskSplitCount(), (boolean)false), PropertyMetadata.integerProperty((String)FAULT_TOLERANT_EXECUTION_MAX_TASK_SPLIT_COUNT, (String)"Maximal number of splits for a single fault tolerant task (count based)", (Integer)queryManagerConfig.getFaultTolerantExecutionMaxTaskSplitCount(), (boolean)false)});
    }

    @Override
    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static String getExecutionPolicy(Session session) {
        return session.getSystemProperty(EXECUTION_POLICY, String.class);
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_HASH_GENERATION, Boolean.class);
    }

    public static OptimizerConfig.JoinDistributionType getJoinDistributionType(Session session) {
        return session.getSystemProperty(JOIN_DISTRIBUTION_TYPE, OptimizerConfig.JoinDistributionType.class);
    }

    public static DataSize getJoinMaxBroadcastTableSize(Session session) {
        return session.getSystemProperty(JOIN_MAX_BROADCAST_TABLE_SIZE, DataSize.class);
    }

    public static boolean isDistributedIndexJoinEnabled(Session session) {
        return session.getSystemProperty(DISTRIBUTED_INDEX_JOIN, Boolean.class);
    }

    public static int getHashPartitionCount(Session session) {
        return session.getSystemProperty(HASH_PARTITION_COUNT, Integer.class);
    }

    public static boolean isGroupedExecutionEnabled(Session session) {
        return session.getSystemProperty(GROUPED_EXECUTION, Boolean.class);
    }

    public static boolean isDynamicScheduleForGroupedExecution(Session session) {
        return session.getSystemProperty(DYNAMIC_SCHEDULE_FOR_GROUPED_EXECUTION, Boolean.class);
    }

    public static boolean preferStreamingOperators(Session session) {
        return session.getSystemProperty(PREFER_STREAMING_OPERATORS, Boolean.class);
    }

    public static int getTaskWriterCount(Session session) {
        return session.getSystemProperty(TASK_WRITER_COUNT, Integer.class);
    }

    public static boolean isRedistributeWrites(Session session) {
        return session.getSystemProperty(REDISTRIBUTE_WRITES, Boolean.class);
    }

    public static boolean isUsePreferredWritePartitioning(Session session) {
        return session.getSystemProperty(USE_PREFERRED_WRITE_PARTITIONING, Boolean.class);
    }

    public static int getPreferredWritePartitioningMinNumberOfPartitions(Session session) {
        return session.getSystemProperty(PREFERRED_WRITE_PARTITIONING_MIN_NUMBER_OF_PARTITIONS, Integer.class);
    }

    public static boolean isScaleWriters(Session session) {
        return session.getSystemProperty(SCALE_WRITERS, Boolean.class);
    }

    public static DataSize getWriterMinSize(Session session) {
        return session.getSystemProperty(WRITER_MIN_SIZE, DataSize.class);
    }

    public static boolean isPushTableWriteThroughUnion(Session session) {
        return session.getSystemProperty(PUSH_TABLE_WRITE_THROUGH_UNION, Boolean.class);
    }

    public static int getTaskConcurrency(Session session) {
        return session.getSystemProperty(TASK_CONCURRENCY, Integer.class);
    }

    public static boolean isShareIndexLoading(Session session) {
        return session.getSystemProperty(TASK_SHARE_INDEX_LOADING, Boolean.class);
    }

    public static boolean isDictionaryAggregationEnabled(Session session) {
        return session.getSystemProperty(DICTIONARY_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeMetadataQueries(Session session) {
        return session.getSystemProperty(OPTIMIZE_METADATA_QUERIES, Boolean.class);
    }

    public static DataSize getQueryMaxMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY, DataSize.class);
    }

    public static DataSize getQueryMaxTotalMemory(Session session) {
        return session.getSystemProperty(QUERY_MAX_TOTAL_MEMORY, DataSize.class);
    }

    public static Duration getQueryMaxRunTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_RUN_TIME, Duration.class);
    }

    public static Duration getQueryMaxExecutionTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_EXECUTION_TIME, Duration.class);
    }

    public static Duration getQueryMaxPlanningTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_PLANNING_TIME, Duration.class);
    }

    public static boolean resourceOvercommit(Session session) {
        return session.getSystemProperty(RESOURCE_OVERCOMMIT, Boolean.class);
    }

    public static int getQueryMaxStageCount(Session session) {
        return session.getSystemProperty(QUERY_MAX_STAGE_COUNT, Integer.class);
    }

    public static boolean isUseTableScanNodePartitioning(Session session) {
        return session.getSystemProperty(USE_TABLE_SCAN_NODE_PARTITIONING, Boolean.class);
    }

    public static double getTableScanNodePartitioningMinBucketToTaskRatio(Session session) {
        return session.getSystemProperty(TABLE_SCAN_NODE_PARTITIONING_MIN_BUCKET_TO_TASK_RATIO, Double.class);
    }

    public static OptimizerConfig.JoinReorderingStrategy getJoinReorderingStrategy(Session session) {
        return session.getSystemProperty(JOIN_REORDERING_STRATEGY, OptimizerConfig.JoinReorderingStrategy.class);
    }

    public static int getMaxReorderedJoins(Session session) {
        return session.getSystemProperty(MAX_REORDERED_JOINS, Integer.class);
    }

    public static boolean isColocatedJoinEnabled(Session session) {
        return session.getSystemProperty(COLOCATED_JOIN, Boolean.class);
    }

    public static boolean isSpatialJoinEnabled(Session session) {
        return session.getSystemProperty(SPATIAL_JOIN, Boolean.class);
    }

    public static Optional<String> getSpatialPartitioningTableName(Session session) {
        return Optional.ofNullable(session.getSystemProperty(SPATIAL_PARTITIONING_TABLE_NAME, String.class));
    }

    public static OptionalInt getConcurrentLifespansPerNode(Session session) {
        Integer result = session.getSystemProperty(CONCURRENT_LIFESPANS_PER_NODE, Integer.class);
        if (result == 0) {
            return OptionalInt.empty();
        }
        Preconditions.checkArgument((result > 0 ? 1 : 0) != 0, (String)"Concurrent lifespans per node is negative: %s", (Object)result);
        return OptionalInt.of(result);
    }

    public static int getInitialSplitsPerNode(Session session) {
        return session.getSystemProperty(INITIAL_SPLITS_PER_NODE, Integer.class);
    }

    public static int getQueryPriority(Session session) {
        Integer priority = session.getSystemProperty(QUERY_PRIORITY, Integer.class);
        Preconditions.checkArgument((priority > 0 ? 1 : 0) != 0, (Object)"Query priority must be positive");
        return priority;
    }

    public static Duration getSplitConcurrencyAdjustmentInterval(Session session) {
        return session.getSystemProperty(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, Duration.class);
    }

    public static Duration getQueryMaxCpuTime(Session session) {
        return session.getSystemProperty(QUERY_MAX_CPU_TIME, Duration.class);
    }

    public static Optional<DataSize> getQueryMaxScanPhysicalBytes(Session session) {
        return Optional.ofNullable(session.getSystemProperty(QUERY_MAX_SCAN_PHYSICAL_BYTES, DataSize.class));
    }

    public static boolean isSpillEnabled(Session session) {
        return session.getSystemProperty(SPILL_ENABLED, Boolean.class);
    }

    public static DataSize getAggregationOperatorUnspillMemoryLimit(Session session) {
        DataSize memoryLimitForMerge = session.getSystemProperty(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((memoryLimitForMerge.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return memoryLimitForMerge;
    }

    public static boolean isOptimizeDistinctAggregationEnabled(Session session) {
        return session.getSystemProperty(OPTIMIZE_DISTINCT_AGGREGATIONS, Boolean.class);
    }

    public static Duration getOptimizerTimeout(Session session) {
        return session.getSystemProperty(ITERATIVE_OPTIMIZER_TIMEOUT, Duration.class);
    }

    public static boolean isEnableForcedExchangeBelowGroupId(Session session) {
        return session.getSystemProperty(ENABLE_FORCED_EXCHANGE_BELOW_GROUP_ID, Boolean.class);
    }

    public static boolean isExchangeCompressionEnabled(Session session) {
        return session.getSystemProperty(EXCHANGE_COMPRESSION, Boolean.class);
    }

    public static boolean isEnableIntermediateAggregations(Session session) {
        return session.getSystemProperty(ENABLE_INTERMEDIATE_AGGREGATIONS, Boolean.class);
    }

    public static boolean isPushAggregationThroughOuterJoin(Session session) {
        return session.getSystemProperty(PUSH_AGGREGATION_THROUGH_OUTER_JOIN, Boolean.class);
    }

    public static boolean isPushPartialAggregationThroughJoin(Session session) {
        return session.getSystemProperty(PUSH_PARTIAL_AGGREGATION_THROUGH_JOIN, Boolean.class);
    }

    public static boolean isParseDecimalLiteralsAsDouble(Session session) {
        return session.getSystemProperty(PARSE_DECIMAL_LITERALS_AS_DOUBLE, Boolean.class);
    }

    public static boolean isForceSingleNodeOutput(Session session) {
        return session.getSystemProperty(FORCE_SINGLE_NODE_OUTPUT, Boolean.class);
    }

    public static DataSize getFilterAndProjectMinOutputPageSize(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, DataSize.class);
    }

    public static int getFilterAndProjectMinOutputPageRowCount(Session session) {
        return session.getSystemProperty(FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT, Integer.class);
    }

    public static boolean useMarkDistinct(Session session) {
        return session.getSystemProperty(USE_MARK_DISTINCT, Boolean.class);
    }

    public static boolean preferPartialAggregation(Session session) {
        return session.getSystemProperty(PREFER_PARTIAL_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeTopNRanking(Session session) {
        return session.getSystemProperty(OPTIMIZE_TOP_N_RANKING, Boolean.class);
    }

    public static boolean isDistributedSortEnabled(Session session) {
        if (SystemSessionProperties.getRetryPolicy(session) != RetryPolicy.NONE) {
            return false;
        }
        return session.getSystemProperty(DISTRIBUTED_SORT, Boolean.class);
    }

    public static boolean isUsePartialTopN(Session session) {
        return session.getSystemProperty(USE_PARTIAL_TOPN, Boolean.class);
    }

    public static boolean isUsePartialDistinctLimit(Session session) {
        return session.getSystemProperty(USE_PARTIAL_DISTINCT_LIMIT, Boolean.class);
    }

    public static int getMaxRecursionDepth(Session session) {
        return session.getSystemProperty(MAX_RECURSION_DEPTH, Integer.class);
    }

    public static int getMaxGroupingSets(Session session) {
        return session.getSystemProperty(MAX_GROUPING_SETS, Integer.class);
    }

    private static void validateHideInaccessibleColumns(boolean value, boolean defaultValue) {
        if (defaultValue && !value) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot be disabled with session property when it was enabled with configuration", HIDE_INACCESSIBLE_COLUMNS));
        }
    }

    public static OptionalInt getMaxDriversPerTask(Session session) {
        Integer value = session.getSystemProperty(MAX_DRIVERS_PER_TASK, Integer.class);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    private static void validateValueIsPowerOfTwo(Object value, String property) {
        int intValue = (Integer)value;
        if (Integer.bitCount(intValue) != 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be a power of 2: %s", property, intValue));
        }
    }

    private static Integer validateNullablePositiveIntegerValue(Object value, String property) {
        return SystemSessionProperties.validateIntegerValue(value, property, 1, true);
    }

    private static Integer validateIntegerValue(Object value, String property, int lowerBoundIncluded, boolean allowNull) {
        if (value == null && !allowNull) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be non-null", property));
        }
        if (value == null) {
            return null;
        }
        int intValue = (Integer)value;
        if (intValue < lowerBoundIncluded) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be equal or greater than %s", property, lowerBoundIncluded));
        }
        return intValue;
    }

    public static boolean isStatisticsCpuTimerEnabled(Session session) {
        return session.getSystemProperty(STATISTICS_CPU_TIMER_ENABLED, Boolean.class);
    }

    public static boolean isEnableStatsCalculator(Session session) {
        return session.getSystemProperty(ENABLE_STATS_CALCULATOR, Boolean.class);
    }

    public static boolean isStatisticsPrecalculationForPushdownEnabled(Session session) {
        return session.getSystemProperty(STATISTICS_PRECALCULATION_FOR_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isCollectPlanStatisticsForAllQueries(Session session) {
        return session.getSystemProperty(COLLECT_PLAN_STATISTICS_FOR_ALL_QUERIES, Boolean.class);
    }

    public static boolean isIgnoreStatsCalculatorFailures(Session session) {
        return session.getSystemProperty(IGNORE_STATS_CALCULATOR_FAILURES, Boolean.class);
    }

    public static boolean isDefaultFilterFactorEnabled(Session session) {
        return session.getSystemProperty(DEFAULT_FILTER_FACTOR_ENABLED, Boolean.class);
    }

    public static boolean isSkipRedundantSort(Session session) {
        return session.getSystemProperty(SKIP_REDUNDANT_SORT, Boolean.class);
    }

    public static boolean isAllowPushdownIntoConnectors(Session session) {
        return session.getSystemProperty(ALLOW_PUSHDOWN_INTO_CONNECTORS, Boolean.class);
    }

    public static boolean isComplexExpressionPushdown(Session session) {
        return session.getSystemProperty(COMPLEX_EXPRESSION_PUSHDOWN, Boolean.class);
    }

    public static boolean isPredicatePushdownUseTableProperties(Session session) {
        return session.getSystemProperty(PREDICATE_PUSHDOWN_USE_TABLE_PROPERTIES, Boolean.class);
    }

    public static boolean isLateMaterializationEnabled(Session session) {
        return session.getSystemProperty(LATE_MATERIALIZATION, Boolean.class);
    }

    public static boolean isEnableDynamicFiltering(Session session) {
        return session.getSystemProperty(ENABLE_DYNAMIC_FILTERING, Boolean.class);
    }

    public static boolean isEnableCoordinatorDynamicFiltersDistribution(Session session) {
        return session.getSystemProperty(ENABLE_COORDINATOR_DYNAMIC_FILTERS_DISTRIBUTION, Boolean.class);
    }

    public static boolean isEnableLargeDynamicFilters(Session session) {
        return session.getSystemProperty(ENABLE_LARGE_DYNAMIC_FILTERS, Boolean.class);
    }

    public static DataSize getQueryMaxMemoryPerNode(Session session) {
        return session.getSystemProperty(QUERY_MAX_MEMORY_PER_NODE, DataSize.class);
    }

    public static Optional<DataSize> getQueryMaxTotalMemoryPerTask(Session session) {
        return Optional.ofNullable(session.getSystemProperty(QUERY_MAX_MEMORY_PER_TASK, DataSize.class));
    }

    public static boolean ignoreDownStreamPreferences(Session session) {
        return session.getSystemProperty(IGNORE_DOWNSTREAM_PREFERENCES, Boolean.class);
    }

    public static boolean isRewriteFilteringSemiJoinToInnerJoin(Session session) {
        return session.getSystemProperty(FILTERING_SEMI_JOIN_TO_INNER, Boolean.class);
    }

    public static boolean isOptimizeDuplicateInsensitiveJoins(Session session) {
        return session.getSystemProperty(OPTIMIZE_DUPLICATE_INSENSITIVE_JOINS, Boolean.class);
    }

    public static int getRequiredWorkers(Session session) {
        return session.getSystemProperty(REQUIRED_WORKERS_COUNT, Integer.class);
    }

    public static Duration getRequiredWorkersMaxWait(Session session) {
        return session.getSystemProperty(REQUIRED_WORKERS_MAX_WAIT_TIME, Duration.class);
    }

    public static Integer getCostEstimationWorkerCount(Session session) {
        return session.getSystemProperty(COST_ESTIMATION_WORKER_COUNT, Integer.class);
    }

    public static boolean isOmitDateTimeTypePrecision(Session session) {
        return session.getSystemProperty(OMIT_DATETIME_TYPE_PRECISION, Boolean.class);
    }

    public static boolean useLegacyWindowFilterPushdown(Session session) {
        return session.getSystemProperty(USE_LEGACY_WINDOW_FILTER_PUSHDOWN, Boolean.class);
    }

    public static int getMaxUnacknowledgedSplitsPerTask(Session session) {
        return session.getSystemProperty(MAX_UNACKNOWLEDGED_SPLITS_PER_TASK, Integer.class);
    }

    public static boolean isMergeProjectWithValues(Session session) {
        return session.getSystemProperty(MERGE_PROJECT_WITH_VALUES, Boolean.class);
    }

    public static Optional<String> getTimeZoneId(Session session) {
        return Optional.ofNullable(session.getSystemProperty(TIME_ZONE_ID, String.class));
    }

    public static boolean isLegacyCatalogRoles(Session session) {
        return session.getSystemProperty(LEGACY_CATALOG_ROLES, Boolean.class);
    }

    public static boolean isIncrementalHashArrayLoadFactorEnabled(Session session) {
        return session.getSystemProperty(INCREMENTAL_HASH_ARRAY_LOAD_FACTOR_ENABLED, Boolean.class);
    }

    public static DataSize getMaxPartialTopNMemory(Session session) {
        return session.getSystemProperty(MAX_PARTIAL_TOP_N_MEMORY, DataSize.class);
    }

    public static RetryPolicy getRetryPolicy(Session session) {
        RetryPolicy retryPolicy = session.getSystemProperty(RETRY_POLICY, RetryPolicy.class);
        if (retryPolicy != RetryPolicy.NONE && retryPolicy != RetryPolicy.QUERY && SystemSessionProperties.isEnableDynamicFiltering(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Dynamic filtering is not supported with automatic task retries enabled");
        }
        if (retryPolicy == RetryPolicy.TASK && (SystemSessionProperties.isGroupedExecutionEnabled(session) || SystemSessionProperties.isDynamicScheduleForGroupedExecution(session))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Grouped execution is not supported with task level retries enabled");
        }
        return retryPolicy;
    }

    public static int getRetryAttempts(Session session) {
        return session.getSystemProperty(RETRY_ATTEMPTS, Integer.class);
    }

    public static Duration getRetryInitialDelay(Session session) {
        return session.getSystemProperty(RETRY_INITIAL_DELAY, Duration.class);
    }

    public static Duration getRetryMaxDelay(Session session) {
        return session.getSystemProperty(RETRY_MAX_DELAY, Duration.class);
    }

    public static boolean isHideInaccessibleColumns(Session session) {
        return session.getSystemProperty(HIDE_INACCESSIBLE_COLUMNS, Boolean.class);
    }

    public static DataSize getFaultTolerantExecutionTargetTaskInputSize(Session session) {
        return session.getSystemProperty(FAULT_TOLERANT_EXECUTION_TARGET_TASK_INPUT_SIZE, DataSize.class);
    }

    public static int getFaultTolerantExecutionMinTaskSplitCount(Session session) {
        return session.getSystemProperty(FAULT_TOLERANT_EXECUTION_MIN_TASK_SPLIT_COUNT, Integer.class);
    }

    public static int getFaultTolerantExecutionTargetTaskSplitCount(Session session) {
        return session.getSystemProperty(FAULT_TOLERANT_EXECUTION_TARGET_TASK_SPLIT_COUNT, Integer.class);
    }

    public static int getFaultTolerantExecutionMaxTaskSplitCount(Session session) {
        return session.getSystemProperty(FAULT_TOLERANT_EXECUTION_MAX_TASK_SPLIT_COUNT, Integer.class);
    }
}

