/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.cost.AggregationStatsRule;
import io.trino.cost.AssignUniqueIdStatsRule;
import io.trino.cost.ComposableStatsCalculator;
import io.trino.cost.DistinctLimitStatsRule;
import io.trino.cost.EnforceSingleRowStatsRule;
import io.trino.cost.ExchangeStatsRule;
import io.trino.cost.FilterStatsCalculator;
import io.trino.cost.FilterStatsRule;
import io.trino.cost.JoinStatsRule;
import io.trino.cost.LimitStatsRule;
import io.trino.cost.OutputStatsRule;
import io.trino.cost.ProjectStatsRule;
import io.trino.cost.RowNumberStatsRule;
import io.trino.cost.SampleStatsRule;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.SemiJoinStatsRule;
import io.trino.cost.SimpleFilterProjectSemiJoinStatsRule;
import io.trino.cost.SortStatsRule;
import io.trino.cost.SpatialJoinStatsRule;
import io.trino.cost.StatsCalculator;
import io.trino.cost.StatsNormalizer;
import io.trino.cost.TableScanStatsRule;
import io.trino.cost.TopNStatsRule;
import io.trino.cost.UnionStatsRule;
import io.trino.cost.ValuesStatsRule;
import io.trino.sql.PlannerContext;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;

public class StatsCalculatorModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(StatsNormalizer.class).in(Scopes.SINGLETON);
        binder.bind(ScalarStatsCalculator.class).in(Scopes.SINGLETON);
        binder.bind(FilterStatsCalculator.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (TypeLiteral)new TypeLiteral<List<ComposableStatsCalculator.Rule<?>>>(){}).setDefault().toProvider(StatsRulesProvider.class).in(Scopes.SINGLETON);
        binder.bind(StatsCalculator.class).to(ComposableStatsCalculator.class).in(Scopes.SINGLETON);
    }

    public static class StatsRulesProvider
    implements Provider<List<ComposableStatsCalculator.Rule<?>>> {
        private final PlannerContext plannerContext;
        private final ScalarStatsCalculator scalarStatsCalculator;
        private final FilterStatsCalculator filterStatsCalculator;
        private final StatsNormalizer normalizer;

        @Inject
        public StatsRulesProvider(PlannerContext plannerContext, ScalarStatsCalculator scalarStatsCalculator, FilterStatsCalculator filterStatsCalculator, StatsNormalizer normalizer) {
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.scalarStatsCalculator = Objects.requireNonNull(scalarStatsCalculator, "scalarStatsCalculator is null");
            this.filterStatsCalculator = Objects.requireNonNull(filterStatsCalculator, "filterStatsCalculator is null");
            this.normalizer = Objects.requireNonNull(normalizer, "normalizer is null");
        }

        public List<ComposableStatsCalculator.Rule<?>> get() {
            ImmutableList.Builder rules = ImmutableList.builder();
            rules.add((Object)new OutputStatsRule());
            rules.add((Object)new TableScanStatsRule(this.plannerContext.getMetadata(), this.normalizer));
            rules.add((Object)new SimpleFilterProjectSemiJoinStatsRule(this.plannerContext.getMetadata(), this.normalizer, this.filterStatsCalculator));
            rules.add((Object)new FilterStatsRule(this.normalizer, this.filterStatsCalculator));
            rules.add((Object)new ValuesStatsRule(this.plannerContext));
            rules.add((Object)new LimitStatsRule(this.normalizer));
            rules.add((Object)new DistinctLimitStatsRule(this.normalizer));
            rules.add((Object)new TopNStatsRule(this.normalizer));
            rules.add((Object)new EnforceSingleRowStatsRule(this.normalizer));
            rules.add((Object)new ProjectStatsRule(this.scalarStatsCalculator, this.normalizer));
            rules.add((Object)new ExchangeStatsRule(this.normalizer));
            rules.add((Object)new JoinStatsRule(this.filterStatsCalculator, this.normalizer));
            rules.add((Object)new SpatialJoinStatsRule(this.filterStatsCalculator, this.normalizer));
            rules.add((Object)new AggregationStatsRule(this.normalizer));
            rules.add((Object)new UnionStatsRule(this.normalizer));
            rules.add((Object)new AssignUniqueIdStatsRule());
            rules.add((Object)new SemiJoinStatsRule());
            rules.add((Object)new RowNumberStatsRule(this.normalizer));
            rules.add((Object)new SampleStatsRule(this.normalizer));
            rules.add((Object)new SortStatsRule());
            return rules.build();
        }
    }
}

