/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.sql.ParameterUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class AddColumnTask
implements DataDefinitionTask<AddColumn> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final ColumnPropertyManager columnPropertyManager;

    @Inject
    public AddColumnTask(PlannerContext plannerContext, AccessControl accessControl, ColumnPropertyManager columnPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
    }

    @Override
    public String getName() {
        return "ADD COLUMN";
    }

    @Override
    public ListenableFuture<Void> execute(AddColumn statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Type type;
        Session session = stateMachine.getSession();
        QualifiedObjectName originalTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        RedirectionAwareTableHandle redirectionAwareTableHandle = this.plannerContext.getMetadata().getRedirectionAwareTableHandle(session, originalTableName);
        if (redirectionAwareTableHandle.getTableHandle().isEmpty()) {
            if (!statement.isTableExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table '%s' does not exist", originalTableName);
            }
            return Futures.immediateVoidFuture();
        }
        TableHandle tableHandle = redirectionAwareTableHandle.getTableHandle().get();
        CatalogName catalogName = MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, tableHandle.getCatalogName().getCatalogName());
        this.accessControl.checkCanAddColumns(session.toSecurityContext(), redirectionAwareTableHandle.getRedirectedTableName().orElse(originalTableName));
        Map<String, ColumnHandle> columnHandles = this.plannerContext.getMetadata().getColumnHandles(session, tableHandle);
        ColumnDefinition element = statement.getColumn();
        try {
            type = this.plannerContext.getTypeManager().getType(TypeSignatureTranslator.toTypeSignature(element.getType()));
        }
        catch (TypeNotFoundException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TYPE_NOT_FOUND, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (type.equals((Object)UnknownType.UNKNOWN)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_TYPE_UNKNOWN, (Node)element, "Unknown type '%s' for column '%s'", element.getType(), element.getName());
        }
        if (columnHandles.containsKey(element.getName().getValue().toLowerCase(Locale.ENGLISH))) {
            if (!statement.isColumnNotExists()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_ALREADY_EXISTS, (Node)statement, "Column '%s' already exists", element.getName());
            }
            return Futures.immediateVoidFuture();
        }
        if (!element.isNullable() && !this.plannerContext.getMetadata().getConnectorCapabilities(session, catalogName).contains(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)element, "Catalog '%s' does not support NOT NULL for column '%s'", catalogName.getCatalogName(), element.getName());
        }
        Map columnProperties = this.columnPropertyManager.getProperties(catalogName, (Iterable)element.getProperties(), session, this.plannerContext, this.accessControl, (Map)ParameterUtils.parameterExtractor((Statement)statement, parameters), true);
        ColumnMetadata column = ColumnMetadata.builder().setName(element.getName().getValue()).setType(type).setNullable(element.isNullable()).setComment(element.getComment()).setProperties(columnProperties).build();
        this.plannerContext.getMetadata().addColumn(session, tableHandle, column);
        return Futures.immediateVoidFuture();
    }
}

