/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogName;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.ForQueryExecution;
import io.trino.execution.Input;
import io.trino.execution.MemoryTrackingRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StateMachine;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskId;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.execution.scheduler.SqlQueryScheduler;
import io.trino.execution.scheduler.TaskDescriptorStorage;
import io.trino.execution.scheduler.TaskSourceFactory;
import io.trino.execution.scheduler.policy.ExecutionPolicy;
import io.trino.execution.warnings.WarningCollector;
import io.trino.failuredetector.FailureDetector;
import io.trino.metadata.TableHandle;
import io.trino.operator.ForScheduler;
import io.trino.server.BasicQueryInfo;
import io.trino.server.DynamicFilterService;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.ParameterUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.planner.InputExtractor;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.SplitSourceFactory;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;

@ThreadSafe
public class SqlQueryExecution
implements QueryExecution {
    private final QueryStateMachine stateMachine;
    private final Slug slug;
    private final PlannerContext plannerContext;
    private final SplitSourceFactory splitSourceFactory;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeScheduler nodeScheduler;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final RemoteTaskFactory remoteTaskFactory;
    private final int scheduleSplitBatchSize;
    private final ExecutorService queryExecutor;
    private final ScheduledExecutorService schedulerExecutor;
    private final FailureDetector failureDetector;
    private final AtomicReference<SqlQueryScheduler> queryScheduler = new AtomicReference();
    private final AtomicReference<Plan> queryPlan = new AtomicReference();
    private final NodeTaskMap nodeTaskMap;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final Analysis analysis;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final DynamicFilterService dynamicFilterService;
    private final TableExecuteContextManager tableExecuteContextManager;
    private final TypeAnalyzer typeAnalyzer;
    private final SqlTaskManager coordinatorTaskManager;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final TaskSourceFactory taskSourceFactory;
    private final TaskDescriptorStorage taskDescriptorStorage;

    private SqlQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, PlannerContext plannerContext, AnalyzerFactory analyzerFactory, SplitSourceFactory splitSourceFactory, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, int scheduleSplitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, DynamicFilterService dynamicFilterService, WarningCollector warningCollector, TableExecuteContextManager tableExecuteContextManager, TypeAnalyzer typeAnalyzer, SqlTaskManager coordinatorTaskManager, ExchangeManagerRegistry exchangeManagerRegistry, TaskSourceFactory taskSourceFactory, TaskDescriptorStorage taskDescriptorStorage) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{stateMachine.getQueryId()});){
            this.slug = Objects.requireNonNull(slug, "slug is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.splitSourceFactory = Objects.requireNonNull(splitSourceFactory, "splitSourceFactory is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
            this.tableExecuteContextManager = Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
            Preconditions.checkArgument((scheduleSplitBatchSize > 0 ? 1 : 0) != 0, (Object)"scheduleSplitBatchSize must be greater than 0");
            this.scheduleSplitBatchSize = scheduleSplitBatchSize;
            this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
            this.analysis = SqlQueryExecution.analyze(preparedQuery, stateMachine, warningCollector, analyzerFactory);
            stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                this.unregisterDynamicFilteringQuery(dynamicFilterService.getDynamicFilteringStats(stateMachine.getQueryId(), stateMachine.getSession()));
                tableExecuteContextManager.unregisterTableExecuteContextForQuery(stateMachine.getQueryId());
            });
            AtomicReference<SqlQueryScheduler> queryScheduler = this.queryScheduler;
            stateMachine.addStateChangeListener(state -> {
                if (!state.isDone()) {
                    return;
                }
                SqlQueryScheduler scheduler = (SqlQueryScheduler)queryScheduler.get();
                if (scheduler != null) {
                    scheduler.abort();
                }
            });
            this.remoteTaskFactory = new MemoryTrackingRemoteTaskFactory(Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null"), stateMachine);
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.coordinatorTaskManager = Objects.requireNonNull(coordinatorTaskManager, "coordinatorTaskManager is null");
            this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
            this.taskSourceFactory = Objects.requireNonNull(taskSourceFactory, "taskSourceFactory is null");
            this.taskDescriptorStorage = Objects.requireNonNull(taskDescriptorStorage, "taskDescriptorStorage is null");
        }
    }

    private synchronized void registerDynamicFilteringQuery(PlanRoot plan) {
        if (!SystemSessionProperties.isEnableDynamicFiltering(this.stateMachine.getSession())) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        this.dynamicFilterService.registerQuery(this, plan.getRoot());
        this.stateMachine.setDynamicFiltersStatsSupplier(() -> this.dynamicFilterService.getDynamicFilteringStats(this.stateMachine.getQueryId(), this.stateMachine.getSession()));
    }

    private synchronized void unregisterDynamicFilteringQuery(DynamicFilterService.DynamicFiltersStats finalDynamicFiltersStats) {
        Preconditions.checkState((boolean)this.isDone(), (Object)"Expected query to be in done state");
        this.stateMachine.setDynamicFiltersStatsSupplier(() -> finalDynamicFiltersStats);
        this.dynamicFilterService.removeQuery(this.stateMachine.getQueryId());
    }

    private static Analysis analyze(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, WarningCollector warningCollector, AnalyzerFactory analyzerFactory) {
        Analysis analysis;
        stateMachine.beginAnalysis();
        Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        Analyzer analyzer = analyzerFactory.createAnalyzer(stateMachine.getSession(), preparedQuery.getParameters(), ParameterUtils.parameterExtractor(preparedQuery.getStatement(), preparedQuery.getParameters()), warningCollector);
        try {
            analysis = analyzer.analyze(preparedQuery.getStatement());
        }
        catch (StackOverflowError e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.STACK_OVERFLOW, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
        stateMachine.setUpdateType(analysis.getUpdateType());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        stateMachine.setRoutines(analysis.getRoutines());
        stateMachine.endAnalysis();
        return analysis;
    }

    @Override
    public Slug getSlug() {
        return this.slug;
    }

    @Override
    public DataSize getUserMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getUserMemoryReservation();
        }
        if (scheduler == null) {
            return DataSize.ofBytes((long)0L);
        }
        return DataSize.succinctBytes((long)scheduler.getUserMemoryReservation());
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalMemoryReservation();
        }
        if (scheduler == null) {
            return DataSize.ofBytes((long)0L);
        }
        return DataSize.succinctBytes((long)scheduler.getTotalMemoryReservation());
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public Optional<Duration> getPlanningTime() {
        return this.stateMachine.getPlanningTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        SqlQueryScheduler scheduler = this.queryScheduler.get();
        Optional<QueryInfo> finalQueryInfo = this.stateMachine.getFinalQueryInfo();
        if (finalQueryInfo.isPresent()) {
            return finalQueryInfo.get().getQueryStats().getTotalCpuTime();
        }
        if (scheduler == null) {
            return new Duration(0.0, TimeUnit.SECONDS);
        }
        return scheduler.getTotalCpuTime();
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.ofNullable(this.queryScheduler.get()).map(SqlQueryScheduler::getBasicStageStats)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        SetThreadName ignored;
        block21: {
            Object plan;
            block19: {
                ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});
                if (this.stateMachine.transitionToPlanning()) break block19;
                ignored.close();
                return;
            }
            AtomicReference<Thread> planningThread = new AtomicReference<Thread>(Thread.currentThread());
            this.stateMachine.getStateChange(QueryState.PLANNING).addListener(() -> {
                if (this.stateMachine.getQueryState() == QueryState.FAILED) {
                    SqlQueryExecution sqlQueryExecution = this;
                    synchronized (sqlQueryExecution) {
                        Thread thread = (Thread)planningThread.get();
                        if (thread != null) {
                            thread.interrupt();
                        }
                    }
                }
            }, MoreExecutors.directExecutor());
            try {
                plan = this.planQuery();
                this.registerDynamicFilteringQuery((PlanRoot)plan);
                this.planDistribution((PlanRoot)plan);
            }
            finally {
                plan = this;
                synchronized (plan) {
                    planningThread.set(null);
                    Thread.interrupted();
                }
            }
            this.tableExecuteContextManager.registerTableExecuteContextForQuery(this.getQueryId());
            if (this.stateMachine.transitionToStarting()) break block21;
            ignored.close();
            return;
        }
        try {
            try {
                SqlQueryScheduler scheduler = this.queryScheduler.get();
                if (!this.stateMachine.isDone()) {
                    scheduler.start();
                }
            }
            catch (Throwable e) {
                this.fail(e);
                Throwables.throwIfInstanceOf((Throwable)e, Error.class);
            }
        }
        finally {
            ignored.close();
        }
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    private PlanRoot planQuery() {
        try {
            return this.doPlanQuery();
        }
        catch (StackOverflowError e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.STACK_OVERFLOW, "statement is too large (stack overflow during analysis)", (Throwable)e);
        }
    }

    private PlanRoot doPlanQuery() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(this.stateMachine.getSession(), this.planOptimizers, idAllocator, this.plannerContext, this.typeAnalyzer, this.statsCalculator, this.costCalculator, this.stateMachine.getWarningCollector());
        Plan plan = logicalPlanner.plan(this.analysis);
        this.queryPlan.set(plan);
        SubPlan fragmentedPlan = this.planFragmenter.createSubPlans(this.stateMachine.getSession(), plan, false, this.stateMachine.getWarningCollector());
        List<Input> inputs = new InputExtractor(this.plannerContext.getMetadata(), this.stateMachine.getSession()).extractInputs(fragmentedPlan);
        this.stateMachine.setInputs(inputs);
        this.stateMachine.setOutput(this.analysis.getTarget());
        boolean explainAnalyze = this.analysis.getStatement() instanceof ExplainAnalyze;
        return new PlanRoot(fragmentedPlan, !explainAnalyze);
    }

    private void planDistribution(PlanRoot plan) {
        if (this.stateMachine.isDone()) {
            return;
        }
        PlanFragment rootFragment = plan.getRoot().getFragment();
        this.stateMachine.setColumns(((OutputNode)rootFragment.getRoot()).getColumnNames(), rootFragment.getTypes());
        SqlQueryScheduler scheduler = new SqlQueryScheduler(this.stateMachine, plan.getRoot(), this.nodePartitioningManager, this.nodeScheduler, this.remoteTaskFactory, plan.isSummarizeTaskInfos(), this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, this.nodeTaskMap, this.executionPolicy, this.schedulerStats, this.dynamicFilterService, this.tableExecuteContextManager, this.plannerContext.getMetadata(), this.splitSourceFactory, this.coordinatorTaskManager, this.exchangeManagerRegistry, this.taskSourceFactory, this.taskDescriptorStorage);
        this.queryScheduler.set(scheduler);
        if (this.stateMachine.isDone()) {
            scheduler.abort();
            this.queryScheduler.set(null);
        }
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.cancelStage(stageId);
            }
        }
    }

    @Override
    public void failTask(TaskId taskId, Exception reason) {
        Objects.requireNonNull(taskId, "stageId is null");
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            if (scheduler != null) {
                scheduler.failTask(taskId, reason);
            }
        }
    }

    @Override
    public void fail(Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.stateMachine.transitionToFailed(cause);
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.stateMachine.addOutputInfoListener(listener);
    }

    @Override
    public void outputTaskFailed(TaskId taskId, Throwable failure) {
        this.stateMachine.outputTaskFailed(taskId, failure);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
        this.stateMachine.pruneQueryInfo();
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.stateMachine.getQueryId()});){
            SqlQueryScheduler scheduler = this.queryScheduler.get();
            QueryInfo queryInfo = this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.buildQueryInfo(scheduler));
            return queryInfo;
        }
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    @Override
    public Plan getQueryPlan() {
        return this.queryPlan.get();
    }

    private QueryInfo buildQueryInfo(SqlQueryScheduler scheduler) {
        QueryInfo queryInfo;
        Optional<StageInfo> stageInfo = Optional.empty();
        if (scheduler != null) {
            stageInfo = Optional.ofNullable(scheduler.getStageInfo());
        }
        if ((queryInfo = this.stateMachine.updateQueryInfo(stageInfo)).isFinalQueryInfo()) {
            this.queryScheduler.set(null);
        }
        return queryInfo;
    }

    @Override
    public boolean shouldWaitForMinWorkers() {
        return this.shouldWaitForMinWorkers(this.analysis.getStatement());
    }

    private boolean shouldWaitForMinWorkers(Statement statement) {
        if (statement instanceof Query) {
            Collection<TableHandle> tables = this.analysis.getTables();
            return !tables.stream().map(TableHandle::getCatalogName).allMatch(CatalogName::isInternalSystemConnector);
        }
        return true;
    }

    public static class SqlQueryExecutionFactory
    implements QueryExecution.QueryExecutionFactory<QueryExecution> {
        private final SplitSchedulerStats schedulerStats;
        private final int scheduleSplitBatchSize;
        private final PlannerContext plannerContext;
        private final AnalyzerFactory analyzerFactory;
        private final SplitSourceFactory splitSourceFactory;
        private final NodePartitioningManager nodePartitioningManager;
        private final NodeScheduler nodeScheduler;
        private final List<PlanOptimizer> planOptimizers;
        private final PlanFragmenter planFragmenter;
        private final RemoteTaskFactory remoteTaskFactory;
        private final ExecutorService queryExecutor;
        private final ScheduledExecutorService schedulerExecutor;
        private final FailureDetector failureDetector;
        private final NodeTaskMap nodeTaskMap;
        private final Map<String, ExecutionPolicy> executionPolicies;
        private final StatsCalculator statsCalculator;
        private final CostCalculator costCalculator;
        private final DynamicFilterService dynamicFilterService;
        private final TableExecuteContextManager tableExecuteContextManager;
        private final TypeAnalyzer typeAnalyzer;
        private final SqlTaskManager coordinatorTaskManager;
        private final ExchangeManagerRegistry exchangeManagerRegistry;
        private final TaskSourceFactory taskSourceFactory;
        private final TaskDescriptorStorage taskDescriptorStorage;

        @Inject
        SqlQueryExecutionFactory(QueryManagerConfig config, PlannerContext plannerContext, AnalyzerFactory analyzerFactory, SplitSourceFactory splitSourceFactory, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, RemoteTaskFactory remoteTaskFactory, @ForQueryExecution ExecutorService queryExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, Map<String, ExecutionPolicy> executionPolicies, SplitSchedulerStats schedulerStats, StatsCalculator statsCalculator, CostCalculator costCalculator, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager, TypeAnalyzer typeAnalyzer, SqlTaskManager coordinatorTaskManager, ExchangeManagerRegistry exchangeManagerRegistry, TaskSourceFactory taskSourceFactory, TaskDescriptorStorage taskDescriptorStorage) {
            Objects.requireNonNull(config, "config is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.scheduleSplitBatchSize = config.getScheduleSplitBatchSize();
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
            this.splitSourceFactory = Objects.requireNonNull(splitSourceFactory, "splitSourceFactory is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
            this.remoteTaskFactory = Objects.requireNonNull(remoteTaskFactory, "remoteTaskFactory is null");
            this.queryExecutor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
            this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
            this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
            this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
            this.executionPolicies = Objects.requireNonNull(executionPolicies, "executionPolicies is null");
            this.planOptimizers = Objects.requireNonNull(planOptimizersFactory, "planOptimizersFactory is null").get();
            this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
            this.tableExecuteContextManager = Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.coordinatorTaskManager = Objects.requireNonNull(coordinatorTaskManager, "coordinatorTaskManager is null");
            this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
            this.taskSourceFactory = Objects.requireNonNull(taskSourceFactory, "taskSourceFactory is null");
            this.taskDescriptorStorage = Objects.requireNonNull(taskDescriptorStorage, "taskDescriptorStorage is null");
        }

        @Override
        public QueryExecution createQueryExecution(QueryPreparer.PreparedQuery preparedQuery, QueryStateMachine stateMachine, Slug slug, WarningCollector warningCollector) {
            String executionPolicyName = SystemSessionProperties.getExecutionPolicy(stateMachine.getSession());
            ExecutionPolicy executionPolicy = this.executionPolicies.get(executionPolicyName);
            Preconditions.checkArgument((executionPolicy != null ? 1 : 0) != 0, (String)"No execution policy %s", (Object)executionPolicyName);
            return new SqlQueryExecution(preparedQuery, stateMachine, slug, this.plannerContext, this.analyzerFactory, this.splitSourceFactory, this.nodePartitioningManager, this.nodeScheduler, this.planOptimizers, this.planFragmenter, this.remoteTaskFactory, this.scheduleSplitBatchSize, this.queryExecutor, this.schedulerExecutor, this.failureDetector, this.nodeTaskMap, executionPolicy, this.schedulerStats, this.statsCalculator, this.costCalculator, this.dynamicFilterService, warningCollector, this.tableExecuteContextManager, this.typeAnalyzer, this.coordinatorTaskManager, this.exchangeManagerRegistry, this.taskSourceFactory, this.taskDescriptorStorage);
        }
    }

    private static class PlanRoot {
        private final SubPlan root;
        private final boolean summarizeTaskInfos;

        public PlanRoot(SubPlan root, boolean summarizeTaskInfos) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.summarizeTaskInfos = summarizeTaskInfos;
        }

        public SubPlan getRoot() {
            return this.root;
        }

        public boolean isSummarizeTaskInfos() {
            return this.summarizeTaskInfos;
        }
    }
}

