/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBuffers;
import java.util.List;
import java.util.Optional;

public interface OutputBuffer {
    public OutputBufferInfo getInfo();

    public BufferState getState();

    public double getUtilization();

    public boolean isOverutilized();

    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> var1);

    public void setOutputBuffers(OutputBuffers var1);

    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId var1, long var2, DataSize var4);

    public void acknowledge(OutputBuffers.OutputBufferId var1, long var2);

    public void destroy(OutputBuffers.OutputBufferId var1);

    public ListenableFuture<Void> isFull();

    public void enqueue(List<Slice> var1);

    public void enqueue(int var1, List<Slice> var2);

    public void setNoMorePages();

    public void destroy();

    public void abort();

    public long getPeakMemoryUsage();

    public Optional<Throwable> getFailureCause();
}

