/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public class FixedBucketNodeMap
extends BucketNodeMap {
    private final List<InternalNode> bucketToNode;

    public FixedBucketNodeMap(ToIntFunction<Split> splitToBucket, List<InternalNode> bucketToNode) {
        super(splitToBucket);
        this.bucketToNode = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketToNode, "bucketToNode is null"));
    }

    @Override
    public Optional<InternalNode> getAssignedNode(int bucketedId) {
        return Optional.of(this.bucketToNode.get(bucketedId));
    }

    @Override
    public int getBucketCount() {
        return this.bucketToNode.size();
    }

    @Override
    public int getNodeCount() {
        return Math.toIntExact(this.bucketToNode.stream().distinct().count());
    }

    @Override
    public void assignBucketToNode(int bucketedId, InternalNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

