/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.scheduler.NodeAllocator;
import io.trino.execution.scheduler.NodeRequirements;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.metadata.InternalNode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;

public class FixedCountNodeAllocator
implements NodeAllocator {
    private final NodeScheduler nodeScheduler;
    private final Session session;
    private final int maximumAllocationsPerNode;
    @GuardedBy(value="this")
    private final Map<Optional<CatalogName>, NodeSelector> nodeSelectorCache = new HashMap<Optional<CatalogName>, NodeSelector>();
    @GuardedBy(value="this")
    private final Map<InternalNode, Integer> allocationCountMap = new HashMap<InternalNode, Integer>();
    @GuardedBy(value="this")
    private final LinkedList<PendingAcquire> pendingAcquires = new LinkedList();

    public FixedCountNodeAllocator(NodeScheduler nodeScheduler, Session session, int maximumAllocationsPerNode) {
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.maximumAllocationsPerNode = maximumAllocationsPerNode;
    }

    @Override
    public synchronized ListenableFuture<InternalNode> acquire(NodeRequirements requirements) {
        try {
            Optional<InternalNode> node = this.tryAcquireNode(requirements);
            if (node.isPresent()) {
                return Futures.immediateFuture((Object)node.get());
            }
        }
        catch (RuntimeException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        SettableFuture future = SettableFuture.create();
        PendingAcquire pendingAcquire = new PendingAcquire(requirements, (SettableFuture<InternalNode>)future);
        this.pendingAcquires.add(pendingAcquire);
        return future;
    }

    @Override
    public void release(InternalNode node) {
        this.releaseNodeInternal(node);
        this.processPendingAcquires();
    }

    @Override
    public void updateNodes() {
        this.processPendingAcquires();
    }

    private synchronized Optional<InternalNode> tryAcquireNode(NodeRequirements requirements) {
        NodeSelector nodeSelector = this.nodeSelectorCache.computeIfAbsent(requirements.getCatalogName(), catalogName -> this.nodeScheduler.createNodeSelector(this.session, (Optional<CatalogName>)catalogName));
        List<InternalNode> nodes = nodeSelector.allNodes();
        if (nodes.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
        }
        List nodesMatchingRequirements = (List)nodes.stream().filter(node -> requirements.getAddresses().isEmpty() || requirements.getAddresses().contains(node.getHostAndPort())).collect(ImmutableList.toImmutableList());
        if (nodesMatchingRequirements.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
        }
        Optional<InternalNode> selectedNode = nodesMatchingRequirements.stream().filter(node -> this.allocationCountMap.getOrDefault(node, 0) < this.maximumAllocationsPerNode).min(Comparator.comparing(node -> this.allocationCountMap.getOrDefault(node, 0)));
        if (selectedNode.isEmpty()) {
            return Optional.empty();
        }
        this.allocationCountMap.compute(selectedNode.get(), (key, value) -> value == null ? 1 : value + 1);
        return selectedNode;
    }

    private synchronized void releaseNodeInternal(InternalNode node) {
        int allocationCount = this.allocationCountMap.compute(node, (key, value) -> value == null ? 0 : value - 1);
        Preconditions.checkState((allocationCount >= 0 ? 1 : 0) != 0, (String)"allocation count for node %s is expected to be greater than or equal to zero: %s", (Object)node, (int)allocationCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingAcquires() {
        Verify.verify((!Thread.holdsLock(this) ? 1 : 0) != 0);
        IdentityHashMap<PendingAcquire, InternalNode> assignedNodes = new IdentityHashMap<PendingAcquire, InternalNode>();
        IdentityHashMap<PendingAcquire, RuntimeException> failures = new IdentityHashMap<PendingAcquire, RuntimeException>();
        FixedCountNodeAllocator fixedCountNodeAllocator = this;
        synchronized (fixedCountNodeAllocator) {
            Iterator iterator = this.pendingAcquires.iterator();
            while (iterator.hasNext()) {
                PendingAcquire pendingAcquire2 = (PendingAcquire)iterator.next();
                if (pendingAcquire2.getFuture().isCancelled()) {
                    iterator.remove();
                    continue;
                }
                try {
                    Optional<InternalNode> node2 = this.tryAcquireNode(pendingAcquire2.getNodeRequirements());
                    if (!node2.isPresent()) continue;
                    iterator.remove();
                    assignedNodes.put(pendingAcquire2, node2.get());
                }
                catch (RuntimeException e) {
                    iterator.remove();
                    failures.put(pendingAcquire2, e);
                }
            }
        }
        assignedNodes.forEach((pendingAcquire, node) -> {
            SettableFuture<InternalNode> future = pendingAcquire.getFuture();
            future.set(node);
            if (future.isCancelled()) {
                this.releaseNodeInternal((InternalNode)node);
            }
        });
        failures.forEach((pendingAcquire, failure) -> {
            SettableFuture<InternalNode> future = pendingAcquire.getFuture();
            future.setException((Throwable)failure);
        });
    }

    @Override
    public synchronized void close() {
    }

    private static class PendingAcquire {
        private final NodeRequirements nodeRequirements;
        private final SettableFuture<InternalNode> future;

        private PendingAcquire(NodeRequirements nodeRequirements, SettableFuture<InternalNode> future) {
            this.nodeRequirements = Objects.requireNonNull(nodeRequirements, "nodeRequirements is null");
            this.future = Objects.requireNonNull(future, "future is null");
        }

        public NodeRequirements getNodeRequirements() {
            return this.nodeRequirements;
        }

        public SettableFuture<InternalNode> getFuture() {
            return this.future;
        }
    }
}

