/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.log.Logger;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogName;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.BasicStageStats;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Lifespan;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.RemoteTask;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlStage;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StateMachine;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TableInfo;
import io.trino.execution.TaskFailureListener;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStatus;
import io.trino.execution.scheduler.BroadcastOutputBufferManager;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.DynamicSplitPlacementPolicy;
import io.trino.execution.scheduler.FaultTolerantStageScheduler;
import io.trino.execution.scheduler.FixedCountNodeAllocator;
import io.trino.execution.scheduler.FixedCountScheduler;
import io.trino.execution.scheduler.FixedSourcePartitionedScheduler;
import io.trino.execution.scheduler.NodeAllocator;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.OutputBufferManager;
import io.trino.execution.scheduler.PartitionedOutputBufferManager;
import io.trino.execution.scheduler.PipelinedStageExecution;
import io.trino.execution.scheduler.ScaledOutputBufferManager;
import io.trino.execution.scheduler.ScaledWriterScheduler;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.SourcePartitionedScheduler;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.execution.scheduler.StageExecution;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.execution.scheduler.TaskDescriptorStorage;
import io.trino.execution.scheduler.TaskLifecycleListener;
import io.trino.execution.scheduler.TaskSourceFactory;
import io.trino.execution.scheduler.policy.ExecutionPolicy;
import io.trino.execution.scheduler.policy.ExecutionSchedule;
import io.trino.execution.scheduler.policy.StagesScheduleResult;
import io.trino.failuredetector.FailureDetector;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Metadata;
import io.trino.metadata.Split;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.operator.RetryPolicy;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.NotPartitionedPartitionHandle;
import io.trino.spi.exchange.Exchange;
import io.trino.spi.exchange.ExchangeContext;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spi.exchange.ExchangeManager;
import io.trino.split.SplitSource;
import io.trino.sql.planner.NodePartitionMap;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SplitSourceFactory;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.util.Failures;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;

public class SqlQueryScheduler {
    private static final Logger log = Logger.get(SqlQueryScheduler.class);
    private final QueryStateMachine queryStateMachine;
    private final NodePartitioningManager nodePartitioningManager;
    private final NodeScheduler nodeScheduler;
    private final int splitBatchSize;
    private final ExecutorService executor;
    private final ScheduledExecutorService schedulerExecutor;
    private final FailureDetector failureDetector;
    private final ExecutionPolicy executionPolicy;
    private final SplitSchedulerStats schedulerStats;
    private final DynamicFilterService dynamicFilterService;
    private final TableExecuteContextManager tableExecuteContextManager;
    private final SplitSourceFactory splitSourceFactory;
    private final ExchangeManagerRegistry exchangeManagerRegistry;
    private final TaskSourceFactory taskSourceFactory;
    private final TaskDescriptorStorage taskDescriptorStorage;
    private final StageManager stageManager;
    private final CoordinatorStagesScheduler coordinatorStagesScheduler;
    private final RetryPolicy retryPolicy;
    private final int maxRetryAttempts;
    private final AtomicInteger currentAttempt = new AtomicInteger();
    private final Duration retryInitialDelay;
    private final Duration retryMaxDelay;
    @GuardedBy(value="this")
    private boolean started;
    @GuardedBy(value="this")
    private final AtomicReference<DistributedStagesScheduler> distributedStagesScheduler = new AtomicReference();
    @GuardedBy(value="this")
    private Future<Void> distributedStagesSchedulingTask;

    public SqlQueryScheduler(QueryStateMachine queryStateMachine, SubPlan plan, NodePartitioningManager nodePartitioningManager, NodeScheduler nodeScheduler, RemoteTaskFactory remoteTaskFactory, boolean summarizeTaskInfo, int splitBatchSize, ExecutorService queryExecutor, ScheduledExecutorService schedulerExecutor, FailureDetector failureDetector, NodeTaskMap nodeTaskMap, ExecutionPolicy executionPolicy, SplitSchedulerStats schedulerStats, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager, Metadata metadata, SplitSourceFactory splitSourceFactory, SqlTaskManager coordinatorTaskManager, ExchangeManagerRegistry exchangeManagerRegistry, TaskSourceFactory taskSourceFactory, TaskDescriptorStorage taskDescriptorStorage) {
        this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
        this.splitBatchSize = splitBatchSize;
        this.executor = Objects.requireNonNull(queryExecutor, "queryExecutor is null");
        this.schedulerExecutor = Objects.requireNonNull(schedulerExecutor, "schedulerExecutor is null");
        this.failureDetector = Objects.requireNonNull(failureDetector, "failureDetector is null");
        this.executionPolicy = Objects.requireNonNull(executionPolicy, "executionPolicy is null");
        this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
        this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
        this.tableExecuteContextManager = Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
        this.splitSourceFactory = Objects.requireNonNull(splitSourceFactory, "splitSourceFactory is null");
        this.exchangeManagerRegistry = Objects.requireNonNull(exchangeManagerRegistry, "exchangeManagerRegistry is null");
        this.taskSourceFactory = Objects.requireNonNull(taskSourceFactory, "taskSourceFactory is null");
        this.taskDescriptorStorage = Objects.requireNonNull(taskDescriptorStorage, "taskDescriptorStorage is null");
        this.stageManager = StageManager.create(queryStateMachine, queryStateMachine.getSession(), metadata, remoteTaskFactory, nodeTaskMap, queryExecutor, schedulerStats, plan, summarizeTaskInfo);
        this.coordinatorStagesScheduler = CoordinatorStagesScheduler.create(queryStateMachine, nodeScheduler, this.stageManager, failureDetector, schedulerExecutor, this.distributedStagesScheduler, coordinatorTaskManager);
        this.retryPolicy = SystemSessionProperties.getRetryPolicy(queryStateMachine.getSession());
        this.maxRetryAttempts = SystemSessionProperties.getRetryAttempts(queryStateMachine.getSession());
        this.retryInitialDelay = SystemSessionProperties.getRetryInitialDelay(queryStateMachine.getSession());
        this.retryMaxDelay = SystemSessionProperties.getRetryMaxDelay(queryStateMachine.getSession());
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.queryStateMachine.isDone()) {
            return;
        }
        this.queryStateMachine.addStateChangeListener(state -> {
            DistributedStagesScheduler distributedStagesScheduler;
            if (!state.isDone()) {
                return;
            }
            SqlQueryScheduler sqlQueryScheduler = this;
            synchronized (sqlQueryScheduler) {
                distributedStagesScheduler = this.distributedStagesScheduler.get();
            }
            if (state == QueryState.FINISHED) {
                this.coordinatorStagesScheduler.cancel();
                if (distributedStagesScheduler != null) {
                    distributedStagesScheduler.cancel();
                }
                this.stageManager.finish();
            } else if (state == QueryState.FAILED) {
                this.coordinatorStagesScheduler.abort();
                if (distributedStagesScheduler != null) {
                    distributedStagesScheduler.abort();
                }
                this.stageManager.abort();
            }
            this.queryStateMachine.updateQueryInfo(Optional.ofNullable(this.getStageInfo()));
        });
        Optional<DistributedStagesScheduler> distributedStagesScheduler = this.createDistributedStagesScheduler(this.currentAttempt.get());
        this.coordinatorStagesScheduler.schedule();
        distributedStagesScheduler.ifPresent(scheduler -> {
            this.distributedStagesSchedulingTask = this.executor.submit(scheduler::schedule, null);
        });
    }

    private synchronized Optional<DistributedStagesScheduler> createDistributedStagesScheduler(int attempt) {
        DistributedStagesScheduler distributedStagesScheduler;
        Verify.verify((attempt == 0 || this.retryPolicy == RetryPolicy.QUERY ? 1 : 0) != 0, (String)"unexpected attempt %s for retry policy %s", (int)attempt, (Object)((Object)this.retryPolicy));
        if (this.queryStateMachine.isDone()) {
            return Optional.empty();
        }
        if (attempt > 0 && this.retryPolicy == RetryPolicy.QUERY) {
            this.dynamicFilterService.registerQueryRetry(this.queryStateMachine.getQueryId(), attempt);
        }
        switch (this.retryPolicy) {
            case TASK: {
                ExchangeManager exchangeManager = this.exchangeManagerRegistry.getExchangeManager();
                distributedStagesScheduler = FaultTolerantDistributedStagesScheduler.create(this.queryStateMachine, this.stageManager, this.failureDetector, this.taskSourceFactory, this.taskDescriptorStorage, exchangeManager, this.nodePartitioningManager, this.coordinatorStagesScheduler.getTaskLifecycleListener(), this.maxRetryAttempts, this.schedulerExecutor, this.schedulerStats, this.nodeScheduler);
                break;
            }
            case QUERY: 
            case NONE: {
                distributedStagesScheduler = PipelinedDistributedStagesScheduler.create(this.queryStateMachine, this.schedulerStats, this.nodeScheduler, this.nodePartitioningManager, this.stageManager, this.coordinatorStagesScheduler, this.executionPolicy, this.failureDetector, this.schedulerExecutor, this.splitSourceFactory, this.splitBatchSize, this.dynamicFilterService, this.tableExecuteContextManager, this.retryPolicy, attempt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected retry policy: " + this.retryPolicy);
            }
        }
        this.distributedStagesScheduler.set(distributedStagesScheduler);
        distributedStagesScheduler.addStateChangeListener(state -> {
            if (this.queryStateMachine.getQueryState() == QueryState.STARTING && (state == DistributedStagesSchedulerState.RUNNING || state.isDone())) {
                this.queryStateMachine.transitionToRunning();
            }
            if (state.isDone() && !state.isFailure()) {
                this.stageManager.getDistributedStagesInTopologicalOrder().forEach(stage -> this.stageManager.get(stage.getStageId()).finish());
            }
            if (this.stageManager.getCoordinatorStagesInTopologicalOrder().isEmpty()) {
                if (state == DistributedStagesSchedulerState.FINISHED) {
                    this.queryStateMachine.transitionToFinishing();
                } else if (state == DistributedStagesSchedulerState.CANCELED) {
                    this.queryStateMachine.transitionToCanceled();
                }
            }
            if (state == DistributedStagesSchedulerState.FAILED) {
                StageFailureInfo stageFailureInfo = distributedStagesScheduler.getFailureCause().orElseGet(() -> new StageFailureInfo(Failures.toFailure((Throwable)new VerifyException("distributedStagesScheduler failed but failure cause is not present")), Optional.empty()));
                ErrorCode errorCode = stageFailureInfo.getFailureInfo().getErrorCode();
                if (this.shouldRetry(errorCode)) {
                    long delayInMillis = Math.min(this.retryInitialDelay.toMillis() * (long)Math.pow(2.0, this.currentAttempt.get()), this.retryMaxDelay.toMillis());
                    this.currentAttempt.incrementAndGet();
                    this.scheduleRetryWithDelay(delayInMillis);
                } else {
                    this.stageManager.getDistributedStagesInTopologicalOrder().forEach(stage -> {
                        if (stageFailureInfo.getFailedStageId().isPresent() && stageFailureInfo.getFailedStageId().get().equals(stage.getStageId())) {
                            stage.fail(stageFailureInfo.getFailureInfo().toException());
                        } else {
                            stage.abort();
                        }
                    });
                    this.queryStateMachine.transitionToFailed(stageFailureInfo.getFailureInfo().toException());
                }
            }
        });
        return Optional.of(distributedStagesScheduler);
    }

    private boolean shouldRetry(ErrorCode errorCode) {
        return this.retryPolicy == RetryPolicy.QUERY && this.currentAttempt.get() < this.maxRetryAttempts && SqlQueryScheduler.isRetryableErrorCode(errorCode);
    }

    private static boolean isRetryableErrorCode(ErrorCode errorCode) {
        return errorCode == null || errorCode.getType() == ErrorType.INTERNAL_ERROR || errorCode.getType() == ErrorType.EXTERNAL || errorCode.getCode() == StandardErrorCode.CLUSTER_OUT_OF_MEMORY.toErrorCode().getCode();
    }

    private void scheduleRetryWithDelay(long delayInMillis) {
        try {
            this.schedulerExecutor.schedule(this::scheduleRetry, delayInMillis, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            this.queryStateMachine.transitionToFailed(t);
        }
    }

    private synchronized void scheduleRetry() {
        try {
            Preconditions.checkState((this.distributedStagesSchedulingTask != null ? 1 : 0) != 0, (Object)"schedulingTask is expected to be set");
            this.distributedStagesSchedulingTask.get(5L, TimeUnit.MINUTES);
            Optional<DistributedStagesScheduler> distributedStagesScheduler = this.createDistributedStagesScheduler(this.currentAttempt.get());
            distributedStagesScheduler.ifPresent(scheduler -> {
                this.distributedStagesSchedulingTask = this.executor.submit(scheduler::schedule, null);
            });
        }
        catch (Throwable t) {
            this.queryStateMachine.transitionToFailed(t);
        }
    }

    public synchronized void cancelStage(StageId stageId) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            this.coordinatorStagesScheduler.cancelStage(stageId);
            DistributedStagesScheduler distributedStagesScheduler = this.distributedStagesScheduler.get();
            if (distributedStagesScheduler != null) {
                distributedStagesScheduler.cancelStage(stageId);
            }
        }
    }

    public synchronized void abort() {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            this.coordinatorStagesScheduler.abort();
            DistributedStagesScheduler distributedStagesScheduler = this.distributedStagesScheduler.get();
            if (distributedStagesScheduler != null) {
                distributedStagesScheduler.abort();
            }
        }
    }

    public void failTask(TaskId taskId, Throwable failureCause) {
        try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
            this.coordinatorStagesScheduler.failTaskRemotely(taskId, failureCause);
            DistributedStagesScheduler distributedStagesScheduler = this.distributedStagesScheduler.get();
            if (distributedStagesScheduler != null) {
                distributedStagesScheduler.failTaskRemotely(taskId, failureCause);
            }
        }
    }

    public BasicStageStats getBasicStageStats() {
        return this.stageManager.getBasicStageStats();
    }

    public StageInfo getStageInfo() {
        return this.stageManager.getStageInfo();
    }

    public long getUserMemoryReservation() {
        return this.stageManager.getUserMemoryReservation();
    }

    public long getTotalMemoryReservation() {
        return this.stageManager.getTotalMemoryReservation();
    }

    public Duration getTotalCpuTime() {
        return this.stageManager.getTotalCpuTime();
    }

    private static class StageFailureInfo {
        private final ExecutionFailureInfo failureInfo;
        private final Optional<StageId> failedStageId;

        private StageFailureInfo(ExecutionFailureInfo failureInfo, Optional<StageId> failedStageId) {
            this.failureInfo = Objects.requireNonNull(failureInfo, "failureInfo is null");
            this.failedStageId = Objects.requireNonNull(failedStageId, "failedStageId is null");
        }

        public ExecutionFailureInfo getFailureInfo() {
            return this.failureInfo;
        }

        public Optional<StageId> getFailedStageId() {
            return this.failedStageId;
        }
    }

    private static class TaskLifecycleListenerBridge
    implements TaskLifecycleListener {
        private final TaskLifecycleListener listener;
        @GuardedBy(value="this")
        private final Set<PlanFragmentId> noMoreSourceTasks = new HashSet<PlanFragmentId>();
        @GuardedBy(value="this")
        private boolean done;

        private TaskLifecycleListenerBridge(TaskLifecycleListener listener) {
            this.listener = Objects.requireNonNull(listener, "listener is null");
        }

        @Override
        public synchronized void taskCreated(PlanFragmentId fragmentId, RemoteTask task) {
            Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"unexpected state");
            this.listener.taskCreated(fragmentId, task);
        }

        @Override
        public synchronized void noMoreTasks(PlanFragmentId fragmentId) {
            Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"unexpected state");
            this.noMoreSourceTasks.add(fragmentId);
        }

        public synchronized void notifyNoMoreSourceTasks() {
            Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"unexpected state");
            this.done = true;
            this.noMoreSourceTasks.forEach(this.listener::noMoreTasks);
        }
    }

    private static class DistributedStagesSchedulerStateMachine {
        private final QueryId queryId;
        private final StateMachine<DistributedStagesSchedulerState> state;
        private final AtomicReference<StageFailureInfo> failureCause = new AtomicReference();

        public DistributedStagesSchedulerStateMachine(QueryId queryId, Executor executor) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(executor, "executor is null");
            this.state = new StateMachine<DistributedStagesSchedulerState>("Distributed stages scheduler", executor, DistributedStagesSchedulerState.PLANNED, DistributedStagesSchedulerState.TERMINAL_STATES);
        }

        public DistributedStagesSchedulerState getState() {
            return this.state.get();
        }

        public boolean transitionToRunning() {
            return this.state.setIf(DistributedStagesSchedulerState.RUNNING, currentState -> !currentState.isDone());
        }

        public boolean transitionToFinished() {
            return this.state.setIf(DistributedStagesSchedulerState.FINISHED, currentState -> !currentState.isDone());
        }

        public boolean transitionToCanceled() {
            return this.state.setIf(DistributedStagesSchedulerState.CANCELED, currentState -> !currentState.isDone());
        }

        public boolean transitionToAborted() {
            return this.state.setIf(DistributedStagesSchedulerState.ABORTED, currentState -> !currentState.isDone());
        }

        public boolean transitionToFailed(Throwable throwable, Optional<StageId> failedStageId) {
            Objects.requireNonNull(throwable, "throwable is null");
            this.failureCause.compareAndSet(null, new StageFailureInfo(Failures.toFailure(throwable), failedStageId));
            boolean failed = this.state.setIf(DistributedStagesSchedulerState.FAILED, currentState -> !currentState.isDone());
            if (failed) {
                log.error(throwable, "Failure in distributed stage for query %s", new Object[]{this.queryId});
            } else {
                log.debug(throwable, "Failure in distributed stage for query %s after finished", new Object[]{this.queryId});
            }
            return failed;
        }

        public Optional<StageFailureInfo> getFailureCause() {
            return Optional.ofNullable(this.failureCause.get());
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<DistributedStagesSchedulerState> stateChangeListener) {
            this.state.addStateChangeListener(stateChangeListener);
        }
    }

    private static enum DistributedStagesSchedulerState {
        PLANNED(false, false),
        RUNNING(false, false),
        FINISHED(true, false),
        CANCELED(true, false),
        ABORTED(true, true),
        FAILED(true, true);

        public static final Set<DistributedStagesSchedulerState> TERMINAL_STATES;
        private final boolean doneState;
        private final boolean failureState;

        private DistributedStagesSchedulerState(boolean doneState, boolean failureState) {
            Preconditions.checkArgument((!failureState || doneState ? 1 : 0) != 0, (String)"%s is a non-done failure state", (Object)this.name());
            this.doneState = doneState;
            this.failureState = failureState;
        }

        public boolean isDone() {
            return this.doneState;
        }

        public boolean isFailure() {
            return this.failureState;
        }

        static {
            TERMINAL_STATES = (Set)Stream.of(DistributedStagesSchedulerState.values()).filter(DistributedStagesSchedulerState::isDone).collect(ImmutableSet.toImmutableSet());
        }
    }

    private static class FaultTolerantDistributedStagesScheduler
    implements DistributedStagesScheduler {
        private final DistributedStagesSchedulerStateMachine stateMachine;
        private final QueryStateMachine queryStateMachine;
        private final List<FaultTolerantStageScheduler> schedulers;
        private final SplitSchedulerStats schedulerStats;
        private final NodeAllocator nodeAllocator;
        private final ScheduledFuture<?> nodeUpdateTask;
        private final AtomicBoolean started = new AtomicBoolean();

        public static FaultTolerantDistributedStagesScheduler create(QueryStateMachine queryStateMachine, StageManager stageManager, FailureDetector failureDetector, TaskSourceFactory taskSourceFactory, TaskDescriptorStorage taskDescriptorStorage, ExchangeManager exchangeManager, NodePartitioningManager nodePartitioningManager, TaskLifecycleListener coordinatorTaskLifecycleListener, int retryAttempts, ScheduledExecutorService scheduledExecutorService, SplitSchedulerStats schedulerStats, NodeScheduler nodeScheduler) {
            taskDescriptorStorage.initialize(queryStateMachine.getQueryId());
            queryStateMachine.addStateChangeListener((QueryState state) -> {
                if (state.isDone()) {
                    taskDescriptorStorage.destroy(queryStateMachine.getQueryId());
                }
            });
            DistributedStagesSchedulerStateMachine stateMachine = new DistributedStagesSchedulerStateMachine(queryStateMachine.getQueryId(), scheduledExecutorService);
            Session session = queryStateMachine.getSession();
            int hashPartitionCount = SystemSessionProperties.getHashPartitionCount(session);
            Function<PartitioningHandle, BucketToPartition> bucketToPartitionCache = FaultTolerantDistributedStagesScheduler.createBucketToPartitionCache(nodePartitioningManager, session, hashPartitionCount);
            ImmutableList.Builder schedulers = ImmutableList.builder();
            HashMap<PlanFragmentId, Exchange> exchanges = new HashMap<PlanFragmentId, Exchange>();
            FixedCountNodeAllocator nodeAllocator = new FixedCountNodeAllocator(nodeScheduler, session, 1);
            ScheduledFuture<?> nodeUpdateTask = scheduledExecutorService.scheduleAtFixedRate(nodeAllocator::updateNodes, 5L, 5L, TimeUnit.SECONDS);
            try {
                List<SqlStage> distributedStagesInTopologicalOrder = stageManager.getDistributedStagesInTopologicalOrder();
                List distributedStagesInReverseTopologicalOrder = Lists.reverse(distributedStagesInTopologicalOrder);
                ImmutableSet.Builder coordinatorConsumedFragmentsBuilder = ImmutableSet.builder();
                for (SqlStage stage : distributedStagesInReverseTopologicalOrder) {
                    TaskLifecycleListener taskLifecycleListener;
                    Optional<Object> exchange;
                    PlanFragment fragment = stage.getFragment();
                    Optional<SqlStage> parentStage = stageManager.getParent(stage.getStageId());
                    if (parentStage.isEmpty() || parentStage.get().getFragment().getPartitioning().isCoordinatorOnly()) {
                        exchange = Optional.empty();
                        taskLifecycleListener = coordinatorTaskLifecycleListener;
                        coordinatorConsumedFragmentsBuilder.add((Object)fragment.getId());
                    } else {
                        ExchangeContext context = new ExchangeContext(session.getQueryId(), new ExchangeId("external-exchange-" + stage.getStageId().getId()));
                        exchange = Optional.of(exchangeManager.createExchange(context, hashPartitionCount));
                        exchanges.put(fragment.getId(), (Exchange)exchange.get());
                        taskLifecycleListener = TaskLifecycleListener.NO_OP;
                    }
                    ImmutableMap.Builder sourceExchanges = ImmutableMap.builder();
                    for (SqlStage childStage : stageManager.getChildren(fragment.getId())) {
                        PlanFragmentId childFragmentId = childStage.getFragment().getId();
                        Exchange sourceExchange = (Exchange)exchanges.get(childFragmentId);
                        Verify.verify((sourceExchange != null ? 1 : 0) != 0, (String)"exchange not found for fragment: %s", (Object)childFragmentId);
                        sourceExchanges.put((Object)childFragmentId, (Object)sourceExchange);
                    }
                    BucketToPartition inputBucketToPartition = bucketToPartitionCache.apply(fragment.getPartitioning());
                    FaultTolerantStageScheduler scheduler = new FaultTolerantStageScheduler(session, stage, failureDetector, taskSourceFactory, nodeAllocator, taskDescriptorStorage, taskLifecycleListener, exchange, bucketToPartitionCache.apply(fragment.getPartitioningScheme().getPartitioning().getHandle()).getBucketToPartitionMap(), (Map<PlanFragmentId, Exchange>)sourceExchanges.buildOrThrow(), inputBucketToPartition.getBucketToPartitionMap(), inputBucketToPartition.getBucketNodeMap(), retryAttempts);
                    schedulers.add((Object)scheduler);
                }
                ImmutableSet coordinatorConsumedFragments = coordinatorConsumedFragmentsBuilder.build();
                stateMachine.addStateChangeListener(arg_0 -> FaultTolerantDistributedStagesScheduler.lambda$create$1((Set)coordinatorConsumedFragments, coordinatorTaskLifecycleListener, arg_0));
                return new FaultTolerantDistributedStagesScheduler(stateMachine, queryStateMachine, (List<FaultTolerantStageScheduler>)schedulers.build(), schedulerStats, nodeAllocator, nodeUpdateTask);
            }
            catch (Throwable t) {
                block14: {
                    for (FaultTolerantStageScheduler scheduler : schedulers.build()) {
                        try {
                            scheduler.abort();
                        }
                        catch (Throwable closeFailure) {
                            if (t == closeFailure) continue;
                            t.addSuppressed(closeFailure);
                        }
                    }
                    nodeUpdateTask.cancel(true);
                    try {
                        nodeAllocator.close();
                    }
                    catch (Throwable closeFailure) {
                        if (t == closeFailure) break block14;
                        t.addSuppressed(closeFailure);
                    }
                }
                for (Exchange exchange : exchanges.values()) {
                    try {
                        exchange.close();
                    }
                    catch (Throwable closeFailure) {
                        if (t == closeFailure) continue;
                        t.addSuppressed(closeFailure);
                    }
                }
                throw t;
            }
        }

        private static Function<PartitioningHandle, BucketToPartition> createBucketToPartitionCache(NodePartitioningManager nodePartitioningManager, Session session, int hashPartitionCount) {
            HashMap cachingMap = new HashMap();
            return partitioningHandle -> cachingMap.computeIfAbsent(partitioningHandle, handle -> FaultTolerantDistributedStagesScheduler.createBucketToPartitionMap(session, hashPartitionCount, handle, nodePartitioningManager));
        }

        private static BucketToPartition createBucketToPartitionMap(Session session, int hashPartitionCount, PartitioningHandle partitioningHandle, NodePartitioningManager nodePartitioningManager) {
            if (partitioningHandle.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION)) {
                return new BucketToPartition(Optional.of(IntStream.range(0, hashPartitionCount).toArray()), Optional.empty());
            }
            if (partitioningHandle.getConnectorId().isPresent()) {
                int partitionCount = hashPartitionCount;
                BucketNodeMap bucketNodeMap = nodePartitioningManager.getBucketNodeMap(session, partitioningHandle, true);
                if (!bucketNodeMap.isDynamic()) {
                    partitionCount = bucketNodeMap.getNodeCount();
                }
                int bucketCount = bucketNodeMap.getBucketCount();
                int[] bucketToPartition = new int[bucketCount];
                int nextPartitionId = 0;
                for (int bucket = 0; bucket < bucketCount; ++bucket) {
                    bucketToPartition[bucket] = nextPartitionId++ % partitionCount;
                }
                return new BucketToPartition(Optional.of(bucketToPartition), Optional.of(bucketNodeMap));
            }
            return new BucketToPartition(Optional.empty(), Optional.empty());
        }

        private FaultTolerantDistributedStagesScheduler(DistributedStagesSchedulerStateMachine stateMachine, QueryStateMachine queryStateMachine, List<FaultTolerantStageScheduler> schedulers, SplitSchedulerStats schedulerStats, NodeAllocator nodeAllocator, ScheduledFuture<?> nodeUpdateTask) {
            this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
            this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
            this.schedulers = Objects.requireNonNull(schedulers, "schedulers is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.nodeAllocator = Objects.requireNonNull(nodeAllocator, "nodeAllocator is null");
            this.nodeUpdateTask = Objects.requireNonNull(nodeUpdateTask, "nodeUpdateTask is null");
        }

        @Override
        public void schedule() {
            Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"already started");
            if (this.schedulers.isEmpty()) {
                this.stateMachine.transitionToFinished();
                return;
            }
            this.stateMachine.transitionToRunning();
            try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
                ArrayList<ListenableFuture<Void>> blockedStages = new ArrayList<ListenableFuture<Void>>();
                while (!FaultTolerantDistributedStagesScheduler.isFinishingOrDone(this.queryStateMachine) && !this.stateMachine.getState().isDone()) {
                    blockedStages.clear();
                    boolean atLeastOneStageIsNotBlocked = false;
                    boolean allFinished = true;
                    for (FaultTolerantStageScheduler scheduler : this.schedulers) {
                        if (scheduler.isFinished()) continue;
                        allFinished = false;
                        ListenableFuture<Void> blocked = scheduler.isBlocked();
                        if (!blocked.isDone()) {
                            blockedStages.add(blocked);
                            continue;
                        }
                        try {
                            scheduler.schedule();
                        }
                        catch (Throwable t) {
                            this.fail(t, Optional.of(scheduler.getStageId()));
                            ignored.close();
                            return;
                        }
                        blocked = scheduler.isBlocked();
                        if (!blocked.isDone()) {
                            blockedStages.add(blocked);
                            continue;
                        }
                        atLeastOneStageIsNotBlocked = true;
                    }
                    if (allFinished) {
                        this.stateMachine.transitionToFinished();
                        return;
                    }
                    if (atLeastOneStageIsNotBlocked) continue;
                    Verify.verify((!blockedStages.isEmpty() ? 1 : 0) != 0, (String)"blockedStages is not expected to be empty here", (Object[])new Object[0]);
                    TimeStat.BlockTimer timer = this.schedulerStats.getSleepTime().time();
                    try {
                        try {
                            MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete(blockedStages), (int)1, (TimeUnit)TimeUnit.SECONDS);
                        }
                        catch (CancellationException e) {
                            log.debug("Scheduling has been cancelled for query %s. Query state: %s, Scheduler state: %s", new Object[]{this.queryStateMachine.getQueryId(), this.queryStateMachine.getQueryState(), this.stateMachine.getState()});
                        }
                    }
                    finally {
                        if (timer == null) continue;
                        timer.close();
                    }
                }
            }
            catch (Throwable t) {
                this.fail(t, Optional.empty());
            }
        }

        private static boolean isFinishingOrDone(QueryStateMachine queryStateMachine) {
            QueryState queryState = queryStateMachine.getQueryState();
            return queryState == QueryState.FINISHING || queryState.isDone();
        }

        private void fail(Throwable t, Optional<StageId> failedStageId) {
            this.stateMachine.transitionToFailed(t, failedStageId);
            this.schedulers.forEach(FaultTolerantStageScheduler::abort);
            this.closeNodeAllocator();
        }

        @Override
        public void cancelStage(StageId stageId) {
            throw new UnsupportedOperationException("partial cancel is not supported in fault tolerant mode");
        }

        @Override
        public void cancel() {
            this.stateMachine.transitionToCanceled();
            this.schedulers.forEach(FaultTolerantStageScheduler::cancel);
            this.closeNodeAllocator();
        }

        @Override
        public void abort() {
            this.stateMachine.transitionToAborted();
            this.schedulers.forEach(FaultTolerantStageScheduler::abort);
            this.closeNodeAllocator();
        }

        private void closeNodeAllocator() {
            this.nodeUpdateTask.cancel(true);
            try {
                this.nodeAllocator.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing node allocator for query: %s", new Object[]{this.queryStateMachine.getQueryId()});
            }
        }

        @Override
        public void reportTaskFailure(TaskId taskId, Throwable failureCause) {
            for (FaultTolerantStageScheduler scheduler : this.schedulers) {
                if (!scheduler.getStageId().equals(taskId.getStageId())) continue;
                scheduler.reportTaskFailure(taskId, failureCause);
            }
        }

        @Override
        public void failTaskRemotely(TaskId taskId, Throwable failureCause) {
            for (FaultTolerantStageScheduler scheduler : this.schedulers) {
                if (!scheduler.getStageId().equals(taskId.getStageId())) continue;
                scheduler.failTaskRemotely(taskId, failureCause);
            }
        }

        @Override
        public void addStateChangeListener(StateMachine.StateChangeListener<DistributedStagesSchedulerState> stateChangeListener) {
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }

        @Override
        public Optional<StageFailureInfo> getFailureCause() {
            return this.stateMachine.getFailureCause();
        }

        private static /* synthetic */ void lambda$create$1(Set coordinatorConsumedFragments, TaskLifecycleListener coordinatorTaskLifecycleListener, DistributedStagesSchedulerState state) {
            if (state == DistributedStagesSchedulerState.FINISHED) {
                coordinatorConsumedFragments.forEach(coordinatorTaskLifecycleListener::noMoreTasks);
            }
        }

        private static class BucketToPartition {
            private final Optional<int[]> bucketToPartitionMap;
            private final Optional<BucketNodeMap> bucketNodeMap;

            private BucketToPartition(Optional<int[]> bucketToPartitionMap, Optional<BucketNodeMap> bucketNodeMap) {
                this.bucketToPartitionMap = Objects.requireNonNull(bucketToPartitionMap, "bucketToPartitionMap is null");
                this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
            }

            public Optional<int[]> getBucketToPartitionMap() {
                return this.bucketToPartitionMap;
            }

            public Optional<BucketNodeMap> getBucketNodeMap() {
                return this.bucketNodeMap;
            }
        }
    }

    private static class PipelinedDistributedStagesScheduler
    implements DistributedStagesScheduler {
        private final DistributedStagesSchedulerStateMachine stateMachine;
        private final QueryStateMachine queryStateMachine;
        private final SplitSchedulerStats schedulerStats;
        private final StageManager stageManager;
        private final ExecutionSchedule executionSchedule;
        private final Map<StageId, StageScheduler> stageSchedulers;
        private final Map<StageId, StageExecution> stageExecutions;
        private final DynamicFilterService dynamicFilterService;
        private final AtomicBoolean started = new AtomicBoolean();

        public static PipelinedDistributedStagesScheduler create(QueryStateMachine queryStateMachine, SplitSchedulerStats schedulerStats, NodeScheduler nodeScheduler, NodePartitioningManager nodePartitioningManager, StageManager stageManager, CoordinatorStagesScheduler coordinatorStagesScheduler, ExecutionPolicy executionPolicy, FailureDetector failureDetector, ScheduledExecutorService executor, SplitSourceFactory splitSourceFactory, int splitBatchSize, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager, RetryPolicy retryPolicy, int attempt) {
            DistributedStagesSchedulerStateMachine stateMachine = new DistributedStagesSchedulerStateMachine(queryStateMachine.getQueryId(), executor);
            HashMap partitioningCacheMap = new HashMap();
            Function<PartitioningHandle, NodePartitionMap> partitioningCache = partitioningHandle -> partitioningCacheMap.computeIfAbsent(partitioningHandle, handle -> nodePartitioningManager.getNodePartitioningMap(queryStateMachine.getSession(), (PartitioningHandle)handle));
            Map<PlanFragmentId, Optional<int[]>> bucketToPartitionMap = PipelinedDistributedStagesScheduler.createBucketToPartitionMap(coordinatorStagesScheduler.getBucketToPartitionForStagesConsumedByCoordinator(), stageManager, partitioningCache);
            Map<PlanFragmentId, OutputBufferManager> outputBufferManagers = PipelinedDistributedStagesScheduler.createOutputBufferManagers(coordinatorStagesScheduler.getOutputBuffersForStagesConsumedByCoordinator(), stageManager, bucketToPartitionMap);
            TaskLifecycleListener coordinatorTaskLifecycleListener = coordinatorStagesScheduler.getTaskLifecycleListener();
            if (retryPolicy != RetryPolicy.NONE) {
                TaskLifecycleListenerBridge taskLifecycleListenerBridge = new TaskLifecycleListenerBridge(coordinatorTaskLifecycleListener);
                coordinatorTaskLifecycleListener = taskLifecycleListenerBridge;
                stateMachine.addStateChangeListener(state -> {
                    if (state == DistributedStagesSchedulerState.FINISHED) {
                        taskLifecycleListenerBridge.notifyNoMoreSourceTasks();
                    }
                });
            }
            HashMap<StageId, PipelinedStageExecution> stageExecutions = new HashMap<StageId, PipelinedStageExecution>();
            for (SqlStage sqlStage : stageManager.getDistributedStagesInTopologicalOrder()) {
                TaskLifecycleListener taskLifecycleListener;
                Optional<SqlStage> parentStage = stageManager.getParent(sqlStage.getStageId());
                if (parentStage.isEmpty() || parentStage.get().getFragment().getPartitioning().isCoordinatorOnly()) {
                    taskLifecycleListener = coordinatorTaskLifecycleListener;
                } else {
                    StageId parentStageId = parentStage.get().getStageId();
                    StageExecution parentStageExecution = Objects.requireNonNull((StageExecution)stageExecutions.get(parentStageId), () -> "execution is null for stage: " + parentStageId);
                    taskLifecycleListener = parentStageExecution.getTaskLifecycleListener();
                }
                PlanFragment fragment = sqlStage.getFragment();
                PipelinedStageExecution stageExecution = PipelinedStageExecution.createPipelinedStageExecution(stageManager.get(fragment.getId()), outputBufferManagers, taskLifecycleListener, failureDetector, executor, bucketToPartitionMap.get(fragment.getId()), attempt);
                stageExecutions.put(sqlStage.getStageId(), stageExecution);
            }
            ImmutableMap.Builder stageSchedulers = ImmutableMap.builder();
            for (StageExecution stageExecution : stageExecutions.values()) {
                List children = (List)stageManager.getChildren(stageExecution.getStageId()).stream().map(stage -> Objects.requireNonNull((StageExecution)stageExecutions.get(stage.getStageId()), () -> "stage execution not found for stage: " + stage)).collect(ImmutableList.toImmutableList());
                StageScheduler scheduler = PipelinedDistributedStagesScheduler.createStageScheduler(queryStateMachine, stageExecution, splitSourceFactory, children, partitioningCache, nodeScheduler, nodePartitioningManager, splitBatchSize, dynamicFilterService, executor, tableExecuteContextManager);
                stageSchedulers.put((Object)stageExecution.getStageId(), (Object)scheduler);
            }
            PipelinedDistributedStagesScheduler pipelinedDistributedStagesScheduler = new PipelinedDistributedStagesScheduler(stateMachine, queryStateMachine, schedulerStats, stageManager, executionPolicy.createExecutionSchedule(stageExecutions.values()), (Map<StageId, StageScheduler>)stageSchedulers.buildOrThrow(), (Map<StageId, StageExecution>)ImmutableMap.copyOf(stageExecutions), dynamicFilterService);
            pipelinedDistributedStagesScheduler.initialize();
            return pipelinedDistributedStagesScheduler;
        }

        private static Map<PlanFragmentId, Optional<int[]>> createBucketToPartitionMap(Map<PlanFragmentId, Optional<int[]>> bucketToPartitionForStagesConsumedByCoordinator, StageManager stageManager, Function<PartitioningHandle, NodePartitionMap> partitioningCache) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            result.putAll(bucketToPartitionForStagesConsumedByCoordinator);
            for (SqlStage stage : stageManager.getDistributedStagesInTopologicalOrder()) {
                PlanFragment fragment = stage.getFragment();
                Optional<int[]> bucketToPartition = PipelinedDistributedStagesScheduler.getBucketToPartition(fragment.getPartitioning(), partitioningCache, fragment.getRoot(), fragment.getRemoteSourceNodes());
                for (SqlStage childStage : stageManager.getChildren(stage.getStageId())) {
                    result.put((Object)childStage.getFragment().getId(), bucketToPartition);
                }
            }
            return result.buildOrThrow();
        }

        private static Optional<int[]> getBucketToPartition(PartitioningHandle partitioningHandle, Function<PartitioningHandle, NodePartitionMap> partitioningCache, PlanNode fragmentRoot, List<RemoteSourceNode> remoteSourceNodes) {
            if (partitioningHandle.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION) || partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
                return Optional.of(new int[1]);
            }
            if (PlanNodeSearcher.searchFrom(fragmentRoot).where(node -> node instanceof TableScanNode).findFirst().isPresent()) {
                if (remoteSourceNodes.stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE)) {
                    return Optional.empty();
                }
                NodePartitionMap nodePartitionMap = partitioningCache.apply(partitioningHandle);
                return Optional.of(nodePartitionMap.getBucketToPartition());
            }
            NodePartitionMap nodePartitionMap = partitioningCache.apply(partitioningHandle);
            List<InternalNode> partitionToNode = nodePartitionMap.getPartitionToNode();
            Failures.checkCondition(!partitionToNode.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
            return Optional.of(nodePartitionMap.getBucketToPartition());
        }

        private static Map<PlanFragmentId, OutputBufferManager> createOutputBufferManagers(Map<PlanFragmentId, OutputBufferManager> outputBuffersForStagesConsumedByCoordinator, StageManager stageManager, Map<PlanFragmentId, Optional<int[]>> bucketToPartitionMap) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            result.putAll(outputBuffersForStagesConsumedByCoordinator);
            for (SqlStage parentStage : stageManager.getDistributedStagesInTopologicalOrder()) {
                for (SqlStage childStage : stageManager.getChildren(parentStage.getStageId())) {
                    OutputBufferManager outputBufferManager;
                    PlanFragmentId fragmentId = childStage.getFragment().getId();
                    PartitioningHandle partitioningHandle = childStage.getFragment().getPartitioningScheme().getPartitioning().getHandle();
                    if (partitioningHandle.equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
                        outputBufferManager = new BroadcastOutputBufferManager();
                    } else if (partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
                        outputBufferManager = new ScaledOutputBufferManager();
                    } else {
                        Optional<int[]> bucketToPartition = bucketToPartitionMap.get(fragmentId);
                        Preconditions.checkArgument((boolean)bucketToPartition.isPresent(), (String)"bucketToPartition is expected to be present for fragment: %s", (Object)fragmentId);
                        int partitionCount = Ints.max((int[])bucketToPartition.get()) + 1;
                        outputBufferManager = new PartitionedOutputBufferManager(partitioningHandle, partitionCount);
                    }
                    result.put((Object)fragmentId, (Object)outputBufferManager);
                }
            }
            return result.buildOrThrow();
        }

        private static StageScheduler createStageScheduler(QueryStateMachine queryStateMachine, StageExecution stageExecution, SplitSourceFactory splitSourceFactory, List<StageExecution> childStageExecutions, Function<PartitioningHandle, NodePartitionMap> partitioningCache, NodeScheduler nodeScheduler, NodePartitioningManager nodePartitioningManager, int splitBatchSize, DynamicFilterService dynamicFilterService, ScheduledExecutorService executor, TableExecuteContextManager tableExecuteContextManager) {
            Session session = queryStateMachine.getSession();
            PlanFragment fragment = stageExecution.getFragment();
            PartitioningHandle partitioningHandle = fragment.getPartitioning();
            final Map<PlanNodeId, SplitSource> splitSources = splitSourceFactory.createSplitSources(session, fragment);
            if (!splitSources.isEmpty()) {
                queryStateMachine.addStateChangeListener(new StateMachine.StateChangeListener<QueryState>(){
                    private final AtomicReference<Collection<SplitSource>> splitSourcesReference;
                    {
                        this.splitSourcesReference = new AtomicReference(splitSources.values());
                    }

                    @Override
                    public void stateChanged(QueryState newState) {
                        Collection sources;
                        if (newState.isDone() && (sources = (Collection)this.splitSourcesReference.getAndSet(null)) != null) {
                            PipelinedDistributedStagesScheduler.closeSplitSources(sources);
                        }
                    }
                });
            }
            if (partitioningHandle.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(splitSources.entrySet());
                PlanNodeId planNodeId = (PlanNodeId)entry.getKey();
                SplitSource splitSource = (SplitSource)entry.getValue();
                Optional<CatalogName> catalogName = Optional.of(splitSource.getCatalogName()).filter(catalog -> !CatalogName.isInternalSystemConnector(catalog));
                NodeSelector nodeSelector = nodeScheduler.createNodeSelector(session, catalogName);
                DynamicSplitPlacementPolicy placementPolicy = new DynamicSplitPlacementPolicy(nodeSelector, stageExecution::getAllTasks);
                Preconditions.checkArgument((!fragment.getStageExecutionDescriptor().isStageGroupedExecution() ? 1 : 0) != 0);
                return SourcePartitionedScheduler.newSourcePartitionedSchedulerAsStageScheduler(stageExecution, planNodeId, splitSource, placementPolicy, splitBatchSize, dynamicFilterService, tableExecuteContextManager, () -> childStageExecutions.stream().anyMatch(StageExecution::isAnyTaskBlocked));
            }
            if (partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION)) {
                Supplier<Collection<TaskStatus>> sourceTasksProvider = () -> (Collection)childStageExecutions.stream().map(StageExecution::getTaskStatuses).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
                Supplier<Collection<TaskStatus>> writerTasksProvider = stageExecution::getTaskStatuses;
                ScaledWriterScheduler scheduler = new ScaledWriterScheduler(stageExecution, sourceTasksProvider, writerTasksProvider, nodeScheduler.createNodeSelector(session, Optional.empty()), executor, SystemSessionProperties.getWriterMinSize(session));
                PipelinedDistributedStagesScheduler.whenAllStages(childStageExecutions, StageExecution.State::isDone).addListener(scheduler::finish, MoreExecutors.directExecutor());
                return scheduler;
            }
            if (!splitSources.isEmpty()) {
                List<InternalNode> stageNodeList;
                BucketNodeMap bucketNodeMap;
                Object connectorPartitionHandles;
                List<PlanNodeId> schedulingOrder = fragment.getPartitionedSources();
                Optional<CatalogName> catalogName = partitioningHandle.getConnectorId();
                Preconditions.checkArgument((boolean)catalogName.isPresent(), (String)"No connector ID for partitioning handle: %s", (Object)partitioningHandle);
                boolean groupedExecutionForStage = fragment.getStageExecutionDescriptor().isStageGroupedExecution();
                if (groupedExecutionForStage) {
                    connectorPartitionHandles = nodePartitioningManager.listPartitionHandles(session, partitioningHandle);
                    Preconditions.checkState((!ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(connectorPartitionHandles) ? 1 : 0) != 0);
                } else {
                    connectorPartitionHandles = ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED);
                }
                if (fragment.getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE)) {
                    boolean dynamicLifespanSchedule = fragment.getStageExecutionDescriptor().isDynamicLifespanSchedule();
                    bucketNodeMap = nodePartitioningManager.getBucketNodeMap(session, partitioningHandle, dynamicLifespanSchedule);
                    Verify.verify((bucketNodeMap.isDynamic() == dynamicLifespanSchedule ? 1 : 0) != 0);
                    stageNodeList = new ArrayList<InternalNode>(nodeScheduler.createNodeSelector(session, catalogName).allNodes());
                    Collections.shuffle(stageNodeList);
                } else {
                    Verify.verify((!fragment.getStageExecutionDescriptor().isDynamicLifespanSchedule() ? 1 : 0) != 0);
                    NodePartitionMap nodePartitionMap = partitioningCache.apply(partitioningHandle);
                    if (groupedExecutionForStage) {
                        Preconditions.checkState((connectorPartitionHandles.size() == nodePartitionMap.getBucketToPartition().length ? 1 : 0) != 0);
                    }
                    stageNodeList = nodePartitionMap.getPartitionToNode();
                    bucketNodeMap = nodePartitionMap.asBucketNodeMap();
                }
                return new FixedSourcePartitionedScheduler(stageExecution, splitSources, fragment.getStageExecutionDescriptor(), schedulingOrder, stageNodeList, bucketNodeMap, splitBatchSize, SystemSessionProperties.getConcurrentLifespansPerNode(session), nodeScheduler.createNodeSelector(session, catalogName), (List<ConnectorPartitionHandle>)connectorPartitionHandles, dynamicFilterService, tableExecuteContextManager);
            }
            NodePartitionMap nodePartitionMap = partitioningCache.apply(partitioningHandle);
            List<InternalNode> partitionToNode = nodePartitionMap.getPartitionToNode();
            Failures.checkCondition(!partitionToNode.isEmpty(), (ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No worker nodes available", new Object[0]);
            return new FixedCountScheduler(stageExecution, partitionToNode);
        }

        private static void closeSplitSources(Collection<SplitSource> splitSources) {
            for (SplitSource source : splitSources) {
                try {
                    source.close();
                }
                catch (Throwable t) {
                    log.warn(t, "Error closing split source");
                }
            }
        }

        private static ListenableFuture<Void> whenAllStages(Collection<StageExecution> stages, Predicate<StageExecution.State> predicate) {
            Preconditions.checkArgument((!stages.isEmpty() ? 1 : 0) != 0, (Object)"stages is empty");
            Set stageIds = stages.stream().map(StageExecution::getStageId).collect(Collectors.toCollection(Sets::newConcurrentHashSet));
            SettableFuture future = SettableFuture.create();
            for (StageExecution stageExecution : stages) {
                stageExecution.addStateChangeListener((StageExecution.State state) -> {
                    if (predicate.test((StageExecution.State)((Object)state)) && stageIds.remove(stageExecution.getStageId()) && stageIds.isEmpty()) {
                        future.set(null);
                    }
                });
            }
            return future;
        }

        private PipelinedDistributedStagesScheduler(DistributedStagesSchedulerStateMachine stateMachine, QueryStateMachine queryStateMachine, SplitSchedulerStats schedulerStats, StageManager stageManager, ExecutionSchedule executionSchedule, Map<StageId, StageScheduler> stageSchedulers, Map<StageId, StageExecution> stageExecutions, DynamicFilterService dynamicFilterService) {
            this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
            this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
            this.schedulerStats = Objects.requireNonNull(schedulerStats, "schedulerStats is null");
            this.stageManager = Objects.requireNonNull(stageManager, "stageManager is null");
            this.executionSchedule = Objects.requireNonNull(executionSchedule, "executionSchedule is null");
            this.stageSchedulers = ImmutableMap.copyOf(Objects.requireNonNull(stageSchedulers, "stageSchedulers is null"));
            this.stageExecutions = ImmutableMap.copyOf(Objects.requireNonNull(stageExecutions, "stageExecutions is null"));
            this.dynamicFilterService = Objects.requireNonNull(dynamicFilterService, "dynamicFilterService is null");
        }

        private void initialize() {
            for (StageExecution stageExecution : this.stageExecutions.values()) {
                List childStageExecutions = (List)this.stageManager.getChildren(stageExecution.getStageId()).stream().map(stage -> Objects.requireNonNull(this.stageExecutions.get(stage.getStageId()), () -> "stage execution not found for stage: " + stage)).collect(ImmutableList.toImmutableList());
                if (childStageExecutions.isEmpty()) continue;
                stageExecution.addStateChangeListener((StageExecution.State newState) -> {
                    if (newState == StageExecution.State.FLUSHING || newState.isDone()) {
                        childStageExecutions.forEach(StageExecution::cancel);
                    }
                });
            }
            Set finishedStages = Sets.newConcurrentHashSet();
            for (StageExecution stageExecution : this.stageExecutions.values()) {
                stageExecution.addStateChangeListener((StageExecution.State state) -> {
                    if (this.stateMachine.getState().isDone()) {
                        return;
                    }
                    int numberOfTasks = stageExecution.getAllTasks().size();
                    if (!state.canScheduleMoreTasks()) {
                        this.dynamicFilterService.stageCannotScheduleMoreTasks(stageExecution.getStageId(), stageExecution.getAttemptId(), numberOfTasks);
                    }
                    if (numberOfTasks != 0) {
                        this.stateMachine.transitionToRunning();
                    }
                    if (state == StageExecution.State.FAILED) {
                        RuntimeException failureCause = stageExecution.getFailureCause().map(ExecutionFailureInfo::toException).orElseGet(() -> new VerifyException(String.format("stage execution for stage %s is failed by failure cause is not present", stageExecution.getStageId())));
                        this.fail(failureCause, Optional.of(stageExecution.getStageId()));
                    } else if (state.isDone()) {
                        finishedStages.add(stageExecution.getStageId());
                        if (finishedStages.containsAll(this.stageExecutions.keySet())) {
                            this.stateMachine.transitionToFinished();
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void schedule() {
            RuntimeException closeError;
            Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"already started");
            try {
                try (SetThreadName ignored = new SetThreadName("Query-%s", new Object[]{this.queryStateMachine.getQueryId()});){
                    this.stageSchedulers.values().forEach(StageScheduler::start);
                    while (!this.executionSchedule.isFinished()) {
                        ArrayList<ListenableFuture<Void>> blockedStages = new ArrayList<ListenableFuture<Void>>();
                        StagesScheduleResult stagesScheduleResult = this.executionSchedule.getStagesToSchedule();
                        block28: for (StageExecution stageExecution : stagesScheduleResult.getStagesToSchedule()) {
                            stageExecution.beginScheduling();
                            ScheduleResult scheduleResult = this.stageSchedulers.get(stageExecution.getStageId()).schedule();
                            if (scheduleResult.isFinished()) {
                                stageExecution.schedulingComplete();
                            } else if (!scheduleResult.getBlocked().isDone()) {
                                blockedStages.add(scheduleResult.getBlocked());
                            }
                            this.schedulerStats.getSplitsScheduledPerIteration().add((long)scheduleResult.getSplitsScheduled());
                            if (!scheduleResult.getBlockedReason().isPresent()) continue;
                            switch (scheduleResult.getBlockedReason().get()) {
                                case WRITER_SCALING: {
                                    continue block28;
                                }
                                case WAITING_FOR_SOURCE: {
                                    this.schedulerStats.getWaitingForSource().update(1L);
                                    continue block28;
                                }
                                case SPLIT_QUEUES_FULL: {
                                    this.schedulerStats.getSplitQueuesFull().update(1L);
                                    continue block28;
                                }
                                case MIXED_SPLIT_QUEUES_FULL_AND_WAITING_FOR_SOURCE: 
                                case NO_ACTIVE_DRIVER_GROUP: {
                                    continue block28;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown blocked reason: " + (Object)((Object)scheduleResult.getBlockedReason().get()));
                        }
                        if (blockedStages.isEmpty()) continue;
                        ImmutableList.Builder futures = ImmutableList.builder();
                        futures.addAll(blockedStages);
                        stagesScheduleResult.getRescheduleFuture().ifPresent(arg_0 -> ((ImmutableList.Builder)futures).add(arg_0));
                        try (TimeStat.BlockTimer timer = this.schedulerStats.getSleepTime().time();){
                            MoreFutures.tryGetFutureValue((Future)MoreFutures.whenAnyComplete((Iterable)futures.build()), (int)1, (TimeUnit)TimeUnit.SECONDS);
                        }
                        for (ListenableFuture listenableFuture : blockedStages) {
                            listenableFuture.cancel(true);
                        }
                    }
                    for (StageExecution stageExecution : this.stageExecutions.values()) {
                        StageExecution.State state = stageExecution.getState();
                        if (state == StageExecution.State.SCHEDULED || state == StageExecution.State.RUNNING || state == StageExecution.State.FLUSHING || state.isDone()) continue;
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Scheduling is complete, but stage %s is in state %s", new Object[]{stageExecution.getStageId(), state}));
                    }
                }
                closeError = new RuntimeException();
            }
            catch (Throwable t) {
                try {
                    this.fail(t, Optional.empty());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    RuntimeException closeError2 = new RuntimeException();
                    for (StageScheduler scheduler : this.stageSchedulers.values()) {
                        try {
                            scheduler.close();
                        }
                        catch (Throwable t2) {
                            this.fail(t2, Optional.empty());
                            if (closeError2 == t2) continue;
                            closeError2.addSuppressed(t2);
                        }
                    }
                }
            }
            for (StageScheduler scheduler : this.stageSchedulers.values()) {
                try {
                    scheduler.close();
                }
                catch (Throwable t) {
                    this.fail(t, Optional.empty());
                    if (closeError == t) continue;
                    closeError.addSuppressed(t);
                }
            }
        }

        @Override
        public void cancelStage(StageId stageId) {
            StageExecution stageExecution = this.stageExecutions.get(stageId);
            if (stageExecution != null) {
                stageExecution.cancel();
            }
        }

        @Override
        public void cancel() {
            this.stateMachine.transitionToCanceled();
            this.stageExecutions.values().forEach(StageExecution::cancel);
        }

        @Override
        public void abort() {
            this.stateMachine.transitionToAborted();
            this.stageExecutions.values().forEach(StageExecution::abort);
        }

        public void fail(Throwable failureCause, Optional<StageId> failedStageId) {
            this.stateMachine.transitionToFailed(failureCause, failedStageId);
            this.stageExecutions.values().forEach(StageExecution::abort);
        }

        @Override
        public void reportTaskFailure(TaskId taskId, Throwable failureCause) {
            StageExecution stageExecution = this.stageExecutions.get(taskId.getStageId());
            if (stageExecution == null) {
                return;
            }
            List<RemoteTask> tasks = stageExecution.getAllTasks();
            if (tasks.stream().noneMatch(task -> task.getTaskId().equals(taskId))) {
                return;
            }
            stageExecution.failTask(taskId, failureCause);
            this.stateMachine.transitionToFailed(failureCause, Optional.of(taskId.getStageId()));
            this.stageExecutions.values().forEach(StageExecution::abort);
        }

        @Override
        public void failTaskRemotely(TaskId taskId, Throwable failureCause) {
            this.reportTaskFailure(taskId, failureCause);
        }

        @Override
        public void addStateChangeListener(StateMachine.StateChangeListener<DistributedStagesSchedulerState> stateChangeListener) {
            this.stateMachine.addStateChangeListener(stateChangeListener);
        }

        @Override
        public Optional<StageFailureInfo> getFailureCause() {
            return this.stateMachine.getFailureCause();
        }
    }

    private static interface DistributedStagesScheduler {
        public void schedule();

        public void cancelStage(StageId var1);

        public void cancel();

        public void abort();

        public void reportTaskFailure(TaskId var1, Throwable var2);

        public void failTaskRemotely(TaskId var1, Throwable var2);

        public void addStateChangeListener(StateMachine.StateChangeListener<DistributedStagesSchedulerState> var1);

        public Optional<StageFailureInfo> getFailureCause();
    }

    private static class TaskFailureReporter
    implements TaskFailureListener {
        private final AtomicReference<DistributedStagesScheduler> distributedStagesScheduler;

        private TaskFailureReporter(AtomicReference<DistributedStagesScheduler> distributedStagesScheduler) {
            this.distributedStagesScheduler = distributedStagesScheduler;
        }

        @Override
        public void onTaskFailed(TaskId taskId, Throwable failure) {
            if (failure instanceof TrinoException && StandardErrorCode.REMOTE_TASK_FAILED.toErrorCode().equals((Object)((TrinoException)failure).getErrorCode())) {
                log.debug("Task failure discovered while fetching task results: %s", new Object[]{taskId});
                return;
            }
            log.warn(failure, "Reported task failure: %s", new Object[]{taskId});
            DistributedStagesScheduler scheduler = this.distributedStagesScheduler.get();
            if (scheduler != null) {
                scheduler.reportTaskFailure(taskId, failure);
            }
        }
    }

    private static class CoordinatorStagesScheduler {
        private static final int[] SINGLE_PARTITION = new int[]{0};
        private final QueryStateMachine queryStateMachine;
        private final NodeScheduler nodeScheduler;
        private final Map<PlanFragmentId, OutputBufferManager> outputBuffersForStagesConsumedByCoordinator;
        private final Map<PlanFragmentId, Optional<int[]>> bucketToPartitionForStagesConsumedByCoordinator;
        private final TaskLifecycleListener taskLifecycleListener;
        private final StageManager stageManager;
        private final List<StageExecution> stageExecutions;
        private final AtomicReference<DistributedStagesScheduler> distributedStagesScheduler;
        private final SqlTaskManager coordinatorTaskManager;
        private final AtomicBoolean scheduled = new AtomicBoolean();

        public static CoordinatorStagesScheduler create(QueryStateMachine queryStateMachine, NodeScheduler nodeScheduler, StageManager stageManager, FailureDetector failureDetector, Executor executor, AtomicReference<DistributedStagesScheduler> distributedStagesScheduler, SqlTaskManager coordinatorTaskManager) {
            Map<PlanFragmentId, OutputBufferManager> outputBuffersForStagesConsumedByCoordinator = CoordinatorStagesScheduler.createOutputBuffersForStagesConsumedByCoordinator(stageManager);
            Map<PlanFragmentId, Optional<int[]>> bucketToPartitionForStagesConsumedByCoordinator = CoordinatorStagesScheduler.createBucketToPartitionForStagesConsumedByCoordinator(stageManager);
            TaskLifecycleListener taskLifecycleListener = new QueryOutputTaskLifecycleListener(queryStateMachine);
            ImmutableList.Builder stageExecutions = ImmutableList.builder();
            for (SqlStage stage : stageManager.getCoordinatorStagesInTopologicalOrder()) {
                PipelinedStageExecution stageExecution = PipelinedStageExecution.createPipelinedStageExecution(stage, outputBuffersForStagesConsumedByCoordinator, taskLifecycleListener, failureDetector, executor, bucketToPartitionForStagesConsumedByCoordinator.get(stage.getFragment().getId()), 0);
                stageExecutions.add((Object)stageExecution);
                taskLifecycleListener = stageExecution.getTaskLifecycleListener();
            }
            CoordinatorStagesScheduler coordinatorStagesScheduler = new CoordinatorStagesScheduler(queryStateMachine, nodeScheduler, outputBuffersForStagesConsumedByCoordinator, bucketToPartitionForStagesConsumedByCoordinator, taskLifecycleListener, stageManager, (List<StageExecution>)stageExecutions.build(), distributedStagesScheduler, coordinatorTaskManager);
            coordinatorStagesScheduler.initialize();
            return coordinatorStagesScheduler;
        }

        private static Map<PlanFragmentId, OutputBufferManager> createOutputBuffersForStagesConsumedByCoordinator(StageManager stageManager) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            SqlStage outputStage = stageManager.getOutputStage();
            result.put((Object)outputStage.getFragment().getId(), (Object)CoordinatorStagesScheduler.createSingleStreamOutputBuffer(outputStage));
            for (SqlStage coordinatorStage : stageManager.getCoordinatorStagesInTopologicalOrder()) {
                for (SqlStage childStage : stageManager.getChildren(coordinatorStage.getStageId())) {
                    result.put((Object)childStage.getFragment().getId(), (Object)CoordinatorStagesScheduler.createSingleStreamOutputBuffer(childStage));
                }
            }
            return result.buildOrThrow();
        }

        private static OutputBufferManager createSingleStreamOutputBuffer(SqlStage stage) {
            PartitioningHandle partitioningHandle = stage.getFragment().getPartitioningScheme().getPartitioning().getHandle();
            Preconditions.checkArgument((boolean)partitioningHandle.isSingleNode(), (Object)("partitioning is expected to be single node: " + partitioningHandle));
            return new PartitionedOutputBufferManager(partitioningHandle, 1);
        }

        private static Map<PlanFragmentId, Optional<int[]>> createBucketToPartitionForStagesConsumedByCoordinator(StageManager stageManager) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            SqlStage outputStage = stageManager.getOutputStage();
            result.put((Object)outputStage.getFragment().getId(), Optional.of(SINGLE_PARTITION));
            for (SqlStage coordinatorStage : stageManager.getCoordinatorStagesInTopologicalOrder()) {
                for (SqlStage childStage : stageManager.getChildren(coordinatorStage.getStageId())) {
                    result.put((Object)childStage.getFragment().getId(), Optional.of(SINGLE_PARTITION));
                }
            }
            return result.buildOrThrow();
        }

        private CoordinatorStagesScheduler(QueryStateMachine queryStateMachine, NodeScheduler nodeScheduler, Map<PlanFragmentId, OutputBufferManager> outputBuffersForStagesConsumedByCoordinator, Map<PlanFragmentId, Optional<int[]>> bucketToPartitionForStagesConsumedByCoordinator, TaskLifecycleListener taskLifecycleListener, StageManager stageManager, List<StageExecution> stageExecutions, AtomicReference<DistributedStagesScheduler> distributedStagesScheduler, SqlTaskManager coordinatorTaskManager) {
            this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
            this.nodeScheduler = Objects.requireNonNull(nodeScheduler, "nodeScheduler is null");
            this.outputBuffersForStagesConsumedByCoordinator = ImmutableMap.copyOf(Objects.requireNonNull(outputBuffersForStagesConsumedByCoordinator, "outputBuffersForStagesConsumedByCoordinator is null"));
            this.bucketToPartitionForStagesConsumedByCoordinator = ImmutableMap.copyOf(Objects.requireNonNull(bucketToPartitionForStagesConsumedByCoordinator, "bucketToPartitionForStagesConsumedByCoordinator is null"));
            this.taskLifecycleListener = Objects.requireNonNull(taskLifecycleListener, "taskLifecycleListener is null");
            this.stageManager = Objects.requireNonNull(stageManager, "stageManager is null");
            this.stageExecutions = ImmutableList.copyOf((Collection)Objects.requireNonNull(stageExecutions, "stageExecutions is null"));
            this.distributedStagesScheduler = Objects.requireNonNull(distributedStagesScheduler, "distributedStagesScheduler is null");
            this.coordinatorTaskManager = Objects.requireNonNull(coordinatorTaskManager, "coordinatorTaskManager is null");
        }

        private void initialize() {
            for (StageExecution stageExecution2 : this.stageExecutions) {
                stageExecution2.addStateChangeListener(state -> {
                    if (this.queryStateMachine.isDone()) {
                        return;
                    }
                    if (this.queryStateMachine.getQueryState() == QueryState.STARTING && (state == StageExecution.State.RUNNING || state.isDone())) {
                        this.queryStateMachine.transitionToRunning();
                    }
                    if (state == StageExecution.State.FAILED) {
                        RuntimeException failureCause = stageExecution2.getFailureCause().map(ExecutionFailureInfo::toException).orElseGet(() -> new VerifyException(String.format("stage execution for stage %s is failed by failure cause is not present", stageExecution2.getStageId())));
                        this.stageManager.get(stageExecution2.getStageId()).fail(failureCause);
                        this.queryStateMachine.transitionToFailed(failureCause);
                    } else if (state == StageExecution.State.ABORTED) {
                        this.stageManager.get(stageExecution2.getStageId()).abort();
                        this.queryStateMachine.transitionToFailed(new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query stage was aborted"));
                    } else if (state.isDone()) {
                        this.stageManager.get(stageExecution2.getStageId()).finish();
                    }
                });
            }
            int currentIndex = 0;
            for (int nextIndex = 1; nextIndex < this.stageExecutions.size(); ++nextIndex) {
                StageExecution stageExecution3 = this.stageExecutions.get(currentIndex);
                StageExecution childStageExecution = this.stageExecutions.get(nextIndex);
                Set<SqlStage> childStages = this.stageManager.getChildren(stageExecution3.getStageId());
                Verify.verify((childStages.size() == 1 ? 1 : 0) != 0, (String)"exactly one child stage is expected", (Object[])new Object[0]);
                SqlStage childStage = (SqlStage)Iterables.getOnlyElement(childStages);
                Verify.verify((boolean)childStage.getStageId().equals(childStageExecution.getStageId()), (String)"stage execution order doesn't match the stage order", (Object[])new Object[0]);
                stageExecution3.addStateChangeListener(newState -> {
                    if (newState == StageExecution.State.FLUSHING || newState.isDone()) {
                        childStageExecution.cancel();
                    }
                });
                ++currentIndex;
            }
            Optional<StageExecution> root = Optional.ofNullable((StageExecution)Iterables.getFirst(this.stageExecutions, null));
            root.ifPresent(stageExecution -> stageExecution.addStateChangeListener(state -> {
                if (state == StageExecution.State.FINISHED) {
                    this.queryStateMachine.transitionToFinishing();
                } else if (state == StageExecution.State.CANCELED) {
                    this.queryStateMachine.transitionToCanceled();
                }
            }));
            Optional<StageExecution> last = Optional.ofNullable((StageExecution)Iterables.getLast(this.stageExecutions, null));
            last.ifPresent(stageExecution -> stageExecution.addStateChangeListener(newState -> {
                DistributedStagesScheduler distributedStagesScheduler;
                if ((newState == StageExecution.State.FLUSHING || newState.isDone()) && (distributedStagesScheduler = this.distributedStagesScheduler.get()) != null) {
                    distributedStagesScheduler.cancel();
                }
            }));
        }

        public void schedule() {
            if (!this.scheduled.compareAndSet(false, true)) {
                return;
            }
            TaskFailureReporter failureReporter = new TaskFailureReporter(this.distributedStagesScheduler);
            this.queryStateMachine.addOutputTaskFailureListener(failureReporter);
            InternalNode coordinator = this.nodeScheduler.createNodeSelector(this.queryStateMachine.getSession(), Optional.empty()).selectCurrentNode();
            for (StageExecution stageExecution : this.stageExecutions) {
                Optional<RemoteTask> remoteTask = stageExecution.scheduleTask(coordinator, 0, (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of());
                stageExecution.schedulingComplete();
                remoteTask.ifPresent(task -> this.coordinatorTaskManager.addSourceTaskFailureListener(task.getTaskId(), failureReporter));
            }
        }

        public Map<PlanFragmentId, OutputBufferManager> getOutputBuffersForStagesConsumedByCoordinator() {
            return this.outputBuffersForStagesConsumedByCoordinator;
        }

        public Map<PlanFragmentId, Optional<int[]>> getBucketToPartitionForStagesConsumedByCoordinator() {
            return this.bucketToPartitionForStagesConsumedByCoordinator;
        }

        public TaskLifecycleListener getTaskLifecycleListener() {
            return this.taskLifecycleListener;
        }

        public void cancelStage(StageId stageId) {
            for (StageExecution stageExecution : this.stageExecutions) {
                if (!stageExecution.getStageId().equals(stageId)) continue;
                stageExecution.cancel();
            }
        }

        public void failTaskRemotely(TaskId taskId, Throwable failureCause) {
            for (StageExecution stageExecution : this.stageExecutions) {
                if (!stageExecution.getStageId().equals(taskId.getStageId())) continue;
                stageExecution.failTaskRemotely(taskId, failureCause);
            }
        }

        public void cancel() {
            this.stageExecutions.forEach(StageExecution::cancel);
        }

        public void abort() {
            this.stageExecutions.forEach(StageExecution::abort);
        }
    }

    private static class QueryOutputTaskLifecycleListener
    implements TaskLifecycleListener {
        private final QueryStateMachine queryStateMachine;

        private QueryOutputTaskLifecycleListener(QueryStateMachine queryStateMachine) {
            this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
        }

        @Override
        public void taskCreated(PlanFragmentId fragmentId, RemoteTask task) {
            ImmutableMap bufferLocations = ImmutableMap.of((Object)task.getTaskId(), (Object)HttpUriBuilder.uriBuilderFrom((URI)task.getTaskStatus().getSelf()).appendPath("results").appendPath("0").build());
            this.queryStateMachine.updateOutputLocations((Map<TaskId, URI>)bufferLocations, false);
        }

        @Override
        public void noMoreTasks(PlanFragmentId fragmentId) {
            this.queryStateMachine.updateOutputLocations((Map<TaskId, URI>)ImmutableMap.of(), true);
        }
    }

    private static class StageManager {
        private final QueryStateMachine queryStateMachine;
        private final Map<StageId, SqlStage> stages;
        private final List<SqlStage> coordinatorStagesInTopologicalOrder;
        private final List<SqlStage> distributedStagesInTopologicalOrder;
        private final StageId rootStageId;
        private final Map<StageId, Set<StageId>> children;
        private final Map<StageId, StageId> parents;

        private static StageManager create(QueryStateMachine queryStateMachine, Session session, Metadata metadata, RemoteTaskFactory taskFactory, NodeTaskMap nodeTaskMap, ExecutorService executor, SplitSchedulerStats schedulerStats, SubPlan planTree, boolean summarizeTaskInfo) {
            ImmutableMap.Builder stages = ImmutableMap.builder();
            ImmutableList.Builder coordinatorStagesInTopologicalOrder = ImmutableList.builder();
            ImmutableList.Builder distributedStagesInTopologicalOrder = ImmutableList.builder();
            StageId rootStageId = null;
            ImmutableMap.Builder children = ImmutableMap.builder();
            ImmutableMap.Builder parents = ImmutableMap.builder();
            for (SubPlan planNode : Traverser.forTree(SubPlan::getChildren).breadthFirst((Object)planTree)) {
                PlanFragment fragment = planNode.getFragment();
                SqlStage stage = SqlStage.createSqlStage(StageManager.getStageId(session.getQueryId(), fragment.getId()), fragment, StageManager.extractTableInfo(session, metadata, fragment), taskFactory, session, summarizeTaskInfo, nodeTaskMap, executor, schedulerStats);
                StageId stageId = stage.getStageId();
                stages.put((Object)stageId, (Object)stage);
                if (fragment.getPartitioning().isCoordinatorOnly()) {
                    coordinatorStagesInTopologicalOrder.add((Object)stage);
                } else {
                    distributedStagesInTopologicalOrder.add((Object)stage);
                }
                if (rootStageId == null) {
                    rootStageId = stageId;
                }
                Set childStageIds = (Set)planNode.getChildren().stream().map(childStage -> StageManager.getStageId(session.getQueryId(), childStage.getFragment().getId())).collect(ImmutableSet.toImmutableSet());
                children.put((Object)stageId, (Object)childStageIds);
                childStageIds.forEach(child -> parents.put(child, (Object)stageId));
            }
            StageManager stageManager = new StageManager(queryStateMachine, (Map<StageId, SqlStage>)stages.buildOrThrow(), (List<SqlStage>)coordinatorStagesInTopologicalOrder.build(), (List<SqlStage>)distributedStagesInTopologicalOrder.build(), rootStageId, (Map<StageId, Set<StageId>>)children.buildOrThrow(), (Map<StageId, StageId>)parents.buildOrThrow());
            stageManager.initialize();
            return stageManager;
        }

        private static Map<PlanNodeId, TableInfo> extractTableInfo(Session session, Metadata metadata, PlanFragment fragment) {
            return (Map)PlanNodeSearcher.searchFrom(fragment.getRoot()).where(TableScanNode.class::isInstance).findAll().stream().map(TableScanNode.class::cast).collect(ImmutableMap.toImmutableMap(PlanNode::getId, node -> StageManager.getTableInfo(session, metadata, node)));
        }

        private static TableInfo getTableInfo(Session session, Metadata metadata, TableScanNode node) {
            TableSchema tableSchema = metadata.getTableSchema(session, node.getTable());
            TableProperties tableProperties = metadata.getTableProperties(session, node.getTable());
            return new TableInfo(tableSchema.getQualifiedName(), tableProperties.getPredicate());
        }

        private static StageId getStageId(QueryId queryId, PlanFragmentId fragmentId) {
            return new StageId(queryId, Integer.parseInt(fragmentId.toString()));
        }

        private StageManager(QueryStateMachine queryStateMachine, Map<StageId, SqlStage> stages, List<SqlStage> coordinatorStagesInTopologicalOrder, List<SqlStage> distributedStagesInTopologicalOrder, StageId rootStageId, Map<StageId, Set<StageId>> children, Map<StageId, StageId> parents) {
            this.queryStateMachine = Objects.requireNonNull(queryStateMachine, "queryStateMachine is null");
            this.stages = ImmutableMap.copyOf(Objects.requireNonNull(stages, "stages is null"));
            this.coordinatorStagesInTopologicalOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(coordinatorStagesInTopologicalOrder, "coordinatorStagesInTopologicalOrder is null"));
            this.distributedStagesInTopologicalOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(distributedStagesInTopologicalOrder, "distributedStagesInTopologicalOrder is null"));
            this.rootStageId = Objects.requireNonNull(rootStageId, "rootStageId is null");
            this.children = ImmutableMap.copyOf(Objects.requireNonNull(children, "children is null"));
            this.parents = ImmutableMap.copyOf(Objects.requireNonNull(parents, "parents is null"));
        }

        private void initialize() {
            for (SqlStage stage : this.stages.values()) {
                stage.addFinalStageInfoListener(status -> this.queryStateMachine.updateQueryInfo(Optional.ofNullable(this.getStageInfo())));
            }
        }

        public void finish() {
            this.stages.values().forEach(SqlStage::finish);
        }

        public void abort() {
            this.stages.values().forEach(SqlStage::abort);
        }

        public List<SqlStage> getCoordinatorStagesInTopologicalOrder() {
            return this.coordinatorStagesInTopologicalOrder;
        }

        public List<SqlStage> getDistributedStagesInTopologicalOrder() {
            return this.distributedStagesInTopologicalOrder;
        }

        public SqlStage getOutputStage() {
            return this.stages.get(this.rootStageId);
        }

        public SqlStage get(PlanFragmentId fragmentId) {
            return this.get(StageManager.getStageId(this.queryStateMachine.getQueryId(), fragmentId));
        }

        public SqlStage get(StageId stageId) {
            return Objects.requireNonNull(this.stages.get(stageId), () -> "stage not found: " + stageId);
        }

        public Set<SqlStage> getChildren(PlanFragmentId fragmentId) {
            return this.getChildren(StageManager.getStageId(this.queryStateMachine.getQueryId(), fragmentId));
        }

        public Set<SqlStage> getChildren(StageId stageId) {
            return (Set)this.children.get(stageId).stream().map(this::get).collect(ImmutableSet.toImmutableSet());
        }

        public Optional<SqlStage> getParent(PlanFragmentId fragmentId) {
            return this.getParent(StageManager.getStageId(this.queryStateMachine.getQueryId(), fragmentId));
        }

        public Optional<SqlStage> getParent(StageId stageId) {
            return Optional.ofNullable(this.parents.get(stageId)).map(this.stages::get);
        }

        public BasicStageStats getBasicStageStats() {
            List stageStats = (List)this.stages.values().stream().map(SqlStage::getBasicStageStats).collect(ImmutableList.toImmutableList());
            return BasicStageStats.aggregateBasicStageStats(stageStats);
        }

        public StageInfo getStageInfo() {
            Map stageInfos = (Map)this.stages.values().stream().map(SqlStage::getStageInfo).collect(ImmutableMap.toImmutableMap(StageInfo::getStageId, Function.identity()));
            return this.buildStageInfo(this.rootStageId, stageInfos);
        }

        private StageInfo buildStageInfo(StageId stageId, Map<StageId, StageInfo> stageInfos) {
            StageInfo parent = stageInfos.get(stageId);
            Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (String)"No stageInfo for %s", (Object)parent);
            List childStages = (List)this.children.get(stageId).stream().map(childStageId -> this.buildStageInfo((StageId)childStageId, stageInfos)).collect(ImmutableList.toImmutableList());
            if (childStages.isEmpty()) {
                return parent;
            }
            return new StageInfo(parent.getStageId(), parent.getState(), parent.getPlan(), parent.isCoordinatorOnly(), parent.getTypes(), parent.getStageStats(), parent.getTasks(), childStages, parent.getTables(), parent.getFailureCause());
        }

        public long getUserMemoryReservation() {
            return this.stages.values().stream().mapToLong(SqlStage::getUserMemoryReservation).sum();
        }

        public long getTotalMemoryReservation() {
            return this.stages.values().stream().mapToLong(SqlStage::getTotalMemoryReservation).sum();
        }

        public Duration getTotalCpuTime() {
            long millis = this.stages.values().stream().mapToLong(stage -> stage.getTotalCpuTime().toMillis()).sum();
            return new Duration((double)millis, TimeUnit.MILLISECONDS);
        }
    }
}

