/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.base.MoreObjects;
import io.trino.execution.TaskId;
import io.trino.memory.KillTarget;
import io.trino.memory.MemoryInfo;
import io.trino.spi.QueryId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface LowMemoryKiller {
    public Optional<KillTarget> chooseQueryToKill(List<QueryMemoryInfo> var1, List<MemoryInfo> var2);

    public static class QueryMemoryInfo {
        private final QueryId queryId;
        private final long memoryReservation;

        public QueryMemoryInfo(QueryId queryId, long memoryReservation) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.memoryReservation = memoryReservation;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public long getMemoryReservation() {
            return this.memoryReservation;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("memoryReservation", this.memoryReservation).toString();
        }

        public static class TaskMemoryInfo {
            private final TaskId taskId;
            private final long memoryReservation;

            public TaskMemoryInfo(TaskId taskId, long memoryReservation) {
                this.taskId = Objects.requireNonNull(taskId, "taskId is null");
                this.memoryReservation = memoryReservation;
            }

            public TaskId getTaskId() {
                return this.taskId;
            }

            public long getMemoryReservation() {
                return this.memoryReservation;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("memoryReservation", this.memoryReservation).toString();
            }
        }
    }
}

