/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import java.util.Optional;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"deprecated.legacy-system-pool-enabled", "experimental.reserved-pool-disabled", "experimental.reserved-pool-enabled", "query.max-total-memory-per-node"})
public class NodeMemoryConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    public static final String QUERY_MAX_MEMORY_PER_NODE_CONFIG = "query.max-memory-per-node";
    public static final String QUERY_MAX_MEMORY_PER_TASK_CONFIG = "query.max-memory-per-task";
    private DataSize maxQueryMemoryPerNode = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3));
    private Optional<DataSize> maxQueryMemoryPerTask = Optional.empty();
    private DataSize heapHeadroom = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.3));

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public NodeMemoryConfig setMaxQueryMemoryPerNode(DataSize maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = maxQueryMemoryPerNode;
        return this;
    }

    @NotNull
    public Optional<DataSize> getMaxQueryMemoryPerTask() {
        return this.maxQueryMemoryPerTask;
    }

    @Config(value="query.max-memory-per-task")
    @LegacyConfig(value={"query.max-total-memory-per-task"})
    @ConfigDescription(value="Sets memory limit enforced for a single task; there is no memory limit by default")
    public NodeMemoryConfig setMaxQueryMemoryPerTask(DataSize maxQueryMemoryPerTask) {
        this.maxQueryMemoryPerTask = Optional.ofNullable(maxQueryMemoryPerTask);
        return this;
    }

    @NotNull
    public DataSize getHeapHeadroom() {
        return this.heapHeadroom;
    }

    @Config(value="memory.heap-headroom-per-node")
    @ConfigDescription(value="The amount of heap memory to set aside as headroom/buffer (e.g., for untracked allocations)")
    public NodeMemoryConfig setHeapHeadroom(DataSize heapHeadroom) {
        this.heapHeadroom = heapHeadroom;
        return this;
    }
}

