/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.spi.QueryId;
import java.util.List;
import java.util.Optional;

public class TotalReservationLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<KillTarget> chooseQueryToKill(List<LowMemoryKiller.QueryMemoryInfo> runningQueries, List<MemoryInfo> nodes) {
        Optional<QueryId> biggestQuery = Optional.empty();
        long maxMemory = 0L;
        for (LowMemoryKiller.QueryMemoryInfo query : runningQueries) {
            long bytesUsed = query.getMemoryReservation();
            if (bytesUsed <= maxMemory) continue;
            biggestQuery = Optional.of(query.getQueryId());
            maxMemory = bytesUsed;
        }
        return biggestQuery.map(KillTarget::wholeQuery);
    }
}

