/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.Catalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.ViewInfo;
import io.trino.security.AccessControl;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.security.GrantInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class MetadataListing {
    private MetadataListing() {
    }

    public static SortedMap<String, CatalogName> listCatalogs(Session session, Metadata metadata, AccessControl accessControl) {
        return MetadataListing.listCatalogs(session, metadata, accessControl, Optional.empty());
    }

    public static SortedMap<String, CatalogName> listCatalogs(Session session, Metadata metadata, AccessControl accessControl, Optional<String> catalogName) {
        Map catalogNames;
        if (catalogName.isPresent()) {
            Optional<CatalogName> catalogHandle = metadata.getCatalogHandle(session, catalogName.get());
            if (catalogHandle.isEmpty()) {
                return ImmutableSortedMap.of();
            }
            catalogNames = ImmutableSortedMap.of((Comparable)((Object)catalogName.get()), (Object)catalogHandle.get());
        } else {
            catalogNames = (Map)metadata.getCatalogs(session).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Catalog)entry.getValue()).getConnectorCatalogName()));
        }
        Set<String> allowedCatalogs = accessControl.filterCatalogs(session.toSecurityContext(), catalogNames.keySet());
        ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry2 : catalogNames.entrySet()) {
            if (!allowedCatalogs.contains(entry2.getKey())) continue;
            result.put(entry2);
        }
        return result.build();
    }

    public static SortedMap<String, Catalog> getCatalogs(Session session, Metadata metadata, AccessControl accessControl) {
        Map<String, Catalog> catalogs = metadata.getCatalogs(session);
        Set<String> allowedCatalogs = accessControl.filterCatalogs(session.toSecurityContext(), catalogs.keySet());
        ImmutableSortedMap.Builder result = ImmutableSortedMap.naturalOrder();
        for (Map.Entry<String, Catalog> entry : catalogs.entrySet()) {
            if (!allowedCatalogs.contains(entry.getKey())) continue;
            result.put(entry);
        }
        return result.build();
    }

    public static SortedSet<String> listSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName) {
        return MetadataListing.listSchemas(session, metadata, accessControl, catalogName, Optional.empty());
    }

    public static SortedSet<String> listSchemas(Session session, Metadata metadata, AccessControl accessControl, String catalogName, Optional<String> schemaName) {
        ImmutableSet schemaNames = ImmutableSet.copyOf(metadata.listSchemaNames(session, catalogName));
        if (schemaName.isPresent()) {
            if (!schemaNames.contains(schemaName.get())) {
                return ImmutableSortedSet.of();
            }
            schemaNames = ImmutableSet.of((Object)schemaName.get());
        }
        return ImmutableSortedSet.copyOf(accessControl.filterSchemas(session.toSecurityContext(), catalogName, (Set<String>)schemaNames));
    }

    public static Set<SchemaTableName> listTables(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listTables(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Set<SchemaTableName> listViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listViews(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Map<SchemaTableName, ViewInfo> getViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map views = (Map)metadata.getViews(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> accessible = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), views.keySet());
        return (Map)views.entrySet().stream().filter(entry -> accessible.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Set<SchemaTableName> listMaterializedViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Set tableNames = (Set)metadata.listMaterializedViews(session, prefix).stream().map(QualifiedObjectName::asSchemaTableName).collect(ImmutableSet.toImmutableSet());
        return accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableNames);
    }

    public static Map<SchemaTableName, ViewInfo> getMaterializedViews(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        Map materializedViews = (Map)metadata.getMaterializedViews(session, prefix).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((QualifiedObjectName)entry.getKey()).asSchemaTableName(), Map.Entry::getValue));
        Set<SchemaTableName> accessible = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), materializedViews.keySet());
        return (Map)materializedViews.entrySet().stream().filter(entry -> accessible.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Set<GrantInfo> listTablePrivileges(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        List<GrantInfo> grants = metadata.listTablePrivileges(session, prefix);
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), (Set)grants.stream().map(GrantInfo::getSchemaTableName).collect(ImmutableSet.toImmutableSet()));
        return (Set)grants.stream().filter(grantInfo -> allowedTables.contains(grantInfo.getSchemaTableName())).collect(ImmutableSet.toImmutableSet());
    }

    public static Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(Session session, Metadata metadata, AccessControl accessControl, QualifiedTablePrefix prefix) {
        List<TableColumnsMetadata> catalogColumns = metadata.listTableColumns(session, prefix);
        Map tableColumns = (Map)catalogColumns.stream().collect(ImmutableMap.toImmutableMap(TableColumnsMetadata::getTable, TableColumnsMetadata::getColumns));
        Set<SchemaTableName> allowedTables = accessControl.filterTables(session.toSecurityContext(), prefix.getCatalogName(), tableColumns.keySet());
        ImmutableMap.Builder result = ImmutableMap.builder();
        tableColumns.forEach((table, columnsOptional) -> {
            List<ColumnMetadata> columns;
            if (!allowedTables.contains(table)) {
                return;
            }
            QualifiedObjectName originalTableName = new QualifiedObjectName(prefix.getCatalogName(), table.getSchemaName(), table.getTableName());
            Optional<Object> targetTableName = Optional.empty();
            if (columnsOptional.isPresent()) {
                columns = (List<ColumnMetadata>)columnsOptional.get();
            } else {
                boolean redirectionSucceeded;
                TableHandle targetTableHandle;
                block7: {
                    targetTableHandle = null;
                    redirectionSucceeded = false;
                    try {
                        RedirectionAwareTableHandle redirection = metadata.getRedirectionAwareTableHandle(session, originalTableName);
                        targetTableName = redirection.getRedirectedTableName();
                        if (targetTableName.isPresent()) {
                            redirectionSucceeded = true;
                            targetTableHandle = redirection.getTableHandle().orElseThrow();
                        }
                    }
                    catch (TrinoException e) {
                        if (e.getErrorCode().equals((Object)StandardErrorCode.TABLE_REDIRECTION_ERROR.toErrorCode())) break block7;
                        throw e;
                    }
                }
                if (!redirectionSucceeded) {
                    return;
                }
                columns = metadata.getTableMetadata(session, targetTableHandle).getColumns();
            }
            Set<String> allowedColumns = accessControl.filterColumns(session.toSecurityContext(), targetTableName.orElse(originalTableName).asCatalogSchemaTableName(), (Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet()));
            result.put(table, (Object)((List)columns.stream().filter(column -> allowedColumns.contains(column.getName())).collect(ImmutableList.toImmutableList())));
        });
        return result.buildOrThrow();
    }
}

