/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.PropertyUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.PlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Property;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TableProceduresPropertyManager {
    private final ConcurrentMap<Key, Map<String, PropertyMetadata<?>>> connectorProperties = new ConcurrentHashMap();

    public void addProperties(CatalogName catalogName, String procedureName, List<PropertyMetadata<?>> properties) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(procedureName, "procedureName is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(properties, PropertyMetadata::getName);
        Key propertiesKey = new Key(catalogName, procedureName);
        Preconditions.checkState((this.connectorProperties.putIfAbsent(propertiesKey, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"Properties for key %s are already registered", (Object)propertiesKey);
    }

    public void removeProperties(CatalogName catalogName) {
        Set keysToRemove = (Set)this.connectorProperties.keySet().stream().filter(key -> catalogName.equals(key.getCatalogName())).collect(ImmutableSet.toImmutableSet());
        for (Key key2 : keysToRemove) {
            this.connectorProperties.remove(key2);
        }
    }

    public Map<String, Object> getProperties(CatalogName catalog, String procedureName, Map<String, Expression> sqlPropertyValues, Session session, PlannerContext plannerContext, AccessControl accessControl, Map<NodeRef<Parameter>, Expression> parameters) {
        Map supportedProperties = (Map)this.connectorProperties.get(new Key(catalog, procedureName));
        if (supportedProperties == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Catalog '%s' table procedure '%s' property not found", catalog, procedureName));
        }
        Map<String, Optional<Object>> propertyValues = PropertyUtil.evaluateProperties((Iterable)sqlPropertyValues.entrySet().stream().map(entry -> new Property(new Identifier((String)entry.getKey()), (Expression)entry.getValue())).collect(ImmutableList.toImmutableList()), session, plannerContext, accessControl, parameters, true, supportedProperties, (ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("catalog '%s' table procedure '%s' property", catalog, procedureName));
        return (Map)propertyValues.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).orElseThrow()));
    }

    static final class Key {
        private final CatalogName catalogName;
        private final String procedureName;

        private Key(CatalogName catalogName, String procedureName) {
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
            this.procedureName = Objects.requireNonNull(procedureName, "procedureName is null");
        }

        public CatalogName getCatalogName() {
            return this.catalogName;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String toString() {
            return this.catalogName + ":" + this.procedureName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.catalogName, key.catalogName) && Objects.equals(this.procedureName, key.procedureName);
        }

        public int hashCode() {
            return Objects.hash(this.catalogName, this.procedureName);
        }
    }
}

