/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.BasicWorkProcessorOperatorAdapter;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.TopNProcessor;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TopNOperator
implements WorkProcessorOperator {
    private final TopNProcessor topNProcessor;
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        return BasicWorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, types, n, sortChannels, sortOrders, typeOperators));
    }

    private TopNOperator(MemoryTrackingContext memoryTrackingContext, WorkProcessor<Page> sourcePages, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
        this.topNProcessor = new TopNProcessor(Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null").aggregateUserMemoryContext(), types, n, sortChannels, sortOrders, typeOperators);
        this.pages = n == 0 ? WorkProcessor.of(new Page[0]) : sourcePages.transform(new TopNPages());
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    private class TopNPages
    implements WorkProcessor.Transformation<Page, Page> {
        private TopNPages() {
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            if (inputPage != null) {
                TopNOperator.this.topNProcessor.addInput(inputPage);
                return WorkProcessor.TransformationState.needsMoreData();
            }
            Page page = null;
            while (page == null && !TopNOperator.this.topNProcessor.noMoreOutput()) {
                page = TopNOperator.this.topNProcessor.getOutput();
            }
            if (page != null) {
                return WorkProcessor.TransformationState.ofResult(page, false);
            }
            return WorkProcessor.TransformationState.finished();
        }
    }

    private static class Factory
    implements BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final int n;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private final TypeOperators typeOperators;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, TypeOperators typeOperators) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
            this.n = n;
            this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
            this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
            this.typeOperators = typeOperators;
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new TopNOperator(processorContext.getMemoryTrackingContext(), sourcePages, this.sourceTypes, this.n, this.sortChannels, this.sortOrders, this.typeOperators);
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return TopNOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.sourceTypes, this.n, this.sortChannels, this.sortOrders, this.typeOperators);
        }
    }
}

