/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.state.BlockPositionState;
import io.trino.operator.aggregation.state.BlockPositionStateSerializer;
import io.trino.operator.aggregation.state.GenericBooleanState;
import io.trino.operator.aggregation.state.GenericBooleanStateSerializer;
import io.trino.operator.aggregation.state.GenericDoubleState;
import io.trino.operator.aggregation.state.GenericDoubleStateSerializer;
import io.trino.operator.aggregation.state.GenericLongState;
import io.trino.operator.aggregation.state.GenericLongStateSerializer;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Failures;
import io.trino.util.MinMaxCompare;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMinMaxAggregationFunction
extends SqlAggregationFunction {
    private static final MethodHandle LONG_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, GenericLongState.class, Long.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, GenericDoubleState.class, Double.TYPE);
    private static final MethodHandle BOOLEAN_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, GenericBooleanState.class, Boolean.TYPE);
    private static final MethodHandle BLOCK_POSITION_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, BlockPositionState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_OUTPUT_FUNCTION = Reflection.methodHandle(GenericLongState.class, "write", Type.class, GenericLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_OUTPUT_FUNCTION = Reflection.methodHandle(GenericDoubleState.class, "write", Type.class, GenericDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_OUTPUT_FUNCTION = Reflection.methodHandle(GenericBooleanState.class, "write", Type.class, GenericBooleanState.class, BlockBuilder.class);
    private static final MethodHandle BLOCK_POSITION_OUTPUT_FUNCTION = Reflection.methodHandle(BlockPositionState.class, "write", Type.class, BlockPositionState.class, BlockBuilder.class);
    private static final MethodHandle LONG_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, GenericLongState.class, GenericLongState.class);
    private static final MethodHandle DOUBLE_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, GenericDoubleState.class, GenericDoubleState.class);
    private static final MethodHandle BOOLEAN_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, GenericBooleanState.class, GenericBooleanState.class);
    private static final MethodHandle BLOCK_POSITION_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, BlockPositionState.class, BlockPositionState.class);
    private final boolean min;

    protected AbstractMinMaxAggregationFunction(String name, boolean min, String description) {
        super(new FunctionMetadata(new Signature(name, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("E", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false)), false, true, description, FunctionKind.AGGREGATE), new AggregationFunctionMetadata(false, new TypeSignature("E", new TypeSignatureParameter[0])));
        this.min = min;
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return MinMaxCompare.getMinMaxCompareFunctionDependencies(new TypeSignature("E", new TypeSignatureParameter[0]), this.min);
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        MethodHandle outputFunction;
        MethodHandle combineFunction;
        MethodHandle inputFunction;
        AggregationMetadata.AccumulatorStateDescriptor<Object> accumulatorStateDescriptor;
        Type type = boundSignature.getArgumentTypes().get(0);
        InvocationConvention invocationConvention = type.getJavaType().isPrimitive() ? InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}) : InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION});
        MethodHandle compareMethodHandle = MinMaxCompare.getMinMaxCompare(functionDependencies, type, invocationConvention, this.min);
        if (type.getJavaType() == Long.TYPE) {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<GenericLongState>(GenericLongState.class, new GenericLongStateSerializer(type), StateCompiler.generateStateFactory(GenericLongState.class));
            inputFunction = LONG_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = LONG_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = LONG_OUTPUT_FUNCTION.bindTo(type);
        } else if (type.getJavaType() == Double.TYPE) {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<GenericDoubleState>(GenericDoubleState.class, new GenericDoubleStateSerializer(type), StateCompiler.generateStateFactory(GenericDoubleState.class));
            inputFunction = DOUBLE_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = DOUBLE_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = DOUBLE_OUTPUT_FUNCTION.bindTo(type);
        } else if (type.getJavaType() == Boolean.TYPE) {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<GenericBooleanState>(GenericBooleanState.class, new GenericBooleanStateSerializer(type), StateCompiler.generateStateFactory(GenericBooleanState.class));
            inputFunction = BOOLEAN_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = BOOLEAN_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = BOOLEAN_OUTPUT_FUNCTION.bindTo(type);
        } else {
            accumulatorStateDescriptor = new AggregationMetadata.AccumulatorStateDescriptor<BlockPositionState>(BlockPositionState.class, new BlockPositionStateSerializer(type), StateCompiler.generateStateFactory(BlockPositionState.class));
            inputFunction = BLOCK_POSITION_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = BLOCK_POSITION_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = BLOCK_POSITION_OUTPUT_FUNCTION.bindTo(type);
        }
        inputFunction = AggregationFunctionAdapter.normalizeInputMethod(inputFunction, boundSignature, AbstractMinMaxAggregationFunction.createInputParameterKinds(type));
        return new AggregationMetadata(inputFunction, Optional.empty(), Optional.of(combineFunction), outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(accumulatorStateDescriptor));
    }

    private static List<AggregationFunctionAdapter.AggregationParameterKind> createInputParameterKinds(Type type) {
        if (type.getJavaType().isPrimitive()) {
            return ImmutableList.of((Object)((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE), (Object)((Object)AggregationFunctionAdapter.AggregationParameterKind.INPUT_CHANNEL));
        }
        return ImmutableList.of((Object)((Object)AggregationFunctionAdapter.AggregationParameterKind.STATE), (Object)((Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INPUT_CHANNEL), (Object)((Object)AggregationFunctionAdapter.AggregationParameterKind.BLOCK_INDEX));
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, GenericDoubleState state, double value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, GenericLongState state, long value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, GenericBooleanState state, boolean value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, BlockPositionState state, Block block, int position) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, block, position);
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, GenericLongState state, GenericLongState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getValue());
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, GenericDoubleState state, GenericDoubleState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getValue());
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, GenericBooleanState state, GenericBooleanState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getValue());
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, BlockPositionState state, BlockPositionState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getBlock(), otherState.getPosition());
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, GenericLongState state, long value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setValue(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getValue())) {
                state.setValue(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, GenericDoubleState state, double value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setValue(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getValue())) {
                state.setValue(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, GenericBooleanState state, boolean value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setValue(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getValue())) {
                state.setValue(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, BlockPositionState state, Block block, int position) {
        if (state.isNull()) {
            state.setBlock(block);
            state.setPosition(position);
            return;
        }
        try {
            if (methodHandle.invokeExact(block, position, state.getBlock(), state.getPosition())) {
                state.setBlock(block);
                state.setPosition(position);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

