/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.DoubleHistogramAggregation;
import io.trino.operator.aggregation.NumericHistogram;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class NumericHistogramStateFactory
implements AccumulatorStateFactory<DoubleHistogramAggregation.State> {
    public DoubleHistogramAggregation.State createSingleState() {
        return new SingleState();
    }

    public DoubleHistogramAggregation.State createGroupedState() {
        return new GroupedState();
    }

    public static class SingleState
    implements DoubleHistogramAggregation.State {
        private NumericHistogram histogram;

        @Override
        public NumericHistogram get() {
            return this.histogram;
        }

        @Override
        public void set(NumericHistogram value) {
            this.histogram = value;
        }

        public long getEstimatedSize() {
            if (this.histogram == null) {
                return 0L;
            }
            return this.histogram.estimatedInMemorySize();
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements DoubleHistogramAggregation.State {
        private final ObjectBigArray<NumericHistogram> histograms = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.histograms.ensureCapacity(size);
        }

        @Override
        public NumericHistogram get() {
            return (NumericHistogram)this.histograms.get(this.getGroupId());
        }

        @Override
        public void set(NumericHistogram value) {
            Objects.requireNonNull(value, "value is null");
            NumericHistogram previous = this.get();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.histograms.set(this.getGroupId(), (Object)value);
            this.size += value.estimatedInMemorySize();
        }

        public long getEstimatedSize() {
            return this.size + this.histograms.sizeOf();
        }
    }
}

