/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class TypedKeyValueHeap {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedKeyValueHeap.class).instanceSize();
    private static final int COMPACT_THRESHOLD_BYTES = 32768;
    private static final int COMPACT_THRESHOLD_RATIO = 3;
    private final MethodHandle keyGreaterThan;
    private final Type keyType;
    private final Type valueType;
    private final int capacity;
    private int positionCount;
    private final int[] heapIndex;
    private BlockBuilder keyBlockBuilder;
    private BlockBuilder valueBlockBuilder;

    public TypedKeyValueHeap(MethodHandle keyGreaterThan, Type keyType, Type valueType, int capacity) {
        this.keyGreaterThan = keyGreaterThan;
        this.keyType = keyType;
        this.valueType = valueType;
        this.capacity = capacity;
        this.heapIndex = new int[capacity];
        this.keyBlockBuilder = keyType.createBlockBuilder(null, capacity);
        this.valueBlockBuilder = valueType.createBlockBuilder(null, capacity);
    }

    private TypedKeyValueHeap(MethodHandle keyGreaterThan, Type keyType, Type valueType, int capacity, int positionCount, int[] heapIndex, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder) {
        this.keyGreaterThan = keyGreaterThan;
        this.keyType = keyType;
        this.valueType = valueType;
        this.capacity = capacity;
        this.positionCount = positionCount;
        this.heapIndex = heapIndex;
        this.keyBlockBuilder = keyBlockBuilder;
        this.valueBlockBuilder = valueBlockBuilder;
    }

    public static Type getSerializedType(Type keyType, Type valueType) {
        return RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)new ArrayType(keyType), (Object)new ArrayType(valueType)));
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((int[])this.heapIndex);
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder blockBuilder = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(blockBuilder, (long)this.getCapacity());
        BlockBuilder keyElements = blockBuilder.beginBlockEntry();
        for (int i = 0; i < this.positionCount; ++i) {
            this.keyType.appendTo((Block)this.keyBlockBuilder, this.heapIndex[i], keyElements);
        }
        blockBuilder.closeEntry();
        BlockBuilder valueElements = blockBuilder.beginBlockEntry();
        for (int i = 0; i < this.positionCount; ++i) {
            this.valueType.appendTo((Block)this.valueBlockBuilder, this.heapIndex[i], valueElements);
        }
        blockBuilder.closeEntry();
        out.closeEntry();
    }

    public static TypedKeyValueHeap deserialize(Block block, Type keyType, Type valueType, MethodHandle keyComparisonOperator) {
        int capacity = Math.toIntExact(BigintType.BIGINT.getLong(block, 0));
        Block keysBlock = new ArrayType(keyType).getObject(block, 1);
        Block valuesBlock = new ArrayType(valueType).getObject(block, 2);
        TypedKeyValueHeap heap = new TypedKeyValueHeap(keyComparisonOperator, keyType, valueType, capacity);
        heap.addAll(keysBlock, valuesBlock);
        return heap;
    }

    public void popAll(BlockBuilder resultBlockBuilder) {
        while (this.positionCount > 0) {
            this.pop(resultBlockBuilder);
        }
    }

    public void pop(BlockBuilder resultBlockBuilder) {
        this.valueType.appendTo((Block)this.valueBlockBuilder, this.heapIndex[0], resultBlockBuilder);
        this.remove();
    }

    private void remove() {
        --this.positionCount;
        this.heapIndex[0] = this.heapIndex[this.positionCount];
        this.siftDown();
    }

    public void add(Block keyBlock, Block valueBlock, int position) {
        Preconditions.checkArgument((!keyBlock.isNull(position) ? 1 : 0) != 0);
        if (this.positionCount == this.capacity) {
            if (this.keyGreaterThanOrEqual((Block)this.keyBlockBuilder, this.heapIndex[0], keyBlock, position)) {
                return;
            }
            this.heapIndex[0] = this.keyBlockBuilder.getPositionCount();
            this.keyType.appendTo(keyBlock, position, this.keyBlockBuilder);
            this.valueType.appendTo(valueBlock, position, this.valueBlockBuilder);
            this.siftDown();
        } else {
            this.heapIndex[this.positionCount] = this.keyBlockBuilder.getPositionCount();
            ++this.positionCount;
            this.keyType.appendTo(keyBlock, position, this.keyBlockBuilder);
            this.valueType.appendTo(valueBlock, position, this.valueBlockBuilder);
            this.siftUp();
        }
        this.compactIfNecessary();
    }

    public void addAll(TypedKeyValueHeap otherHeap) {
        this.addAll((Block)otherHeap.keyBlockBuilder, (Block)otherHeap.valueBlockBuilder);
    }

    public void addAll(Block keysBlock, Block valuesBlock) {
        for (int i = 0; i < keysBlock.getPositionCount(); ++i) {
            this.add(keysBlock, valuesBlock, i);
        }
    }

    private void siftDown() {
        int leftPosition;
        int position = 0;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.keyGreaterThanOrEqual((Block)this.keyBlockBuilder, this.heapIndex[leftPosition], (Block)this.keyBlockBuilder, this.heapIndex[rightPosition]) ? rightPosition : leftPosition;
            }
            if (this.keyGreaterThanOrEqual((Block)this.keyBlockBuilder, this.heapIndex[smallerChildPosition], (Block)this.keyBlockBuilder, this.heapIndex[position])) break;
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[smallerChildPosition];
            this.heapIndex[smallerChildPosition] = swapTemp;
            position = smallerChildPosition;
        }
    }

    private void siftUp() {
        int parentPosition;
        int position = this.positionCount - 1;
        while (position != 0 && !this.keyGreaterThanOrEqual((Block)this.keyBlockBuilder, this.heapIndex[position], (Block)this.keyBlockBuilder, this.heapIndex[parentPosition = (position - 1) / 2])) {
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[parentPosition];
            this.heapIndex[parentPosition] = swapTemp;
            position = parentPosition;
        }
    }

    private void compactIfNecessary() {
        if (this.keyBlockBuilder.getSizeInBytes() < 32768L || this.keyBlockBuilder.getPositionCount() / this.positionCount < 3) {
            return;
        }
        BlockBuilder newHeapKeyBlockBuilder = this.keyType.createBlockBuilder(null, this.keyBlockBuilder.getPositionCount());
        BlockBuilder newHeapValueBlockBuilder = this.valueType.createBlockBuilder(null, this.valueBlockBuilder.getPositionCount());
        for (int i = 0; i < this.positionCount; ++i) {
            this.keyType.appendTo((Block)this.keyBlockBuilder, this.heapIndex[i], newHeapKeyBlockBuilder);
            this.valueType.appendTo((Block)this.valueBlockBuilder, this.heapIndex[i], newHeapValueBlockBuilder);
            this.heapIndex[i] = i;
        }
        this.keyBlockBuilder = newHeapKeyBlockBuilder;
        this.valueBlockBuilder = newHeapValueBlockBuilder;
    }

    private boolean keyGreaterThanOrEqual(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        try {
            return !this.keyGreaterThan.invokeExact(rightBlock, rightPosition, leftBlock, leftPosition);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public TypedKeyValueHeap copy() {
        BlockBuilder keyBlockBuilderCopy = null;
        if (this.keyBlockBuilder != null) {
            keyBlockBuilderCopy = (BlockBuilder)this.keyBlockBuilder.copyRegion(0, this.keyBlockBuilder.getPositionCount());
        }
        BlockBuilder valueBlockBuilderCopy = null;
        if (this.valueBlockBuilder != null) {
            valueBlockBuilderCopy = (BlockBuilder)this.valueBlockBuilder.copyRegion(0, this.valueBlockBuilder.getPositionCount());
        }
        return new TypedKeyValueHeap(this.keyGreaterThan, this.keyType, this.valueType, this.capacity, this.positionCount, (int[])this.heapIndex.clone(), keyBlockBuilderCopy, valueBlockBuilderCopy);
    }
}

