/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import com.google.common.collect.ImmutableList;
import io.trino.array.ObjectBigArray;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.TypedSet;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationStateFactory;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.BlockTypeOperators;
import io.trino.type.TypeUtils;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MultimapAggregationFunction
extends SqlAggregationFunction {
    public static final String NAME = "multimap_agg";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "output", Type.class, BlockTypeOperators.BlockPositionEqual.class, BlockTypeOperators.BlockPositionHashCode.class, Type.class, MultimapAggregationState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "combine", MultimapAggregationState.class, MultimapAggregationState.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "input", MultimapAggregationState.class, Block.class, Block.class, Integer.TYPE);
    private static final int EXPECTED_ENTRY_SIZE = 100;
    private final BlockTypeOperators blockTypeOperators;

    public MultimapAggregationFunction(BlockTypeOperators blockTypeOperators) {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)TypeSignature.arrayType((TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)new TypeSignature("V", new TypeSignatureParameter[0])), false), new FunctionNullability(true, (List<Boolean>)ImmutableList.of((Object)false, (Object)true)), false, true, "Aggregates all the rows (key/value pairs) into a single multimap", FunctionKind.AGGREGATE), new AggregationFunctionMetadata(true, TypeSignature.arrayType((TypeSignature)TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), TypeSignatureParameter.anonymousField((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]))}))));
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature) {
        Type keyType = boundSignature.getArgumentType(0);
        BlockTypeOperators.BlockPositionEqual keyEqual = this.blockTypeOperators.getEqualOperator(keyType);
        BlockTypeOperators.BlockPositionHashCode keyHashCode = this.blockTypeOperators.getHashCodeOperator(keyType);
        Type valueType = boundSignature.getArgumentType(1);
        MultimapAggregationStateSerializer stateSerializer = new MultimapAggregationStateSerializer(keyType, valueType);
        return new AggregationMetadata(INPUT_FUNCTION, Optional.empty(), Optional.of(COMBINE_FUNCTION), MethodHandles.insertArguments(OUTPUT_FUNCTION, 0, keyType, keyEqual, keyHashCode, valueType), (List<AggregationMetadata.AccumulatorStateDescriptor<?>>)ImmutableList.of(new AggregationMetadata.AccumulatorStateDescriptor<MultimapAggregationState>(MultimapAggregationState.class, stateSerializer, new MultimapAggregationStateFactory(keyType, valueType))));
    }

    public static void input(MultimapAggregationState state, Block key, Block value, int position) {
        state.add(key, value, position);
    }

    public static void combine(MultimapAggregationState state, MultimapAggregationState otherState) {
        state.merge(otherState);
    }

    public static void output(Type keyType, BlockTypeOperators.BlockPositionEqual keyEqual, BlockTypeOperators.BlockPositionHashCode keyHashCode, Type valueType, MultimapAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ObjectBigArray valueArrayBlockBuilders = new ObjectBigArray();
            valueArrayBlockBuilders.ensureCapacity((long)state.getEntryCount());
            BlockBuilder distinctKeyBlockBuilder = keyType.createBlockBuilder(null, state.getEntryCount(), TypeUtils.expectedValueSize(keyType, 100));
            TypedSet keySet = TypedSet.createEqualityTypedSet(keyType, keyEqual, keyHashCode, state.getEntryCount(), NAME);
            state.forEach((key, value, keyValueIndex) -> {
                if (keySet.add(key, keyValueIndex)) {
                    keyType.appendTo(key, keyValueIndex, distinctKeyBlockBuilder);
                    BlockBuilder valueArrayBuilder = valueType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(valueType, 100));
                    valueArrayBlockBuilders.set((long)keySet.positionOf(key, keyValueIndex), (Object)valueArrayBuilder);
                }
                valueType.appendTo(value, keyValueIndex, (BlockBuilder)valueArrayBlockBuilders.get((long)keySet.positionOf(key, keyValueIndex)));
            });
            ArrayType valueArrayType = new ArrayType(valueType);
            BlockBuilder multimapBlockBuilder = out.beginBlockEntry();
            for (int i = 0; i < distinctKeyBlockBuilder.getPositionCount(); ++i) {
                keyType.appendTo((Block)distinctKeyBlockBuilder, i, multimapBlockBuilder);
                valueArrayType.writeObject(multimapBlockBuilder, (Object)((BlockBuilder)valueArrayBlockBuilders.get((long)i)).build());
            }
            out.closeEntry();
        }
    }
}

